/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.capability.time;

import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.AetherTimeSyncPacket;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Triple;

public class AetherTimeCapability
implements AetherTime {
    private final Level level;
    private long dayTime = 18000L;
    private boolean isEternalDay = true;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("setEternalDay", Triple.of((Object)INBTSynchable.Type.BOOLEAN, object -> this.setEternalDay((Boolean)object), this::getEternalDay)));

    public AetherTimeCapability(Level level) {
        this.level = level;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128356_("DayTime", this.level.m_46468_());
        tag.m_128379_("EternalDay", this.getEternalDay());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("DayTime")) {
            this.setDayTime(tag.m_128454_("DayTime"));
        }
        if (tag.m_128441_("EternalDay")) {
            this.setEternalDay(tag.m_128471_("EternalDay"));
        }
    }

    @Override
    public long tickTime(Level level) {
        long dayTime = level.m_46468_();
        if (this.getEternalDay()) {
            if (dayTime != 18000L) {
                long tempTime = dayTime % 72000L;
                if (tempTime > 54000L) {
                    tempTime -= 72000L;
                }
                long target = (long)Mth.m_14036_((float)(18000L - tempTime), (float)-10.0f, (float)10.0f);
                dayTime += target;
            }
        } else {
            ++dayTime;
        }
        return dayTime;
    }

    @Override
    public void updateEternalDay() {
        this.setSynched(INBTSynchable.Direction.DIMENSION, "setEternalDay", this.isEternalDay, this.level.m_46472_());
    }

    @Override
    public void updateEternalDay(ServerPlayer player) {
        this.setSynched(INBTSynchable.Direction.PLAYER, "setEternalDay", this.isEternalDay, player);
    }

    @Override
    public void setDayTime(long time) {
        this.dayTime = time;
    }

    @Override
    public long getDayTime() {
        return this.dayTime;
    }

    @Override
    public void setEternalDay(boolean isEternalDay) {
        this.isEternalDay = isEternalDay;
    }

    @Override
    public boolean getEternalDay() {
        return this.isEternalDay;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new AetherTimeSyncPacket(key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return AetherPacketHandler.INSTANCE;
    }
}

