/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.mixin.mixins.client.accessor.GuiAccessor;
import com.aetherteam.aether.mixin.mixins.client.accessor.HeartTypeAccessor;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aether", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class AetherOverlays {
    private static final ResourceLocation TEXTURE_INEBRIATION_VIGNETTE = new ResourceLocation("aether", "textures/blur/inebriation_vignette.png");
    private static final ResourceLocation TEXTURE_REMEDY_VIGNETTE = new ResourceLocation("aether", "textures/blur/remedy_vignette.png");
    private static final ResourceLocation TEXTURE_SHIELD_OF_REPULSION_VIGNETTE = new ResourceLocation("aether", "textures/blur/shield_of_repulsion_vignette.png");
    private static final ResourceLocation TEXTURE_COOLDOWN_BAR = new ResourceLocation("aether", "textures/gui/cooldown_bar.png");
    private static final ResourceLocation TEXTURE_JUMPS = new ResourceLocation("aether", "textures/gui/jumps.png");
    private static final ResourceLocation TEXTURE_LIFE_SHARD_HEARTS = new ResourceLocation("aether", "textures/gui/life_shard_hearts.png");

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("aether_portal_overlay", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderAetherPortalOverlay(pStack, minecraft, window, handler, partialTicks));
            }
        });
        event.registerAboveAll("inebriation_vignette", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderInebriationOverlay(pStack, minecraft, window, handler));
            }
        });
        event.registerAboveAll("remedy_vignette", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderRemedyOverlay(pStack, minecraft, window, handler));
            }
        });
        event.registerAboveAll("shield_of_repulsion_vignette", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherPlayer.get((Player)player).ifPresent(handler -> AetherOverlays.renderRepulsionOverlay(pStack, minecraft, window, handler));
            }
        });
        event.registerAboveAll("hammer_cooldown", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherOverlays.renderHammerCooldownOverlay(pStack, minecraft, window, player);
            }
        });
        event.registerAboveAll("moa_jumps", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherOverlays.renderMoaJumps(pStack, window, player);
            }
        });
        event.registerAbove(new ResourceLocation("player_health"), "silver_life_shard_hearts", (gui, pStack, partialTicks, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                AetherOverlays.renderSilverLifeShardHearts(pStack, gui, player, screenWidth, screenHeight);
            }
        });
    }

    private static void renderAetherPortalOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, AetherPlayer handler, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        float timeInPortal = handler.getPrevPortalAnimTime() + (handler.getPortalAnimTime() - handler.getPrevPortalAnimTime()) * partialTicks;
        if (timeInPortal > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            poseStack.m_85836_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            TextureAtlasSprite textureAtlasSprite = minecraft.m_91289_().m_110907_().m_110882_(((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).m_49966_());
            guiGraphics.m_280565_(0, 0, -90, window.m_85445_(), window.m_85446_(), textureAtlasSprite, 1.0f, 1.0f, 1.0f, timeInPortal);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            poseStack.m_85849_();
        }
    }

    private static void renderInebriationOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, AetherPlayer handler) {
        Player player = handler.getPlayer();
        MobEffectInstance inebriation = player.m_21124_((MobEffect)AetherEffects.INEBRIATION.get());
        double effectScale = (Double)minecraft.f_91066_.m_231924_().m_231551_();
        if (inebriation != null) {
            float inebriationDuration = (float)(inebriation.m_19557_() % 50) / 50.0f;
            float alpha = inebriationDuration * inebriationDuration / 5.0f + 0.4f;
            AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_INEBRIATION_VIGNETTE);
        }
    }

    private static void renderRemedyOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, AetherPlayer handler) {
        Player player = handler.getPlayer();
        MobEffectInstance remedy = player.m_21124_((MobEffect)AetherEffects.REMEDY.get());
        double effectScale = (Double)minecraft.f_91066_.m_231924_().m_231551_();
        if (remedy != null) {
            int remedyStartDuration = handler.getRemedyStartDuration();
            int remedyDuration = remedy.m_19557_();
            if (remedyStartDuration > 0 && remedyDuration > 0) {
                float alpha = (float)remedyDuration / (float)remedyStartDuration / 1.5f;
                AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_REMEDY_VIGNETTE);
            }
        }
    }

    private static void renderRepulsionOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, AetherPlayer handler) {
        int projectileImpactedMaximum = handler.getProjectileImpactedMaximum();
        int projectileImpactedTimer = handler.getProjectileImpactedTimer();
        double effectScale = (Double)minecraft.f_91066_.m_231924_().m_231551_();
        if (projectileImpactedTimer > 0) {
            float alpha = (float)projectileImpactedTimer / (float)projectileImpactedMaximum;
            AetherOverlays.renderVignette(guiGraphics, window, effectScale, alpha, TEXTURE_SHIELD_OF_REPULSION_VIGNETTE);
        }
    }

    private static void renderVignette(GuiGraphics guiGraphics, Window window, double effectScale, float alpha, ResourceLocation resource) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        alpha = (float)((double)alpha * Math.sqrt(effectScale));
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        guiGraphics.m_280398_(resource, 0, 0, -90, 0.0f, 0.0f, window.m_85445_(), window.m_85446_(), window.m_85445_(), window.m_85446_());
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }

    private static void renderHammerCooldownOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, LocalPlayer player) {
        Inventory inventory;
        if (((Boolean)AetherConfig.CLIENT.enable_hammer_cooldown_overlay.get()).booleanValue() && (inventory = player.m_150109_()).m_216874_(itemStack -> itemStack.m_150930_((Item)AetherItems.HAMMER_OF_KINGBDOGZ.get()))) {
            for (ItemStack itemStack2 : inventory.f_35974_) {
                float cooldownPercent;
                Item item = itemStack2.m_41720_();
                if (item != AetherItems.HAMMER_OF_KINGBDOGZ.get() || !((cooldownPercent = player.m_36335_().m_41521_(item, 0.0f)) > 0.0f)) continue;
                if (player.m_21205_().m_41720_() == item) {
                    itemStack2 = player.m_21205_();
                } else if (player.m_21206_().m_41720_() == item) {
                    itemStack2 = player.m_21206_();
                }
                String text = itemStack2.m_41786_().getString().concat(" ").concat(Component.m_237115_((String)"aether.hammer_of_kingbdogz_cooldown").getString());
                guiGraphics.m_280488_(minecraft.f_91062_, text, (int)((float)window.m_85445_() / 2.0f - (float)minecraft.f_91062_.m_92895_(text) / 2.0f), 32, 0xFFFFFF);
                guiGraphics.m_280163_(TEXTURE_COOLDOWN_BAR, window.m_85445_() / 2 - 64, 42, 0.0f, 8.0f, 128, 8, 256, 256);
                guiGraphics.m_280163_(TEXTURE_COOLDOWN_BAR, window.m_85445_() / 2 - 64, 42, 0.0f, 0.0f, (int)(cooldownPercent * 128.0f), 8, 256, 256);
                break;
            }
        }
    }

    private static void renderMoaJumps(GuiGraphics guiGraphics, Window window, LocalPlayer player) {
        Entity entity = player.m_20202_();
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            for (int jumpCount = 0; jumpCount < moa.getMaxJumps(); ++jumpCount) {
                int xPos = window.m_85445_() / 2 + jumpCount * 8 - moa.getMaxJumps() * 8 / 2;
                int yPos = 18;
                if (jumpCount < moa.getRemainingJumps()) {
                    guiGraphics.m_280163_(TEXTURE_JUMPS, xPos, yPos, 0.0f, 0.0f, 9, 11, 256, 256);
                    continue;
                }
                guiGraphics.m_280163_(TEXTURE_JUMPS, xPos, yPos, 10.0f, 0.0f, 9, 11, 256, 256);
            }
        }
    }

    private static void renderSilverLifeShardHearts(GuiGraphics guiGraphics, ForgeGui gui, LocalPlayer player, int width, int height) {
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        if (((Boolean)AetherConfig.CLIENT.enable_silver_hearts.get()).booleanValue() && gui.shouldDrawSurvivalElements()) {
            AetherPlayer.get((Player)player).ifPresent(aetherPlayer -> {
                AttributeInstance attributeInstance;
                Player innerPlayer = aetherPlayer.getPlayer();
                if (aetherPlayer.getLifeShardCount() > 0 && (attributeInstance = innerPlayer.m_21051_(Attributes.f_22276_)) != null) {
                    boolean highlight;
                    int lastLifeShardHealth = 0;
                    int lastOverallHealth = 0;
                    RenderSystem.enableBlend();
                    double overallHealth = attributeInstance.m_22135_();
                    double maxLifeShardHealth = aetherPlayer.getLifeShardHealthAttributeModifier().m_22218_();
                    int maxDefaultHealth = Mth.m_14165_((double)(overallHealth - maxLifeShardHealth));
                    int currentOverallHealth = Mth.m_14167_((float)innerPlayer.m_21223_());
                    int currentLifeShardHealth = Mth.m_14165_((double)(maxDefaultHealth > 20 ? Mth.m_14008_((double)(currentOverallHealth - 20), (double)0.0, (double)maxLifeShardHealth) : (double)Math.min(player.m_21223_(), (float)(currentOverallHealth - maxDefaultHealth))));
                    boolean bl = highlight = guiAccessor.aether$getHealthBlinkTime() > (long)gui.m_93079_() && (guiAccessor.aether$getHealthBlinkTime() - (long)gui.m_93079_()) / 3L % 2L == 1L;
                    if (Util.m_137550_() - guiAccessor.aether$getLastHealthTime() > 1000L) {
                        lastOverallHealth = currentOverallHealth;
                        lastLifeShardHealth = currentLifeShardHealth;
                    }
                    guiAccessor.aether$getRandom().m_188584_((long)(gui.m_93079_() * 312871));
                    float displayOverallHealth = Math.max((float)overallHealth, (float)Math.max(lastOverallHealth, currentOverallHealth));
                    float displayLifeShardHealth = Math.max((float)maxLifeShardHealth, (float)Math.max(lastLifeShardHealth, currentLifeShardHealth));
                    int absorption = Mth.m_14167_((float)innerPlayer.m_6103_());
                    int healthRows = Mth.m_14167_((float)((displayOverallHealth + (float)absorption) / 2.0f / 10.0f));
                    int rowHeight = Math.max(10 - (healthRows - 2), 3);
                    int left = width / 2 - 91;
                    int top = height - 39;
                    int regen = Integer.MIN_VALUE;
                    if (innerPlayer.m_21023_(MobEffects.f_19605_)) {
                        regen = gui.m_93079_() % Mth.m_14167_((float)(displayOverallHealth + 5.0f));
                    }
                    AetherOverlays.renderHearts(guiGraphics, innerPlayer, gui, left, top, regen, displayOverallHealth, displayLifeShardHealth, maxDefaultHealth, currentLifeShardHealth, rowHeight, absorption, highlight);
                    RenderSystem.disableBlend();
                }
            });
        }
    }

    private static void renderHearts(GuiGraphics guiGraphics, Player player, ForgeGui gui, int left, int top, int regen, float displayOverallHealth, float displayLifeShardHealth, int maxDefaultHealth, int lifeShardHealth, int rowHeight, int absorption, boolean highlight) {
        GuiAccessor guiAccessor = (GuiAccessor)gui;
        Gui.HeartType heartType = HeartTypeAccessor.callForPlayer(player);
        int overallHearts = Mth.m_14165_((double)((double)displayOverallHealth / 2.0));
        int lifeShardHearts = Mth.m_14165_((double)((double)displayLifeShardHealth / 2.0));
        int maxDefaultHearts = Mth.m_14165_((double)((double)maxDefaultHealth / 2.0));
        boolean tooManyHearts = overallHearts > 50;
        boolean tooLittleHearts = maxDefaultHearts < 10 && maxDefaultHearts > 0;
        for (int currentHeart = Math.min(overallHearts, lifeShardHearts - 1); currentHeart >= 0; --currentHeart) {
            boolean halfHeart;
            int x = left + (currentHeart + (tooLittleHearts ? overallHearts - lifeShardHearts : 0)) % 10 * 8;
            int y = top - (currentHeart + (tooManyHearts ? 0 : (maxDefaultHearts + currentHeart < 10 ? 0 : 10))) / 10 * rowHeight;
            if (Mth.m_14167_((float)player.m_21223_()) + absorption <= 4) {
                y += guiAccessor.aether$getRandom().m_188503_(2);
            }
            if (currentHeart + (maxDefaultHearts > 10 ? overallHearts - 10 : maxDefaultHearts) < overallHearts && currentHeart + Math.min(maxDefaultHearts, 10) - (tooManyHearts ? overallHearts : 0) == regen) {
                y -= 2;
            }
            int selectedContainer = currentHeart * 2;
            if (highlight && (float)selectedContainer < displayLifeShardHealth) {
                halfHeart = (float)(selectedContainer + 1) == displayLifeShardHealth;
                guiGraphics.m_280218_(TEXTURE_LIFE_SHARD_HEARTS, x, y, heartType.m_168734_(halfHeart, false), 0, 9, 9);
            }
            if (selectedContainer >= lifeShardHealth) continue;
            halfHeart = selectedContainer + 1 == lifeShardHealth;
            guiGraphics.m_280218_(TEXTURE_LIFE_SHARD_HEARTS, x, y, heartType.m_168734_(halfHeart, false), 0, 9, 9);
        }
    }
}

