/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.block;

import com.aetherteam.aether.Aether;
import com.aetherteam.aether.block.Floatable;
import com.aetherteam.aether.block.miscellaneous.FloatingBlock;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.mixin.mixins.common.accessor.ConcretePowderBlockAccessor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;

public class FloatingBlockEntity
extends Entity {
    private static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(FloatingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private BlockState blockState = Blocks.f_49992_.m_49966_();
    private int time;
    private boolean dropItem = true;
    private boolean cancelDrop;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    private int floatDistance;
    @Nullable
    private CompoundTag blockData;
    private boolean natural = true;

    public FloatingBlockEntity(EntityType<? extends FloatingBlockEntity> type, Level level) {
        super(type, level);
    }

    public FloatingBlockEntity(Level level, double x, double y, double z, BlockState state) {
        this((EntityType<? extends FloatingBlockEntity>)((EntityType)AetherEntityTypes.FLOATING_BLOCK.get()), level);
        this.blockState = state;
        this.f_19850_ = true;
        this.m_6034_(x, y + (double)((1.0f - this.m_20206_()) / 2.0f), z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.setStartPos(this.m_20183_());
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public void m_8119_() {
        if (this.getBlockState().m_60795_()) {
            this.m_146870_();
        } else {
            Level level;
            Block block = this.getBlockState().m_60734_();
            if (this.time++ == 0) {
                BlockPos blockPos = this.m_20183_();
                if (this.m_9236_().m_8055_(blockPos).m_60713_(block)) {
                    this.m_9236_().m_7471_(blockPos, false);
                }
            }
            if (!this.m_20068_()) {
                this.floatDistance = this.m_20183_().m_123342_() - this.getStartPos().m_123342_();
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
                this.causeFallDamage();
                if (this.m_9236_().m_5776_()) {
                    this.spawnFloatingBlockParticles();
                }
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.m_9236_().m_5776_() && (level = this.m_9236_()) instanceof ServerLevel) {
                BlockHitResult blockHitResult;
                ServerLevel serverLevel = (ServerLevel)level;
                BlockPos blockPos1 = this.m_20183_();
                boolean isConcrete = this.getBlockState().m_60734_() instanceof ConcretePowderBlock;
                boolean canConvert = isConcrete && this.m_9236_().m_6425_(blockPos1).m_205070_(FluidTags.f_13131_);
                double d0 = this.m_20184_().m_82556_();
                if (isConcrete && d0 > 1.0 && (blockHitResult = this.m_9236_().m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.m_9236_().m_6425_(blockHitResult.m_82425_()).m_205070_(FluidTags.f_13131_)) {
                    blockPos1 = blockHitResult.m_82425_();
                    canConvert = true;
                }
                if (!(this.f_19863_ && !this.m_20096_() || canConvert)) {
                    if (!(this.m_9236_().m_5776_() || (this.time <= 100 || blockPos1.m_123342_() > this.m_9236_().m_141937_() && blockPos1.m_123342_() <= this.m_9236_().m_151558_()) && this.time <= 600)) {
                        if ((!this.natural || !this.getBlockState().m_60834_()) && this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.dropBlock(this.getBlockState());
                        }
                        this.m_146870_();
                    }
                } else {
                    BlockState blockState = this.m_9236_().m_8055_(blockPos1);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!blockState.m_60713_(Blocks.f_50110_)) {
                        if (!this.cancelDrop) {
                            boolean canBlockSurvive;
                            boolean canBeReplaced = blockState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), blockPos1, Direction.UP, ItemStack.f_41583_, Direction.DOWN));
                            boolean isAboveFree = FloatingBlock.isFree(this.m_9236_().m_8055_(blockPos1.m_7494_())) && (!isConcrete || !canConvert);
                            boolean bl = canBlockSurvive = this.getBlockState().m_60710_((LevelReader)this.m_9236_(), blockPos1) && !isAboveFree;
                            if (canBeReplaced && canBlockSurvive || this.natural && blockState.m_60734_().m_155943_() >= 0.0f) {
                                if (this.getBlockState().m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(blockPos1).m_192917_((Fluid)Fluids.f_76193_)) {
                                    this.blockState = (BlockState)this.getBlockState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                                }
                                BlockState previousBlockState = this.m_9236_().m_8055_(blockPos1);
                                if (this.m_9236_().m_7731_(blockPos1, this.getBlockState(), 3)) {
                                    BlockEntity blockEntity;
                                    if (this.natural && !previousBlockState.m_60795_()) {
                                        this.dropBlock(previousBlockState);
                                    }
                                    serverLevel.m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockPos1, this.m_9236_().m_8055_(blockPos1)));
                                    this.m_146870_();
                                    if (block instanceof Floatable) {
                                        Floatable floatable = (Floatable)block;
                                        floatable.onCollide(this.m_9236_(), blockPos1, this.getBlockState(), blockState, this);
                                    } else if (block instanceof ConcretePowderBlock) {
                                        ConcretePowderBlock concretePowderBlock = (ConcretePowderBlock)block;
                                        if (ConcretePowderBlockAccessor.callShouldSolidify((BlockGetter)this.m_9236_(), blockPos1, blockState)) {
                                            ConcretePowderBlockAccessor concretePowderBlockAccessor = (ConcretePowderBlockAccessor)concretePowderBlock;
                                            this.m_9236_().m_7731_(blockPos1, concretePowderBlockAccessor.aether$getConcrete(), 3);
                                        }
                                    } else if (block instanceof AnvilBlock && !this.m_20067_()) {
                                        this.m_9236_().m_46796_(1029, blockPos1, 0);
                                    }
                                    if (this.blockData != null && this.getBlockState().m_155947_() && (blockEntity = this.m_9236_().m_7702_(blockPos1)) != null) {
                                        CompoundTag tag = blockEntity.m_187482_();
                                        for (String string : this.blockData.m_128431_()) {
                                            Tag blockDataTag = this.blockData.m_128423_(string);
                                            if (blockDataTag == null) continue;
                                            tag.m_128365_(string, blockDataTag.m_6426_());
                                        }
                                        try {
                                            blockEntity.m_142466_(tag);
                                        }
                                        catch (Exception exception) {
                                            Aether.LOGGER.error("Failed to load block entity from floating block", (Throwable)exception);
                                        }
                                        blockEntity.m_6596_();
                                    }
                                } else if ((!this.natural || !this.getBlockState().m_60834_()) && this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.m_146870_();
                                    this.callOnBrokenAfterFall(block, blockPos1);
                                    this.dropBlock(this.getBlockState());
                                }
                            } else {
                                this.m_146870_();
                                if ((!this.natural || !this.getBlockState().m_60834_() || blockState.m_60734_().m_155943_() < 0.0f) && this.dropItem && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                                    this.callOnBrokenAfterFall(block, blockPos1);
                                    this.dropBlock(this.getBlockState());
                                }
                            }
                        } else {
                            this.m_146870_();
                            this.callOnBrokenAfterFall(block, blockPos1);
                        }
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    public void setHurtsEntities(float fallDamagePerDistance, int fallDamageMax) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = fallDamagePerDistance;
        this.fallDamageMax = fallDamageMax;
    }

    private void dropBlock(BlockState state) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ItemStack stack : Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)this.m_20183_(), null)) {
                this.m_19983_(stack);
            }
        }
    }

    public void callOnBrokenAfterFall(Block block, BlockPos pos) {
        if (block instanceof Floatable) {
            Floatable floatable = (Floatable)block;
            floatable.onBrokenAfterCollide(this.m_9236_(), pos, this);
        }
    }

    private void causeFallDamage() {
        if (this.hurtEntities) {
            DamageSource damageSource;
            Predicate<Entity> predicate;
            Block block = this.getBlockState().m_60734_();
            if (block instanceof Floatable) {
                Floatable floatable = (Floatable)block;
                predicate = floatable.getHurtsEntitySelector();
                damageSource = floatable.getFallDamageSource(this);
            } else {
                predicate = EntitySelector.f_20408_;
                damageSource = AetherDamageTypes.entityDamageSource(this.m_9236_(), AetherDamageTypes.FLOATING_BLOCK, this);
            }
            float f = Math.min(Mth.m_14143_((float)((float)this.floatDistance * this.fallDamagePerDistance)), this.fallDamageMax);
            this.m_9236_().m_6249_((Entity)this, this.m_20191_(), predicate).forEach(p_149649_ -> p_149649_.m_6469_(damageSource, f));
            boolean flag = this.getBlockState().m_204336_(BlockTags.f_13033_);
            if (flag && f > 0.0f && this.f_19796_.m_188501_() < 0.05f + (float)this.floatDistance * 0.05f) {
                BlockState blockstate = AnvilBlock.m_48824_((BlockState)this.getBlockState());
                if (blockstate == null) {
                    this.cancelDrop = true;
                } else {
                    this.blockState = blockstate;
                }
            }
        }
    }

    private void spawnFloatingBlockParticles() {
        if (this.f_19796_.m_188503_(8) == 0) {
            double d0 = this.m_20185_() - 0.5 + this.f_19796_.m_188500_();
            double d1 = this.m_20186_() - 0.05;
            double d2 = this.m_20189_() - 0.5 + this.f_19796_.m_188500_();
            this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, this.getBlockState()), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void setStartPos(BlockPos pOrigin) {
        this.m_20088_().m_135381_(DATA_START_POS, (Object)pOrigin);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.m_20088_().m_135370_(DATA_START_POS);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    @Nullable
    public Entity changeDimension(ServerLevel destination, ITeleporter teleporter) {
        return null;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6051_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6127_() {
        return true;
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        tag.m_128405_("Time", this.time);
        tag.m_128379_("DropItem", this.dropItem);
        tag.m_128379_("HurtEntities", this.hurtEntities);
        tag.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        tag.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.blockData != null) {
            tag.m_128365_("TileEntityData", (Tag)this.blockData);
        }
        tag.m_128379_("Natural", this.natural);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("BlockState")) {
            this.blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)tag.m_128469_("BlockState"));
        }
        if (tag.m_128441_("Time")) {
            this.time = tag.m_128451_("Time");
        }
        if (tag.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = tag.m_128471_("HurtEntities");
            this.fallDamagePerDistance = tag.m_128457_("FallHurtAmount");
            this.fallDamageMax = tag.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        if (tag.m_128425_("DropItem", 99)) {
            this.dropItem = tag.m_128471_("DropItem");
        }
        if (tag.m_128425_("TileEntityData", 10)) {
            this.blockData = tag.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.blockState = Blocks.f_49992_.m_49966_();
        }
        if (tag.m_128425_("Natural", 99)) {
            this.natural = tag.m_128471_("Natural");
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.blockState = Block.m_49803_((int)packet.m_131509_());
        this.f_19850_ = true;
        double d0 = packet.m_131500_();
        double d1 = packet.m_131501_();
        double d2 = packet.m_131502_();
        this.m_6034_(d0, d1 + (double)((1.0f - this.m_20206_()) / 2.0f), d2);
        this.setStartPos(this.m_20183_());
    }

    public void m_7976_(CrashReportCategory category) {
        super.m_7976_(category);
        category.m_128159_("Immitating BlockState", (Object)this.getBlockState().toString());
    }
}

