/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.passive;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.AerbunnyPuffPacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.simple.SimpleChannel;

public class Aerbunny
extends AetherAnimal {
    private static final EntityDataAccessor<Integer> DATA_PUFFINESS_ID = SynchedEntityData.m_135353_(Aerbunny.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_AFRAID_TIME_ID = SynchedEntityData.m_135353_(Aerbunny.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_FAST_FALLING_ID = SynchedEntityData.m_135353_(Aerbunny.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int MAXIMUM_PUFFS = 11;
    private int puffSubtract;
    @Nullable
    private Vec3 lastPos;

    public Aerbunny(EntityType<? extends Aerbunny> type, Level level) {
        super(type, level);
        this.f_21342_ = new AerbunnyMoveControl(this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RunWhenAfraid(this, 1.3));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(AetherTags.Items.AERBUNNY_TEMPTATION_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 1.0, 80));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 6.0).m_22268_(Attributes.f_22279_, 0.28);
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_PUFFINESS_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_AFRAID_TIME_ID, (Object)0);
        this.m_20088_().m_135372_(DATA_FAST_FALLING_ID, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isFastFalling()) {
            this.handleFallSpeed();
        } else if (this.m_20096_()) {
            this.setFastFalling(false);
        }
        this.setPuffiness(this.getPuffiness() - this.puffSubtract);
        if (this.getPuffiness() > 0) {
            this.puffSubtract = 1;
        } else {
            this.puffSubtract = 0;
            this.setPuffiness(0);
        }
        this.handlePlayerInput();
        boolean blockIntersection = false;
        if (this.m_20202_() != null) {
            AABB vehicleBounds = this.m_20202_().m_20191_();
            BlockPos minPos = BlockPos.m_274561_((double)vehicleBounds.f_82288_, (double)vehicleBounds.f_82289_, (double)vehicleBounds.f_82290_);
            BlockPos maxPos = BlockPos.m_274561_((double)vehicleBounds.f_82291_, (double)vehicleBounds.f_82292_, (double)vehicleBounds.f_82293_);
            for (int x = minPos.m_123341_(); x <= maxPos.m_123341_(); ++x) {
                for (int y = minPos.m_123342_(); y <= maxPos.m_123342_(); ++y) {
                    for (int z = minPos.m_123343_(); z <= maxPos.m_123343_(); ++z) {
                        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                        BlockState blockState = this.m_9236_().m_8055_(pos);
                        VoxelShape shape = blockState.m_60808_((BlockGetter)this.m_20202_().m_9236_(), this.m_20202_().m_20183_());
                        for (AABB aabb : shape.m_83299_()) {
                            AABB offset = aabb.m_82338_(pos);
                            if (!vehicleBounds.m_82381_(offset)) continue;
                            blockIntersection = true;
                        }
                    }
                }
            }
        }
        if (this.m_20202_() != null && (this.m_20202_().m_20096_() || this.m_20202_().isInFluidType() || blockIntersection)) {
            this.lastPos = null;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAfraidTime() > 0) {
            this.setAfraidTime(this.getAfraidTime() - 1);
        }
    }

    private void handleFallSpeed() {
        AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        if (gravity != null) {
            double fallSpeed = Math.max(gravity.m_22135_() * -1.25, -0.1);
            if (this.m_20184_().m_7098_() < fallSpeed) {
                this.m_20334_(this.m_20184_().m_7096_(), fallSpeed, this.m_20184_().m_7094_());
            }
        }
    }

    private void handlePlayerInput() {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_5833_()) {
                this.m_8127_();
            }
            EntityUtil.copyRotations((Entity)this, (Entity)player);
            player.m_183634_();
            if (!player.m_20096_() && !player.m_21255_()) {
                AttributeInstance playerGravity = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                if (playerGravity != null && !player.m_150110_().f_35935_ && !player.isInFluidType() && playerGravity.m_22135_() > 0.02) {
                    player.m_20256_(player.m_20184_().m_82520_(0.0, 0.05, 0.0));
                }
                AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                    Player innerPlayer = aetherPlayer.getPlayer();
                    if (this.m_9236_().m_5776_() && innerPlayer.m_20184_().m_7098_() <= 0.0) {
                        if (this.lastPos == null) {
                            this.lastPos = this.m_20182_();
                        }
                        if (!innerPlayer.m_20096_() && aetherPlayer.isJumping() && innerPlayer.m_20184_().m_7098_() <= 0.0 && this.m_20182_().m_7098_() < this.lastPos.m_7098_() - 1.1) {
                            innerPlayer.m_20334_(innerPlayer.m_20184_().m_7096_(), 0.125, innerPlayer.m_20184_().m_7094_());
                            PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new AerbunnyPuffPacket(this.m_19879_()));
                            this.spawnExplosionParticle();
                            this.lastPos = null;
                        }
                    }
                });
            } else if (player.m_21255_()) {
                this.m_8127_();
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
            }
        }
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_6084_() && this.m_20159_() && this.m_20202_() != null && this.m_20202_().isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !this.m_9236_().m_8055_(BlockPos.m_274561_((double)this.m_20202_().m_20185_(), (double)this.m_20202_().m_20188_(), (double)this.m_20202_().m_20189_())).m_60713_(Blocks.f_50628_)) {
            this.m_8127_();
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        Player vehicle;
        InteractionResult result = super.m_6071_(player, hand);
        Entity entity = this.m_20202_();
        if (!(entity instanceof Player && !(vehicle = (Player)entity).equals((Object)player) || !player.m_6144_() && result != InteractionResult.PASS && result != InteractionResult.FAIL || super.m_5830_())) {
            return this.ridePlayer(player);
        }
        return result;
    }

    private InteractionResult ridePlayer(Player player) {
        if (!this.m_6162_()) {
            if (this.m_20159_()) {
                this.m_8127_();
                this.setFastFalling(true);
                Vec3 playerMovement = player.m_20184_();
                this.m_20334_(playerMovement.m_7096_() * 5.0, playerMovement.m_7098_() * 0.5 + 0.5, playerMovement.m_7094_() * 5.0);
            } else if (this.m_20329_((Entity)player)) {
                AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setMountedAerbunny(this));
                this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)AetherSoundEvents.ENTITY_AERBUNNY_LIFT.get(), SoundSource.NEUTRAL, 1.0f, (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8127_() {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AetherPlayer.get(player).ifPresent(aetherPlayer -> aetherPlayer.setMountedAerbunny(null));
        }
        super.m_8127_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        if (flag && source.m_7639_() instanceof Player) {
            this.setAfraidTime(100 + this.m_217043_().m_188503_(50));
        }
        return flag;
    }

    protected void midairJump() {
        Vec3 motion = this.m_20184_();
        if (motion.m_7098_() < 0.0) {
            this.puff();
            this.m_9236_().m_7605_((Entity)this, (byte)70);
        }
        this.m_20256_(new Vec3(motion.m_7096_(), 0.25, motion.m_7094_()));
    }

    public void puff() {
        if (this.m_9236_() instanceof ServerLevel) {
            this.setPuffiness(11);
        }
    }

    private void spawnExplosionParticle() {
        for (int i = 0; i < 5; ++i) {
            EntityUtil.spawnMovementExplosionParticles((Entity)this);
        }
    }

    public int getPuffiness() {
        return (Integer)this.f_19804_.m_135370_(DATA_PUFFINESS_ID);
    }

    public void setPuffiness(int puffiness) {
        this.f_19804_.m_135381_(DATA_PUFFINESS_ID, (Object)puffiness);
    }

    public int getAfraidTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_AFRAID_TIME_ID);
    }

    public void setAfraidTime(int afraidTime) {
        this.f_19804_.m_135381_(DATA_AFRAID_TIME_ID, (Object)afraidTime);
    }

    public boolean isFastFalling() {
        return (Boolean)this.f_19804_.m_135370_(DATA_FAST_FALLING_ID);
    }

    public void setFastFalling(boolean fastFalling) {
        this.f_19804_.m_135381_(DATA_FAST_FALLING_ID, (Object)fastFalling);
    }

    public int getPuffSubtract() {
        return this.puffSubtract;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERBUNNY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_AERBUNNY_DEATH.get();
    }

    protected float m_274460_() {
        return this.m_6113_() * 0.216f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(AetherTags.Items.AERBUNNY_TEMPTATION_ITEMS);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public double m_6049_() {
        return this.m_20202_() != null && this.m_20202_().m_6047_() ? 0.4 : 0.575;
    }

    public boolean m_6087_() {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_20191_().m_82369_(player.m_20252_(0.0f)).m_82390_(this.m_20191_().m_82399_().m_82520_(0.0, this.m_20191_().m_82309_() / 2.0, 0.0));
        }
        return true;
    }

    public boolean m_6673_(DamageSource damageSource) {
        return this.m_20202_() != null && this.m_20202_() == damageSource.m_7639_() || super.m_6673_(damageSource);
    }

    public boolean m_5830_() {
        return !this.m_20159_() && super.m_5830_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob entity) {
        return (AgeableMob)((EntityType)AetherEntityTypes.AERBUNNY.get()).m_20615_((Level)level);
    }

    public void m_7822_(byte id) {
        if (id == 70) {
            this.spawnExplosionParticle();
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("AfraidTime", this.getAfraidTime());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("AfraidTime")) {
            this.setAfraidTime(tag.m_128451_("AfraidTime"));
        }
    }

    public static class AerbunnyMoveControl
    extends MoveControl {
        private final Aerbunny aerbunny;

        public AerbunnyMoveControl(Aerbunny aerbunny) {
            super((Mob)aerbunny);
            this.aerbunny = aerbunny;
        }

        public void m_8126_() {
            super.m_8126_();
            if (this.aerbunny.f_20902_ != 0.0f) {
                if (this.aerbunny.m_20096_()) {
                    this.aerbunny.m_21569_().m_24901_();
                } else {
                    int x = Mth.m_14107_((double)this.aerbunny.m_20185_());
                    int y = Mth.m_14107_((double)this.aerbunny.m_20191_().f_82289_);
                    int z = Mth.m_14107_((double)this.aerbunny.m_20189_());
                    if (this.checkForSurfaces(this.aerbunny.m_9236_(), x, y, z) && !this.aerbunny.f_19862_) {
                        this.aerbunny.midairJump();
                    }
                }
            }
        }

        private boolean checkForSurfaces(Level level, int x, int y, int z) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
            if (level.m_8055_((BlockPos)pos.m_142448_(y - 1)).m_60795_()) {
                return false;
            }
            return level.m_8055_((BlockPos)pos.m_142448_(y + 2)).m_60795_() && level.m_8055_((BlockPos)pos.m_142448_(y + 1)).m_60795_();
        }
    }

    public static class RunWhenAfraid
    extends Goal {
        private final Aerbunny aerbunny;
        private final double speedModifier;

        public RunWhenAfraid(Aerbunny aerbunny, double speedModifier) {
            this.aerbunny = aerbunny;
            this.speedModifier = speedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return this.aerbunny.getAfraidTime() > 0;
        }

        public boolean m_8045_() {
            return !this.aerbunny.m_21573_().m_26571_() && this.aerbunny.m_217043_().m_188503_(20) != 0;
        }

        public void m_8056_() {
            Player attacker = this.aerbunny.m_9236_().m_45930_((Entity)this.aerbunny, 12.0);
            if (attacker == null) {
                return;
            }
            Vec3 position = this.aerbunny.m_20182_();
            double angle = Mth.m_14136_((double)(position.m_7096_() - attacker.m_20185_()), (double)(position.m_7094_() - attacker.m_20189_()));
            float angleOffset = this.aerbunny.m_217043_().m_188501_() * 2.0f - 1.0f;
            double x = position.m_7096_() + Math.sin(angle += (double)angleOffset * 0.75) * 8.0;
            double z = position.m_7094_() + Math.cos(angle) * 8.0;
            boolean flag = this.aerbunny.m_21573_().m_26519_(x, this.aerbunny.m_20186_(), z, this.speedModifier);
            if (!flag) {
                this.aerbunny.m_21563_().m_24960_((Entity)attacker, 30.0f, 30.0f);
            }
        }

        public void m_8037_() {
            Level level = this.aerbunny.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.aerbunny.m_217043_().m_188503_(4) == 0) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.aerbunny.m_20208_(0.5), this.aerbunny.m_20187_(), this.aerbunny.m_20262_(0.5), 2, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

