/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.integration.crafttweaker;

import com.aetherteam.aether.integration.crafttweaker.actions.AddFuelAction;
import com.aetherteam.aether.integration.crafttweaker.actions.RemoveFuelAction;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.world.level.ItemLike;

public final class FuelManagerUtil {
    public static void addFuelMethod(IIngredient ingredient, int burnTime, BiConsumer<ItemLike, Integer> addItem, BiConsumer<ItemLike[], Integer> addItems) {
        ItemLike[] items = (ItemLike[])Stream.of(ingredient.getItems()).map(IItemStack::asItemLike).toArray(ItemLike[]::new);
        if (items.length == 1) {
            CraftTweakerAPI.apply(new AddFuelAction<ItemLike>(addItem, items[0], burnTime));
        } else if (items.length > 1) {
            CraftTweakerAPI.apply(new AddFuelAction<ItemLike[]>(addItems, items, burnTime));
        }
    }

    public static void removeFuelMethod(IIngredient ingredient, Consumer<ItemLike> removeItem, Consumer<ItemLike[]> removeItems) {
        ItemLike[] items = (ItemLike[])Stream.of(ingredient.getItems()).map(IItemStack::asItemLike).toArray(ItemLike[]::new);
        if (items.length == 1) {
            CraftTweakerAPI.apply(new RemoveFuelAction<ItemLike>(removeItem, items[0]));
        } else if (items.length > 1) {
            CraftTweakerAPI.apply(new RemoveFuelAction<ItemLike[]>(removeItems, items));
        }
    }
}

