/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.modifiers;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.EquipmentUtil;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class PigDropsModifier
extends LootModifier {
    public static final Codec<PigDropsModifier> CODEC = RecordCodecBuilder.create(instance -> LootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PigDropsModifier::new));

    public PigDropsModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    public ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> lootStacks, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81459_);
        Entity target = (Entity)context.m_78953_(LootContextParams.f_81455_);
        ObjectArrayList newStacks = new ObjectArrayList(lootStacks);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (EquipmentUtil.isFullStrength(livingEntity) && livingEntity.m_21205_().m_150930_((Item)AetherItems.PIG_SLAYER.get()) && livingTarget.m_6095_().m_204039_(AetherTags.Entities.PIGS) && livingTarget.m_217043_().m_188503_(4) == 0) {
                    for (ItemStack stack : lootStacks) {
                        if (!stack.m_204117_(AetherTags.Items.PIG_DROPS)) continue;
                        newStacks.add((Object)stack);
                    }
                }
            }
        }
        return newStacks;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

