/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.WorldDisplayHelper;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import com.aetherteam.aether.item.accessories.pendant.PendantItem;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class AetherMixinHooks {
    private static final ResourceLocation SWUFF_CAPE_LOCATION = new ResourceLocation("aether", "textures/models/accessory/capes/swuff_accessory.png");

    public static boolean isCapeVisible(LivingEntity livingEntity) {
        Optional<SlotResult> slotResult = EquipmentUtil.findFirstCurio(livingEntity, item -> item.m_41720_() instanceof CapeItem);
        if (slotResult.isPresent()) {
            Optional stacksHandler;
            String identifier = slotResult.get().slotContext().identifier();
            int id = slotResult.get().slotContext().index();
            LazyOptional itemHandler = CuriosApi.getCuriosInventory((LivingEntity)livingEntity);
            if (itemHandler.resolve().isPresent() && (stacksHandler = ((ICuriosItemHandler)itemHandler.resolve().get()).getStacksHandler(identifier)).isPresent()) {
                return (Boolean)((ICurioStacksHandler)stacksHandler.get()).getRenders().get(id);
            }
        }
        return false;
    }

    public static ResourceLocation getCapeTexture(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof CapeItem) {
            CapeItem capeItem = (CapeItem)item;
            if (stack.m_41786_().getString().equalsIgnoreCase("swuff_'s cape")) {
                return SWUFF_CAPE_LOCATION;
            }
            return capeItem.getCapeTexture();
        }
        return null;
    }

    public static boolean canUnlockLevel(Path basePath) {
        if (Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91080_ instanceof SelectWorldScreen) {
            return basePath.getFileName().toString().equals(WorldDisplayHelper.getLevelSummary().m_78358_());
        }
        return false;
    }

    public static boolean canReplaceCurrentAccessory(Mob mob, ItemStack candidate, ItemStack existing) {
        if (EnchantmentHelper.m_44920_((ItemStack)existing)) {
            return false;
        }
        Item item = candidate.m_41720_();
        if (item instanceof GlovesItem) {
            GlovesItem candidateGloves = (GlovesItem)item;
            Item item2 = existing.m_41720_();
            if (!(item2 instanceof GlovesItem)) {
                return true;
            }
            GlovesItem existingGloves = (GlovesItem)item2;
            if (candidateGloves.getDamage() != existingGloves.getDamage()) {
                return candidateGloves.getDamage() > existingGloves.getDamage();
            }
            return mob.m_21477_(candidate, existing);
        }
        if (candidate.m_41720_() instanceof PendantItem) {
            if (!(existing.m_41720_() instanceof PendantItem)) {
                return true;
            }
            return mob.m_21477_(candidate, existing);
        }
        return false;
    }

    public static String getIdentifierForItem(LivingEntity livingEntity, ItemStack stack) {
        if (((Boolean)AetherConfig.COMMON.use_curios_menu.get()).booleanValue()) {
            TagKey glovesTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("curios", "hands"));
            TagKey pendantTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("curios", "necklace"));
            if (stack.m_204117_(glovesTag)) {
                return "hands";
            }
            if (stack.m_204117_(pendantTag) && (livingEntity.m_6095_() == EntityType.f_20511_ || livingEntity.m_6095_() == EntityType.f_20531_)) {
                return "necklace";
            }
        } else {
            if (stack.m_204117_(AetherTags.Items.AETHER_GLOVES)) {
                return "aether_gloves";
            }
            if (stack.m_204117_(AetherTags.Items.AETHER_PENDANT) && (livingEntity.m_6095_() == EntityType.f_20511_ || livingEntity.m_6095_() == EntityType.f_20531_)) {
                return "aether_pendant";
            }
        }
        return "";
    }

    public static ItemStack getItemByIdentifier(LivingEntity livingEntity, String identifier) {
        ICuriosItemHandler handler;
        Optional optionalResult;
        LazyOptional lazyHandler = CuriosApi.getCuriosInventory((LivingEntity)livingEntity);
        if (lazyHandler.isPresent() && lazyHandler.resolve().isPresent() && (optionalResult = (handler = (ICuriosItemHandler)lazyHandler.resolve().get()).findCurio(identifier, 0)).isPresent()) {
            return ((SlotResult)optionalResult.get()).stack();
        }
        return ItemStack.f_41583_;
    }

    public static void setItemByIdentifier(LivingEntity livingEntity, ItemStack itemStack, String identifier) {
        LazyOptional lazyHandler = CuriosApi.getCuriosInventory((LivingEntity)livingEntity);
        if (lazyHandler.isPresent() && lazyHandler.resolve().isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)lazyHandler.resolve().get();
            handler.setEquippedCurio(identifier, 0, itemStack);
        }
    }
}

