/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.mixin.mixins.common;

import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.event.listeners.abilities.ToolAbilityListener;
import com.aetherteam.aether.item.tools.abilities.ValkyrieTool;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Item.class})
public class ItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"getPlayerPOVHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/ClipContext$Fluid;)Lnet/minecraft/world/phys/BlockHitResult;"}, cancellable=true)
    private static void getPlayerPOVHitResult(Level level, Player player, ClipContext.Fluid fluidMode, CallbackInfoReturnable<BlockHitResult> cir) {
        BlockHitResult hitResult;
        InteractionHand hand = ToolAbilityListener.INTERACTION_HAND;
        if (hand != null && (hitResult = ItemMixin.interactionTooFar(level, player, hand, fluidMode)) != null) {
            cir.setReturnValue((Object)hitResult);
        }
    }

    private static BlockHitResult interactionTooFar(Level level, Player player, InteractionHand hand, ClipContext.Fluid fluidMode) {
        AttributeModifier valkyrieModifier;
        AttributeInstance reachDistance;
        if (hand == InteractionHand.OFF_HAND && AbilityHooks.ToolHooks.hasValkyrieItemInMainHandOnly(player) && (reachDistance = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())) != null && (valkyrieModifier = reachDistance.m_22111_(ValkyrieTool.REACH_DISTANCE_MODIFIER_UUID)) != null) {
            double reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) - valkyrieModifier.m_22218_();
            double trueReach = reach == 0.0 ? 0.0 : reach + (player.m_7500_() ? 0.5 : 0.0);
            return ItemMixin.getPlayerPOVHitResultForReach(level, player, trueReach, fluidMode);
        }
        return null;
    }

    private static BlockHitResult getPlayerPOVHitResultForReach(Level level, Player player, double reach, ClipContext.Fluid fluidClip) {
        float f = player.m_146909_();
        float f1 = player.m_146908_();
        Vec3 vec3 = player.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec31 = vec3.m_82520_((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        return level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.OUTLINE, fluidClip, (Entity)player));
    }
}

