/*
 * Decompiled with CFR 0.152.
 */
package doggytalents;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.util.Util;
import doggytalents.common.variant.DogVariant;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;

public class DoggyRegistries {
    public static Supplier<IForgeRegistry<DogVariant>> DOG_VARIANT;

    public static void newRegistry(NewRegistryEvent event) {
        DoggyTalentsAPI.TALENTS = event.create(DoggyRegistries.makeRegistry(Keys.TALENTS_REGISTRY, Talent.class));
        DoggyTalentsAPI.ACCESSORIES = event.create(DoggyRegistries.makeRegistry(Keys.ACCESSORIES_REGISTRY, Accessory.class));
        DoggyTalentsAPI.ACCESSORY_TYPE = event.create(DoggyRegistries.makeRegistry(Keys.ACCESSORY_TYPE_REGISTRY, AccessoryType.class).disableSync());
        DoggyTalentsAPI.TALENT_OPTIONS = DoggyRegistries.makeDogSyncRegistry(event);
        DOG_VARIANT = DoggyRegistries.makeRegistry(event, Keys.DOG_VARIANT, DogVariant.class, Util.getVanillaResource("pale"));
    }

    private static <T> RegistryBuilder<T> makeRegistry(ResourceLocation rl, Class<T> type) {
        return new RegistryBuilder().setName(rl);
    }

    private static <T> Supplier<IForgeRegistry<T>> makeRegistry(NewRegistryEvent event, ResourceLocation key, Class<T> type, ResourceLocation defaultKey) {
        RegistryBuilder builder = new RegistryBuilder().setName(key);
        builder.setDefaultKey(defaultKey);
        Supplier ret = event.create(builder);
        return ret;
    }

    private static Supplier<IForgeRegistry<TalentOption<?>>> makeDogSyncRegistry(NewRegistryEvent event) {
        RegistryBuilder builder = new RegistryBuilder().setName(Keys.TALENT_OPTION);
        Supplier ret = event.create(builder);
        return ret;
    }

    public class Keys {
        public static final ResourceLocation TALENTS_REGISTRY = Util.getResource("talents");
        public static final ResourceLocation ACCESSORIES_REGISTRY = Util.getResource("accessories");
        public static final ResourceLocation ACCESSORY_TYPE_REGISTRY = Util.getResource("accessory_type");
        public static final ResourceLocation DOG_VARIANT = Util.getResource("dog_variant");
        public static final ResourceLocation TALENT_OPTION = Util.getResource("talent_options");
    }
}

