/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.impl;

import doggytalents.api.registry.IBeddingMaterial;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BeddingMaterial
extends IBeddingMaterial {
    private final Supplier<Block> block;
    protected ResourceLocation texture;
    protected final ResourceLocation id;
    @Nullable
    private String translationKey;

    public BeddingMaterial(ResourceLocation id, Supplier<Block> blockIn) {
        this.block = blockIn;
        this.id = id;
    }

    public BeddingMaterial(ResourceLocation id, Supplier<Block> blockIn, ResourceLocation texture) {
        this.block = blockIn;
        this.texture = texture;
        this.id = id;
    }

    @Override
    public ResourceLocation getTexture() {
        if (this.texture == null) {
            ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)this.block.get());
            this.texture = new ResourceLocation(loc.m_135827_(), "block/" + loc.m_135815_());
        }
        return this.texture;
    }

    @Override
    public Component getTooltip() {
        Block block = this.block.get();
        if (block == null) {
            return Component.m_237119_();
        }
        return Component.m_237115_((String)block.m_5456_().m_5524_()).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(block.m_284356_().f_283871_));
    }

    @Override
    public Ingredient getIngredient() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)this.block.get()});
    }

    @Override
    public ResourceLocation getSaveKey() {
        return this.id;
    }
}

