/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.impl;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class DogArmorItemHandler
extends ItemStackHandler {
    private AbstractDog dog;

    public DogArmorItemHandler(AbstractDog dog) {
        super(4);
        this.dog = dog;
    }

    public CompoundTag serializeNBT() {
        ListTag itemsList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            stack.m_41739_(itemTag);
            itemsList.add((Object)itemTag);
        }
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("dogArmors", (Tag)itemsList);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        if (compound.m_128425_("dogArmors", 9)) {
            ListTag tagList = compound.m_128437_("dogArmors", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTag = tagList.m_128728_(i);
                int slot = itemTag.m_128451_("Slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                this.setArmorInSlot(stack);
            }
            this.onLoad();
        }
    }

    public void setArmorInSlot(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armor = (ArmorItem)item;
        EquipmentSlot slot = armor.m_266204_().m_266308_();
        this.setArmorInSlot(stack, slot);
    }

    public void setArmorInSlot(ItemStack stack, EquipmentSlot slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return;
        }
        this.stacks.set(dogSlot.slotId, (Object)stack);
    }

    public ItemStack getArmorFromSlot(EquipmentSlot slot) {
        DogArmorSlots dogSlot = DogArmorSlots.byEquipment(slot);
        if (dogSlot == null) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.stacks.get(dogSlot.slotId);
    }

    public Iterable<ItemStack> armors() {
        return this.stacks;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (!this.dog.canDogWearArmor()) {
            return false;
        }
        DogArmorSlots dogSlot = DogArmorSlots.bySlotId(slot);
        if (dogSlot == null) {
            return false;
        }
        EquipmentSlot equip = dogSlot.val;
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return false;
        }
        ArmorItem armor = (ArmorItem)item;
        EquipmentSlot wantSlot = armor.m_266204_().m_266308_();
        return wantSlot == equip;
    }

    public void onPropsUpdated(DogAlterationProps props) {
        if (props.canWearArmor()) {
            return;
        }
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public static enum DogArmorSlots {
        HEAD(0, EquipmentSlot.HEAD),
        CHEST(1, EquipmentSlot.CHEST),
        LEGS(2, EquipmentSlot.LEGS),
        FEET(3, EquipmentSlot.FEET);

        public final int slotId;
        public final EquipmentSlot val;

        private DogArmorSlots(int slotId, EquipmentSlot val) {
            this.slotId = slotId;
            this.val = val;
        }

        public static DogArmorSlots bySlotId(int slotId) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.slotId != slotId) continue;
                return val;
            }
            return null;
        }

        public static DogArmorSlots byEquipment(EquipmentSlot slot) {
            DogArmorSlots[] values;
            for (DogArmorSlots val : values = DogArmorSlots.values()) {
                if (val.val != slot) continue;
                return val;
            }
            return null;
        }
    }
}

