/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.api.inferface;

import com.google.common.base.Function;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.DogGender;
import doggytalents.api.feature.DogMode;
import doggytalents.api.feature.IDog;
import doggytalents.api.impl.DogArmorItemHandler;
import java.util.Iterator;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractDog
extends TamableAnimal
implements IDog {
    protected AbstractDog(EntityType<? extends TamableAnimal> type, Level worldIn) {
        super(type, worldIn);
    }

    public void setAttributeModifier(Attribute attribute, UUID modifierUUID, BiFunction<AbstractDog, UUID, AttributeModifier> modifierGenerator) {
        AttributeModifier newModifier;
        AttributeInstance attributeInst = this.m_21051_(attribute);
        AttributeModifier currentModifier = attributeInst.m_22111_(modifierUUID);
        if (currentModifier != null) {
            attributeInst.m_22120_(modifierUUID);
        }
        if ((newModifier = modifierGenerator.apply(this, modifierUUID)) != null) {
            attributeInst.m_22118_(newModifier);
        }
    }

    public void removeAttributeModifier(Attribute attribute, UUID modifierUUID) {
        AttributeInstance attrib = this.m_21051_(attribute);
        if (attrib == null) {
            return;
        }
        attrib.m_22120_(modifierUUID);
    }

    @Override
    public AbstractDog getDog() {
        return this;
    }

    public float m_6121_() {
        return super.m_6121_();
    }

    public void m_21834_(boolean play) {
        super.m_21834_(play);
    }

    public void consumeItemFromStack(@Nullable Entity entity, ItemStack stack) {
        if (entity instanceof Player) {
            super.m_142075_((Player)entity, InteractionHand.MAIN_HAND, stack);
        } else {
            stack.m_41774_(1);
        }
    }

    public abstract Component getTranslationKey(Function<DogGender, String> var1);

    public Component getGenderPronoun() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedPronoun));
    }

    public Component getGenderSubject() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedSubject));
    }

    public Component getGenderPossessiveAdj() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedPossessiveAdj));
    }

    public Component getGenderTitle() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedTitle));
    }

    public Component getGenderTip() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedTip));
    }

    public Component getGenderName() {
        return this.getTranslationKey((Function<DogGender, String>)((Function)DogGender::getUnlocalisedName));
    }

    public void setNavigation(PathNavigation p) {
        if (p == null) {
            p = this.getDefaultNavigation();
        }
        if (this.f_21344_ == p) {
            return;
        }
        this.f_21344_.m_26573_();
        this.f_21344_ = p;
    }

    public void setMoveControl(MoveControl m) {
        if (m == null) {
            m = this.getDefaultMoveControl();
        }
        this.breakMoveControl();
        this.f_21342_ = m;
    }

    public void breakMoveControl() {
        this.f_21342_.m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0);
        this.f_21342_.m_8126_();
        this.m_6862_(false);
        this.m_7910_(0.0f);
        this.m_21570_(0.0f);
        this.m_21567_(0.0f);
        this.m_21564_(0.0f);
    }

    public abstract void resetNavigation();

    public abstract void resetMoveControl();

    public abstract MoveControl getDefaultMoveControl();

    public abstract PathNavigation getDefaultNavigation();

    public abstract boolean canSwimUnderwater();

    public abstract void setDogSwimming(boolean var1);

    public abstract void setDogFlying(boolean var1);

    public abstract boolean isDogFlying();

    public abstract float getClientAnimatedYBodyRotInRadians();

    public abstract float getDogVisualBbHeight();

    public abstract float getDogVisualBbWidth();

    public abstract DogArmorItemHandler dogArmors();

    public abstract ItemStack wolfArmor();

    public abstract boolean canDogWearArmor();

    public abstract boolean canDogUseTools();

    public abstract DogAnimation getAnim();

    public abstract boolean forcedWhenNoneAnim();

    public abstract boolean isDogVariantRenderEffective();

    protected void m_6472_(DamageSource p_36251_, float p_36252_) {
        if (!(p_36252_ <= 0.0f)) {
            if ((p_36252_ /= 4.0f) < 1.0f) {
                p_36252_ = 1.0f;
            }
            int j = 0;
            Iterator iterator = this.m_6168_().iterator();
            while (iterator.hasNext()) {
                ItemStack i;
                ItemStack itemstack = i = (ItemStack)iterator.next();
                if (!(p_36251_.m_269533_(DamageTypeTags.f_268745_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem))) {
                    EquipmentSlot slot = EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)j);
                    itemstack.m_41622_((int)p_36252_, (LivingEntity)this, p_35997_ -> p_35997_.m_21166_(slot));
                }
                ++j;
            }
        }
    }

    protected void m_142642_(DamageSource p_150103_, float p_150104_) {
        if (!(p_150104_ <= 0.0f)) {
            ItemStack i;
            if ((p_150104_ /= 4.0f) < 1.0f) {
                p_150104_ = 1.0f;
            }
            ItemStack itemstack = i = this.m_6844_(EquipmentSlot.HEAD);
            if (!(p_150103_.m_269533_(DamageTypeTags.f_268745_) && itemstack.m_41720_().m_41475_() || !(itemstack.m_41720_() instanceof ArmorItem))) {
                itemstack.m_41622_((int)p_150104_, (LivingEntity)this, p_35997_ -> p_35997_.m_21166_(EquipmentSlot.HEAD));
            }
        }
    }

    @Override
    public boolean isDefeated() {
        return this.getMode() == DogMode.INJURED;
    }

    public boolean isDoingFine() {
        return this.m_6084_() && !this.isDefeated();
    }

    public boolean isDogLowHealth() {
        return false;
    }

    public boolean canStillEat() {
        return false;
    }
}

