/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.client.block.model.DogBedItemOverride;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.block.tileentity.DogBedTileEntity;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DogBedModel
implements BakedModel {
    public static DogBedItemOverride ITEM_OVERIDE = new DogBedItemOverride();
    private static final ResourceLocation MISSING_TEXTURE = new ResourceLocation("missingno");
    private final ModelBakery modelLoader;
    private final BlockModel unbakedModel;
    private final BakedModel defaultModelVariant;
    private final Map<Direction, BakedModel> defaultModelVariants = new ConcurrentHashMap<Direction, BakedModel>(Direction.values().length);
    private final Map<Direction, BakedModel> missingModelVariant = new ConcurrentHashMap<Direction, BakedModel>(Direction.values().length);
    private final Map<Triple<ICasingMaterial, IBeddingMaterial, Direction>, BakedModel> cache = Maps.newConcurrentMap();
    private final int maxCacheSize;

    public DogBedModel(ModelBakery modelLoader, BlockModel model, BakedModel defaultModelVariant, int maxCacheSize) {
        this.modelLoader = modelLoader;
        this.unbakedModel = model;
        this.defaultModelVariant = defaultModelVariant;
        this.maxCacheSize = maxCacheSize;
    }

    public BakedModel getModelVariant(@Nonnull ModelData data) {
        return this.getModelVariant((ICasingMaterial)data.get(DogBedTileEntity.CASING), (IBeddingMaterial)data.get(DogBedTileEntity.BEDDING), (Direction)data.get(DogBedTileEntity.FACING));
    }

    public BakedModel getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, Direction facing) {
        if (facing == null) {
            facing = Direction.NORTH;
        }
        if (casing == null || bedding == null) {
            return this.getDefaultVariant(facing);
        }
        if (casing.isNani() || bedding.isNani()) {
            return this.getMissingVariant(facing);
        }
        ImmutableTriple key = ImmutableTriple.of((Object)casing, (Object)bedding, (Object)facing);
        BakedModel model_variant = this.cache.get(key);
        if (model_variant != null) {
            return model_variant;
        }
        if (this.cache.size() >= this.maxCacheSize) {
            return this.getDefaultVariant(facing);
        }
        model_variant = this.bakeModelVariant(casing, bedding, facing);
        this.cache.put((Triple<ICasingMaterial, IBeddingMaterial, Direction>)key, model_variant);
        return model_variant;
    }

    private BakedModel getMissingVariant(Direction dir) {
        BakedModel missing = this.missingModelVariant.get(dir);
        if (missing != null) {
            return missing;
        }
        missing = this.bakeModelVariant(DogBedMaterialManager.NaniCasing.NULL, DogBedMaterialManager.NaniBedding.NULL, dir);
        this.missingModelVariant.put(dir, missing);
        return missing;
    }

    private BakedModel getDefaultVariant(Direction dir) {
        BakedModel default_variant = this.defaultModelVariants.get(dir);
        if (default_variant != null) {
            return default_variant;
        }
        default_variant = DogBedModel.bakeModel(this.unbakedModel, dir);
        this.defaultModelVariants.put(dir, default_variant);
        return default_variant;
    }

    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        return this.getModelVariant(null, null, Direction.NORTH).getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        return this.getModelVariant(data).getQuads(state, side, rand, ModelData.EMPTY, renderType);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        return this.getModelVariant(data).getParticleIcon(data);
    }

    public BakedModel bakeModelVariant(@Nullable ICasingMaterial casing, @Nullable IBeddingMaterial bedding, @Nonnull Direction facing) {
        BlockModel new_model = DogBedModel.deepCopyBlockModel(this.unbakedModel);
        Either<Material, String> casing_texture = DogBedModel.findCasingTexture(casing);
        Either<Material, String> bedding_texture = DogBedModel.findBeddingTexture(bedding);
        new_model.f_111417_.put("bedding", bedding_texture);
        new_model.f_111417_.put("casing", casing_texture);
        new_model.f_111417_.put("particle", casing_texture);
        BakedModel ret = DogBedModel.bakeModel(new_model, facing);
        return ret;
    }

    private static BlockModel deepCopyBlockModel(BlockModel model) {
        List elements_old = model.m_111436_();
        ArrayList<BlockElement> elements_new = new ArrayList<BlockElement>(elements_old.size());
        for (BlockElement element : elements_old) {
            BlockElement element_copy = new BlockElement(element.f_111308_, element.f_111309_, (Map)Maps.newHashMap((Map)element.f_111310_), element.f_111311_, element.f_111312_);
            elements_new.add(element_copy);
        }
        BlockModel ret = new BlockModel(model.getParentLocation(), elements_new, (Map)Maps.newHashMap((Map)model.f_111417_), Boolean.valueOf(model.m_111476_()), model.m_111479_(), model.m_111491_(), new ArrayList(model.m_111484_()));
        ret.f_111416_ = model.f_111416_;
        ret.f_111418_ = model.f_111418_;
        return ret;
    }

    private static BakedModel bakeModel(final BlockModel to_bake, final Direction dir) {
        var baker = new ModelBaker(){

            @Nullable
            public BakedModel bake(ResourceLocation location, ModelState state, Function<Material, TextureAtlasSprite> sprites) {
                return to_bake.m_111449_((ModelBaker)this, to_bake, Material::m_119204_, (ModelState)DogBedModel.getModelRotation(dir), DogBedModel.createResourceVariant_1_20_1_under(dir), true);
            }

            public Function<Material, TextureAtlasSprite> getModelTextureGetter() {
                return Material::m_119204_;
            }

            public UnbakedModel m_245361_(ResourceLocation p_252194_) {
                return to_bake;
            }

            @Nullable
            public BakedModel m_245240_(ResourceLocation p_250776_, ModelState p_251280_) {
                return this.bake(p_250776_, p_251280_, this.getModelTextureGetter());
            }
        };
        return baker.bake(null, null, null);
    }

    private static BlockModelRotation getModelRotation(@Nonnull Direction dir) {
        switch (dir) {
            default: {
                return BlockModelRotation.X0_Y0;
            }
            case EAST: {
                return BlockModelRotation.X0_Y90;
            }
            case SOUTH: {
                return BlockModelRotation.X0_Y180;
            }
            case WEST: 
        }
        return BlockModelRotation.X0_Y270;
    }

    private static Either<Material, String> findCasingTexture(@Nullable ICasingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<Material, String> findBeddingTexture(@Nullable IBeddingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<Material, String> findTexture(ResourceLocation resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new Material(InventoryMenu.f_39692_, resource));
    }

    public boolean m_7541_() {
        return this.defaultModelVariant.m_7541_();
    }

    public boolean m_7539_() {
        return this.defaultModelVariant.m_7539_();
    }

    public boolean m_7547_() {
        return this.defaultModelVariant.m_7547_();
    }

    public boolean m_7521_() {
        return this.defaultModelVariant.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.defaultModelVariant.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.defaultModelVariant.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return ITEM_OVERIDE;
    }

    private static ResourceLocation createResourceVariant_1_20_1_under(Direction facing) {
        return new ModelResourceLocation(Util.getResource("block/dog_bed"), "#bedding=doggytalents.dogbed.bedding.baking,casing=doggytalents.dogbed.casing.baking,facing=" + facing.m_122433_());
    }
}

