/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.DogTextureManager;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.model.dog.NullDogModel;
import doggytalents.client.entity.render.CollarRenderManager;
import doggytalents.client.entity.render.layer.LayerFactory;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ForgeHooksClient;
import org.joml.Matrix4f;

public class DogRenderer
extends MobRenderer<Dog, DogModel> {
    private static final int TXTCLR_DIFFOWNER = 1464486474;
    private static final int TXTCLR_HEALTH_70_100 = 720707;
    private static final int TXTCLR_HEALTH_30_70 = 15727189;
    private static final int TXTCLR_HEALTH_0_30 = 0xFF3636;
    private static final int TXTCLR_HEALTH_BKG = 0x4A4A4A;
    private static final int TXCLR_SEPERATOR = -6184543;
    private DogModel defaultModel;
    private NullDogModel nullDogModel;
    private List<RenderLayer<Dog, DogModel>> originalDogLayers = List.of();

    public DogRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, null, 0.5f);
        DogModelRegistry.resolve(ctx);
        this.defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();
        for (LayerFactory<Dog, DogModel> layer : CollarRenderManager.getLayers()) {
            this.m_115326_(layer.createLayer((RenderLayerParent<Dog, DogModel>)this, ctx));
        }
        this.originalDogLayers = new ArrayList<RenderLayer<Dog, DogModel>>(this.f_115291_);
        this.nullDogModel = new NullDogModel(ctx.m_174023_(ClientSetup.DOG_NULL));
        this.f_115290_ = this.nullDogModel;
    }

    protected float getBob(Dog livingBase, float partialTicks) {
        return super.m_6930_((LivingEntity)livingBase, partialTicks);
    }

    public void render(Dog dog, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        DogSkin skin = dog.getClientSkin();
        this.f_115290_ = skin.useCustomModel() ? dog.getClientSkin().getCustomModel().getValue() : this.defaultModel;
        ((DogModel)this.f_115290_).resetWetShade();
        if (dog.isDogSoaked() && !dog.dogVariant().preventWetShade()) {
            float f = dog.getShadingWhileWet(partialTicks);
            ((DogModel)this.f_115290_).setWetShade(f);
        }
        if (((Boolean)ConfigHandler.CLIENT.BLOCK_THIRD_PARTY_NAMETAG.get()).booleanValue()) {
            this.MobRenderer_render(dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        } else {
            super.m_7392_((Mob)dog, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
        this.f_115290_ = this.nullDogModel;
    }

    private Component getNameUnknown(Dog dogIn) {
        return Component.m_237115_((String)(dogIn.m_21805_() != null ? "entity.doggytalents.dog.unknown_owner" : "entity.doggytalents.dog.untamed"));
    }

    public ResourceLocation getTextureLocation(Dog dogIn) {
        return DogTextureManager.INSTANCE.getTexture(dogIn);
    }

    protected void scale(Dog dogIn, PoseStack matrixStackIn, float partialTickTime) {
        DogModel model;
        float size = dogIn.m_6162_() ? 0.5f : dogIn.getDogSize().getScale();
        DogSkin skin = dogIn.getClientSkin();
        if (skin.useCustomModel() && (model = skin.getCustomModel().getValue()).hasDefaultScale()) {
            size *= model.getDefaultScale();
        }
        matrixStackIn.m_85841_(size, size, size);
        this.f_114477_ = size * 0.5f;
    }

    protected boolean shouldShowName(Dog p_115506_) {
        return (Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_DOG_NAME.get() != false || super.m_6512_((Mob)p_115506_);
    }

    protected void renderNameTag(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        boolean isDiffOwner;
        double d0 = this.f_114476_.m_114471_((Entity)dog);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean renderDiffOwnerName = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_DIFFOWNER_NAME_DIFFERENT) != false && dog != this.f_114476_.f_114359_;
        boolean bl = isDiffOwner = player == null || !Objects.equals(player.m_20148_(), dog.m_21805_());
        if (isDiffOwner && ((Boolean)ConfigHandler.CLIENT.DONT_RENDER_DIFFOWNER_NAME.get()).booleanValue()) {
            return;
        }
        if (ForgeHooksClient.isNameplateInRenderDistance((Entity)dog, (double)d0)) {
            this.renderMainName(dog, text, stack, buffer, packedLight, renderDiffOwnerName && isDiffOwner, isDiffOwner, !isDiffOwner && WhistleItem.isHoldingDutyWhistle((LivingEntity)player));
        }
        if (d0 <= 4096.0) {
            this.renderExtraInfo(dog, text, stack, buffer, packedLight, d0, renderDiffOwnerName && isDiffOwner, isDiffOwner);
        }
    }

    private void renderMainName(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int light, boolean diffOwnerRender, boolean isDiffOwner, boolean renderDogOnDuty) {
        text = this.modifyMainText(dog, text, diffOwnerRender, renderDogOnDuty);
        this.renderDogText(dog, text, 0.0, 0.025f, stack, buffer, light, diffOwnerRender, isDiffOwner);
    }

    private int getBkgTextColorWithOpacity(boolean diffOwnerRender) {
        boolean color = false;
        float bkg_opacity = 0.0f;
        if (!diffOwnerRender) {
            bkg_opacity = Minecraft.m_91087_().f_91066_.m_92141_(0.25f);
        }
        int alpha = (int)(bkg_opacity * 255.0f) << 24;
        return alpha | 0;
    }

    private void renderDogText(Dog dog, Component text, double y_offset_from_default, float scale, PoseStack stack, MultiBufferSource buffer, int light, boolean render_diffowner, boolean is_diffowner) {
        boolean dog_not_sneaking = !dog.m_20163_();
        double render_y_offset = (double)(dog.m_20206_() + 0.5f) + y_offset_from_default;
        stack.m_85836_();
        stack.m_85837_(0.0, render_y_offset, 0.0);
        stack.m_252781_(this.f_114476_.m_253208_());
        stack.m_85841_(-scale, -scale, scale);
        Matrix4f pose = stack.m_85850_().m_252922_();
        Font font = this.m_114481_();
        float tX = -font.m_92852_((FormattedText)text) / 2;
        float tY = 0.0f;
        boolean bkg_see_through = dog_not_sneaking && !is_diffowner && (Boolean)ConfigHandler.CLIENT.SHOW_DOG_NAME_THRU_WALL.get() != false;
        Font.DisplayMode bkg_display_mode = bkg_see_through ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        int bkg_color = this.getBkgTextColorWithOpacity(render_diffowner);
        int bkg_txtcolor = 0x20FFFFFF;
        font.m_272077_(text, tX, tY, bkg_txtcolor, false, pose, buffer, bkg_display_mode, bkg_color, light);
        boolean draw_fg_text = dog_not_sneaking;
        if (draw_fg_text) {
            Font.DisplayMode fg_display_mode = Font.DisplayMode.NORMAL;
            int fg_color = 0;
            int fg_txtcolor = -1;
            font.m_272077_(text, tX, tY, fg_txtcolor, false, pose, buffer, fg_display_mode, fg_color, light);
        }
        stack.m_85849_();
    }

    private void renderExtraInfo(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        this.renderInfoDogText(dog, text, stack, buffer, packedLight, d0, diffOwnerRender, isDiffOwner);
        this.renderSecondaryInfoDogText(dog, text, stack, buffer, packedLight, d0, diffOwnerRender, isDiffOwner);
    }

    private void renderInfoDogText(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        boolean renderHealthInNameActivated = this.f_114476_.f_114358_.m_90592_().m_6144_() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        String seperator = (String)ConfigHandler.CLIENT.DOG_INFO_SEPERATOR.get();
        MutableComponent seperator_c1 = this.createC1WithColor(seperator, -6184543);
        MutableComponent extra_info_c1 = Component.m_237115_((String)dog.getMode().getTip());
        Optional<Component> hunger_c1_optional = this.getHungerC1(dog, renderHealthInNameActivated);
        Optional<Component> gender_c1_optional = this.getGenderC1(dog);
        if (hunger_c1_optional.isPresent()) {
            extra_info_c1.m_7220_((Component)seperator_c1);
            Component hunger_c1 = hunger_c1_optional.get();
            extra_info_c1.m_7220_(hunger_c1);
        }
        if (gender_c1_optional.isPresent()) {
            extra_info_c1.m_7220_((Component)seperator_c1);
            Component gender_c1 = gender_c1_optional.get();
            extra_info_c1.m_7220_(gender_c1);
        }
        if (diffOwnerRender) {
            extra_info_c1 = this.createC1WithColor((Component)extra_info_c1, 1464486474);
        }
        this.renderDogText(dog, (Component)extra_info_c1, 0.12f, 0.01f, stack, buffer, packedLight, diffOwnerRender, isDiffOwner);
    }

    private void renderSecondaryInfoDogText(Dog dog, Component text, PoseStack stack, MultiBufferSource buffer, int packedLight, double d0, boolean diffOwnerRender, boolean isDiffOwner) {
        if (d0 > 25.0) {
            return;
        }
        Entity camera_entity = this.f_114476_.f_114358_.m_90592_();
        if (!camera_entity.m_6144_()) {
            return;
        }
        if (dog.m_269323_() == camera_entity) {
            return;
        }
        Component ownerC0 = dog.getOwnersName().orElseGet(() -> this.getNameUnknown(dog));
        if (diffOwnerRender) {
            ownerC0 = this.createC1WithColor(ownerC0, 1464486474);
        }
        this.renderDogText(dog, ownerC0, -0.25, 0.01f, stack, buffer, packedLight, diffOwnerRender, isDiffOwner);
    }

    private Optional<Component> getHungerC1(Dog dog, boolean renderHealthInNameActivated) {
        boolean hightlight_red;
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && !dog.isDefeated()) {
            return Optional.empty();
        }
        String hunger_format = (String)ConfigHandler.CLIENT.DOG_INFO_HUNGER_FORMAT.get();
        int hunger = 0;
        hunger = dog.isDefeated() ? -dog.getDogIncapValue() : Mth.m_14167_((float)dog.getDogHunger());
        MutableComponent hunger_c1 = Component.m_237113_((String)String.format(Locale.ROOT, hunger_format, hunger));
        boolean bl = hightlight_red = dog.getDogHunger() <= 10.0f && renderHealthInNameActivated || dog.isDefeated();
        if (hightlight_red) {
            hunger_c1.m_130948_(Style.f_131099_.m_178520_(0xFF3636));
        }
        return Optional.of(hunger_c1);
    }

    private Optional<Component> getGenderC1(Dog dog) {
        if (((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue()) {
            return Optional.empty();
        }
        MutableComponent ret = Component.m_237115_((String)dog.getGender().getUnlocalisedTip());
        return Optional.of(ret);
    }

    private Component modifyMainText(Dog dog, Component text, boolean diffOwnerRender, boolean renderDogOnDuty) {
        boolean renderHealthInNameActive;
        if (diffOwnerRender) {
            text = this.createC1WithColor(text, 1464486474);
            return text;
        }
        if (renderDogOnDuty) {
            if (dog.dogOnDuty()) {
                text = this.createC1WithColor(text, -61191);
            }
            return text;
        }
        if (dog.isDogInAnimDebug()) {
            text = this.createC1WithColor(text, -3299584);
            return text;
        }
        boolean bl = renderHealthInNameActive = this.f_114476_.f_114358_.m_90592_().m_6144_() && (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_HEALTH_IN_NAME) != false;
        if (renderHealthInNameActive) {
            text = this.colorTextWithHealth(dog, text);
        }
        return text;
    }

    private Component colorTextWithHealth(Dog dog, Component text) {
        int noCharsInName = text.getString().length();
        float healthPercentage = dog.m_21223_() / dog.m_21233_();
        healthPercentage = Mth.m_14036_((float)healthPercentage, (float)0.0f, (float)1.0f);
        int noCharHighlighted = Mth.m_14167_((float)((float)noCharsInName * healthPercentage));
        noCharHighlighted = Mth.m_14045_((int)noCharHighlighted, (int)0, (int)noCharsInName);
        String hlPart = text.getString().substring(0, noCharHighlighted);
        String nonHlPart = "";
        if (noCharHighlighted <= noCharsInName) {
            nonHlPart = text.getString().substring(noCharHighlighted, noCharsInName);
        }
        int color = 0xFF3636;
        if ((double)healthPercentage >= 0.7) {
            color = 720707;
        } else if ((double)healthPercentage >= 0.3) {
            color = 15727189;
        }
        MutableComponent newTxt = this.createC1WithColor(hlPart, color);
        MutableComponent restTxt = this.createC1WithColor(nonHlPart, 0x4A4A4A);
        newTxt.m_7220_((Component)restTxt);
        text = newTxt;
        return text;
    }

    private MutableComponent createC1WithColor(String str, int color) {
        return Component.m_237113_((String)str).m_130948_(Style.f_131099_.m_178520_(color));
    }

    private MutableComponent createC1WithColor(Component c1, int color) {
        return this.createC1WithColor(c1.getString(), color);
    }

    public void MobRenderer_render(Dog p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
        this.LivingEntityRenderer_render(p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
    }

    public void LivingEntityRenderer_render(Dog p_115308_, float p_115309_, float p_115310_, PoseStack p_115311_, MultiBufferSource p_115312_, int p_115313_) {
        boolean shouldSit;
        p_115311_.m_85836_();
        ((DogModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)p_115308_, p_115310_);
        ((DogModel)this.f_115290_).f_102609_ = shouldSit = p_115308_.m_20159_() && p_115308_.m_20202_() != null && p_115308_.m_20202_().shouldRiderSit();
        ((DogModel)this.f_115290_).f_102610_ = p_115308_.m_6162_();
        float f = Mth.m_14189_((float)p_115310_, (float)p_115308_.f_20884_, (float)p_115308_.f_20883_);
        float f1 = Mth.m_14189_((float)p_115310_, (float)p_115308_.f_20886_, (float)p_115308_.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && p_115308_.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_115308_.m_20202_();
            f = Mth.m_14189_((float)p_115310_, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)p_115310_, (float)p_115308_.f_19860_, (float)p_115308_.m_146909_());
        float f7 = this.getBob(p_115308_, p_115310_);
        this.setupRotations(p_115308_, p_115311_, f7, f, p_115310_);
        p_115311_.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(p_115308_, p_115311_, p_115310_);
        p_115311_.m_252880_(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && p_115308_.m_6084_()) {
            f8 = p_115308_.f_267362_.m_267711_(p_115310_);
            f5 = p_115308_.f_267362_.m_267590_(p_115310_);
            if (p_115308_.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((DogModel)this.f_115290_).prepareMobModel(p_115308_, f5, f8, p_115310_);
        ((DogModel)this.f_115290_).setupAnim(p_115308_, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_((LivingEntity)p_115308_);
        boolean flag1 = !flag && !p_115308_.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)p_115308_);
        RenderType rendertype = this.m_7225_((LivingEntity)p_115308_, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = p_115312_.m_6299_(rendertype);
            int i = DogRenderer.m_115338_((LivingEntity)p_115308_, (float)this.m_6931_((LivingEntity)p_115308_, p_115310_));
            ((DogModel)this.f_115290_).m_7695_(p_115311_, vertexconsumer, p_115313_, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!p_115308_.m_5833_()) {
            for (RenderLayer<Dog, DogModel> renderlayer : this.originalDogLayers) {
                renderlayer.m_6494_(p_115311_, p_115312_, p_115313_, (Entity)p_115308_, f5, f8, p_115310_, f7, f2, f6);
            }
        }
        p_115311_.m_85849_();
        if (this.shouldShowName(p_115308_)) {
            this.renderNameTag(p_115308_, p_115308_.m_5446_(), p_115311_, p_115312_, p_115313_);
        }
    }

    protected void setupRotations(Dog p_115317_, PoseStack p_115318_, float p_115319_, float p_115320_, float p_115321_) {
        if (((Boolean)ConfigHandler.CLIENT.BLOCK_THIRD_PARTY_NAMETAG.get()).booleanValue()) {
            if (p_115317_.f_20919_ > 0) {
                float f = ((float)p_115317_.f_20919_ + p_115321_ - 1.0f) / 20.0f * 1.6f;
                if ((f = Mth.m_14116_((float)f)) > 1.0f) {
                    f = 1.0f;
                }
                p_115318_.m_252781_(Axis.f_252403_.m_252977_(f * this.m_6441_((LivingEntity)p_115317_)));
            } else {
                p_115318_.m_252781_(Axis.f_252436_.m_252977_(180.0f - p_115320_));
            }
            return;
        }
        super.m_7523_((LivingEntity)p_115317_, p_115318_, p_115319_, p_115320_, p_115321_);
    }
}

