/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.event;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyItems;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.anim.DogAnimation;
import doggytalents.client.DoggyKeybinds;
import doggytalents.client.block.model.DogBedModel;
import doggytalents.client.entity.model.animation.DogAnimationRegistry;
import doggytalents.client.entity.model.animation.DogKeyframeAnimations;
import doggytalents.client.entity.render.world.CanineTrackerLocateRenderer;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.store.UIActionTypes;
import doggytalents.client.screen.DogNewInfoScreen.store.slice.TalentChangeHandlerSlice;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.UIAction;
import doggytalents.client.screen.widget.DogInventoryButton;
import doggytalents.client.screen.widget.DoggySpin.DoggySpin;
import doggytalents.common.block.DogBedBlock;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationState;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.network.packet.data.DogSyncData;
import doggytalents.common.network.packet.data.WhistleUseData;
import doggytalents.common.util.InventoryUtil;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientEventHandler {
    public static void registerModelForBaking(ModelEvent.RegisterAdditional event) {
        try {
            ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)((Block)DoggyBlocks.DOG_BED.get()));
            ResourceLocation unbakedModelLoc = new ResourceLocation(resourceLocation.m_135827_(), "block/" + resourceLocation.m_135815_());
            event.register(unbakedModelLoc);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.warn("Could not get base Dog Bed model. Reverting to default textures...");
            e.printStackTrace();
        }
    }

    public static void modifyBakedModels(ModelEvent.ModifyBakingResult event) {
        try {
            Map modelRegistry = event.getModels();
            ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)((Block)DoggyBlocks.DOG_BED.get()));
            ResourceLocation bakedModelLoc = new ResourceLocation(resourceLocation.m_135827_(), "block/" + resourceLocation.m_135815_());
            BakedModel model = (BakedModel)modelRegistry.get(bakedModelLoc);
            BlockModel modelUnbaked = (BlockModel)event.getModelBakery().m_119341_(bakedModelLoc);
            DogBedModel customModel = new DogBedModel(event.getModelBakery(), modelUnbaked, model, (Integer)ConfigHandler.CLIENT.MAX_DOG_BED_MODEL_CACHE.get());
            ((DogBedBlock)((Object)DoggyBlocks.DOG_BED.get())).m_49965_().m_61056_().forEach(state -> modelRegistry.put(BlockModelShaper.m_110895_((BlockState)state), customModel));
            modelRegistry.put(new ModelResourceLocation(resourceLocation, "inventory"), customModel);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.warn("Error modifying baking result. Reverting to default textures...");
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onInputEvent(MovementInputUpdateEvent event) {
        if (!event.getInput().f_108572_) {
            return;
        }
        Player entity = event.getEntity();
        Entity vehicle = entity.m_20202_();
        if (!entity.m_20159_()) {
            return;
        }
        if (!(vehicle instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)vehicle;
        if (!dog.canJump()) {
            return;
        }
        dog.setJumpPower(100);
    }

    @SubscribeEvent
    public void onScreenInit(ScreenEvent.Init.Post event) {
        DogInventoryButton.onScreenInit(event);
        DoggySpin.onScreenInit(event);
    }

    @SubscribeEvent
    public void onScreenDrawForeground(ScreenEvent.Render.Post event) {
        DoggySpin.onScreenRenderForeground(event);
    }

    @SubscribeEvent
    public void onKeyboardInput(InputEvent.Key event) {
        this.proccessWhistle(event);
    }

    public void proccessWhistle(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        WhistleItem whistle = DoggyItems.WHISTLE.get();
        ItemStack whistle_stack = InventoryUtil.findStackWithItemFromHands((Player)player, whistle);
        if (whistle_stack == null) {
            return;
        }
        int hotkey_use = -1;
        KeyMapping[] hotkeys_whistle = DoggyKeybinds.hotkeys_whistle;
        for (int i = 0; i < hotkeys_whistle.length; ++i) {
            if (!hotkeys_whistle[i].m_90859_()) continue;
            hotkey_use = i;
            break;
        }
        if (hotkey_use < 0) {
            return;
        }
        if (player.m_36335_().m_41519_((Item)whistle)) {
            return;
        }
        CompoundTag tag = whistle_stack.m_41783_();
        if (tag == null) {
            return;
        }
        int[] hotkeyarr = tag.m_128465_("hotkey_modes");
        if (hotkeyarr == null) {
            return;
        }
        if (hotkeyarr.length != 4) {
            return;
        }
        int mode_id = hotkeyarr[hotkey_use];
        WhistleItem.WhistleMode[] whistle_modes = WhistleItem.WhistleMode.VALUES;
        if (mode_id >= whistle_modes.length) {
            return;
        }
        if (mode_id < 0) {
            return;
        }
        WhistleItem.WhistleMode useMode = whistle_modes[mode_id];
        List dogsList = player.m_9236_().m_6443_(Dog.class, player.m_20191_().m_82377_(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.m_21830_((LivingEntity)player));
        whistle.useMode(useMode, false, dogsList, player.m_9236_(), (Player)player, InteractionHand.MAIN_HAND, true);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhistleUseData(mode_id));
    }

    public void drawSelectionBox(PoseStack matrixStackIn, Player player, float particleTicks, AABB boundingBox) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f);
        RenderSystem.lineWidth((float)2.0f);
        Vec3 vec3d = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double d0 = vec3d.m_7096_();
        double d1 = vec3d.m_7098_();
        double d2 = vec3d.m_7094_();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        LevelRenderer.m_109646_((PoseStack)matrixStackIn, (VertexConsumer)bufferbuilder, (AABB)boundingBox.m_82386_(-d0, -d1, -d2), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.8f);
        Tesselator.m_85913_().m_85914_();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void onDogMountEvent(DogMountData data) {
        Minecraft mc = Minecraft.m_91087_();
        Entity e = mc.f_91073_.m_6815_(data.dogId);
        LocalPlayer player = mc.f_91074_;
        if (e instanceof Dog) {
            Dog d = (Dog)e;
            if (data.mount && player != null) {
                d.m_20329_((Entity)player);
            } else {
                d.m_8127_();
            }
        }
    }

    public static boolean vertifyBlockTexture(ResourceLocation loc) {
        ResourceLocation path = ClientEventHandler.getAbsoluteBlockTexture(loc);
        Optional res = Minecraft.m_91087_().m_91098_().m_213713_(path);
        return res.isPresent();
    }

    public static ResourceLocation getAbsoluteBlockTexture(ResourceLocation loc) {
        return new ResourceLocation(loc.m_135827_(), "textures/" + loc.m_135815_() + ".png");
    }

    public static boolean vertifyArmorTexture(ResourceLocation loc) {
        Optional res = Minecraft.m_91087_().m_91098_().m_213713_(loc);
        return res.isPresent();
    }

    public static boolean shouldClientBlockPick(Dog dog) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        if (!dog.m_20160_()) {
            return false;
        }
        return player.m_20202_() == dog || player.m_6144_();
    }

    public static float getAnimatedYRot(Dog dog) {
        if (dog.getAnim() == DogAnimation.NONE) {
            return 0.0f;
        }
        DogAnimation anim = dog.getAnim();
        AnimationDefinition animSeq = DogAnimationRegistry.getSequence(anim);
        if (animSeq == null) {
            return 0.0f;
        }
        DogAnimationState animState = dog.animationManager.animationState;
        float ret = DogKeyframeAnimations.getCurrentAnimatedYRot(dog, animSeq, animState.getAccumulatedTimeMillis(), 1.0f);
        if (anim.rootRotation().isPresent()) {
            Float root_rotation = anim.rootRotation().get();
            ret += root_rotation.floatValue() * ((float)Math.PI / 180);
        }
        return ret;
    }

    public static void onDogSyncedDataUpdated(DogSyncData data) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Entity e = level.m_6815_(data.dogId);
        if (!(e instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)e;
        dog.dogSyncedDataManager.updateFromDataPacketFromServer(data);
    }

    public static void onDogTalentUpdated(Dog dog) {
        Minecraft mc = Minecraft.m_91087_();
        Screen screen = mc.f_91080_;
        if (screen == null) {
            return;
        }
        if (!(screen instanceof DogNewInfoScreen)) {
            return;
        }
        DogNewInfoScreen infoScr = (DogNewInfoScreen)screen;
        if (infoScr.dog != dog) {
            return;
        }
        Store.get(infoScr).dispatch(TalentChangeHandlerSlice.class, new UIAction(UIActionTypes.Talents.TALENT_UPDATE, null));
    }

    @SubscribeEvent
    public void onPlayerLoggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
        CanineTrackerLocateRenderer.onWorldLogOut();
    }

    public static String getTranslatedVariantStr(DogVariant variant) {
        String translation_key = variant.translation();
        if (I18n.m_118936_((String)translation_key)) {
            return I18n.m_118938_((String)translation_key, (Object[])new Object[0]);
        }
        return variant.id().toString();
    }
}

