/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.client.screen.widget.CustomButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogMigrateOwnerData;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.network.PacketDistributor;

public class DogMigrateOwnerScreen
extends Screen {
    private Dog dog;
    @Nullable
    private UUID migrateTo;
    private String migrateToStr;
    private TextOnlyButton uuidShowButton;

    protected DogMigrateOwnerScreen(Dog dog, @Nullable UUID migrateTo, String ownerName) {
        super((Component)Component.m_237113_((String)""));
        this.dog = dog;
        this.migrateTo = migrateTo;
        this.migrateToStr = ownerName;
    }

    public static void open(Dog dog, UUID migrateTo, String ownerName) {
        Minecraft mc = Minecraft.m_91087_();
        DogMigrateOwnerScreen screen = new DogMigrateOwnerScreen(dog, migrateTo, ownerName == null ? "" : ownerName);
        mc.m_91152_((Screen)screen);
    }

    protected void m_7856_() {
        this.uuidShowButton = new TextOnlyButton(0, 0, 100, 20, (Component)Component.m_237115_((String)"doggui.migrate_owner.show_uuid").m_130940_(ChatFormatting.GRAY), $ -> {}, Minecraft.m_91087_().f_91062_){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                graphics.m_280666_(DogMigrateOwnerScreen.this.f_96547_, List.of(Component.m_237113_((String)(DogMigrateOwnerScreen.this.migrateTo == null ? "UUID_ZERO" : DogMigrateOwnerScreen.this.migrateTo.toString()))), mouseX, mouseY);
            }
        };
        if (this.migrateTo == null) {
            return;
        }
        this.addConfirmButton();
        this.addDenyButton();
        this.m_142416_((GuiEventListener)this.uuidShowButton);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, pTicks);
        PoseStack stack = graphics.m_280168_();
        if (this.migrateTo != null) {
            this.drawWhenHaveRequest(graphics, mouseX, mouseY, pTicks, this.migrateTo, this.migrateToStr);
            return;
        }
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        int pY = mY - 72;
        MutableComponent title = Component.m_237115_((String)"doggui.migrate_owner.help.title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED));
        List help = this.f_96547_.m_92923_((FormattedText)Component.m_237115_((String)"doggui.migrate_owner.help.subtitle"), 300);
        String escToReturn = I18n.m_118938_((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.m_85836_();
        stack.m_85841_(1.2f, 1.2f, 1.2f);
        graphics.m_280430_(this.f_96547_, (Component)title, Mth.m_14143_((float)((float)mX / 1.2f - (float)(this.f_96547_.m_92852_((FormattedText)title) / 2))), Mth.m_14143_((float)((float)pY / 1.2f)), -1);
        stack.m_85849_();
        pY += 40;
        for (FormattedCharSequence line : help) {
            graphics.m_280648_(this.f_96547_, line, mX - this.f_96547_.m_92724_(line) / 2, pY, -1);
            Objects.requireNonNull(this.f_96547_);
            pY += 9 + 3;
        }
        graphics.m_280488_(this.f_96547_, escToReturn, mX - this.f_96547_.m_92895_(escToReturn) / 2, pY += 40, -1);
    }

    public void drawWhenHaveRequest(GuiGraphics graphics, int mouseX, int mouseY, float pTicks, UUID newOwnerUUID, String newOwnerName) {
        PoseStack stack = graphics.m_280168_();
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        int pY = mY - 72;
        MutableComponent title = Component.m_237115_((String)"doggui.migrate_owner.confirm.title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_131140_(ChatFormatting.RED));
        String help = I18n.m_118938_((String)"doggui.migrate_owner.confirm.subtitle", (Object[])new Object[]{this.dog.m_7755_().getString()});
        String dog_title = I18n.m_118938_((String)"doggui.migrate_owner.info.dog", (Object[])new Object[]{this.dog.m_7755_().getString()});
        MutableComponent owner_title = Component.m_237110_((String)"doggui.migrate_owner.info.new_owner", (Object[])new Object[]{newOwnerName});
        String costStr = I18n.m_118938_((String)"doggui.talents.cost", (Object[])new Object[0]) + AmnesiaBoneItem.getMigrateOwnerXPCost();
        String escToReturn = I18n.m_118938_((String)"doggui.invalid_dog.esc_to_return", (Object[])new Object[0]);
        stack.m_85836_();
        stack.m_85841_(1.2f, 1.2f, 1.2f);
        graphics.m_280430_(this.f_96547_, (Component)title, Mth.m_14143_((float)((float)mX / 1.2f - (float)(this.f_96547_.m_92852_((FormattedText)title) / 2))), Mth.m_14143_((float)((float)pY / 1.2f)), -1);
        stack.m_85849_();
        graphics.m_280488_(this.f_96547_, help, mX - this.f_96547_.m_92895_(help) / 2, pY += 40, -1);
        graphics.m_280488_(this.f_96547_, dog_title, mX - this.f_96547_.m_92895_(dog_title) / 2, pY += 40, -1);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280430_(this.f_96547_, (Component)owner_title, mX - this.f_96547_.m_92852_((FormattedText)owner_title) / 2, pY += 9 + 3, -1);
        Objects.requireNonNull(this.f_96547_);
        this.uuidShowButton.m_252865_(this.f_96543_ / 2 - this.uuidShowButton.m_5711_() / 2);
        this.uuidShowButton.m_253211_((pY += 9 + 3) - 6);
        Objects.requireNonNull(this.f_96547_);
        graphics.m_280488_(this.f_96547_, costStr, mX - this.f_96547_.m_92895_(costStr) / 2, pY += 9 + 6, -1);
        graphics.m_280488_(this.f_96547_, escToReturn, mX - this.f_96547_.m_92895_(escToReturn) / 2, pY += 40, -1);
    }

    public boolean m_7043_() {
        return false;
    }

    private void addConfirmButton() {
        var confirmButton = new CustomButton(this.f_96543_ / 2 + 2, this.f_96544_ / 2 + 58, 50, 20, (Component)Component.m_237115_((String)"doggui.migrate_owner.confirm"), b -> {
            this.requestMigrateOwner(true);
            Minecraft.m_91087_().m_91152_(null);
        }){

            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_87963_(graphics, mouseX, mouseY, pTicks);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                this.f_93623_ = player != null && player.f_36078_ >= AmnesiaBoneItem.getMigrateOwnerXPCost();
            }

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                if (this.f_93623_) {
                    return;
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null || player.f_36078_ >= AmnesiaBoneItem.getMigrateOwnerXPCost()) {
                    return;
                }
                MutableComponent c1 = Component.m_237115_((String)"doggui.detrain.talents.insufficent_xp");
                c1.m_6270_(Style.f_131099_.m_178520_(-5111808).m_131136_(Boolean.valueOf(true)));
                graphics.m_280666_(DogMigrateOwnerScreen.this.f_96547_, List.of(c1), mouseX, mouseY);
            }
        };
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        confirmButton.f_93623_ = player != null && player.f_36078_ >= AmnesiaBoneItem.getMigrateOwnerXPCost();
        this.m_142416_((GuiEventListener)confirmButton);
    }

    public void addDenyButton() {
        CustomButton denyButton = new CustomButton(this.f_96543_ / 2 - 50 - 2, this.f_96544_ / 2 + 58, 50, 20, (Component)Component.m_237115_((String)"doggui.migrate_owner.deny"), b -> {
            this.requestMigrateOwner(false);
            Minecraft.m_91087_().m_91152_(null);
        });
        this.m_142416_((GuiEventListener)denyButton);
    }

    private void requestMigrateOwner(boolean confirmed) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogMigrateOwnerData(this.dog.m_19879_(), confirmed));
    }
}

