/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByNameData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class HeelByNameScreen
extends StringEntrySelectScreen {
    private final Player player;
    private final List<String> dogNameList = new ArrayList<String>();
    private final List<Integer> dogIdList = new ArrayList<Integer>();
    private boolean showUuid = false;
    private boolean heelAndSit = false;
    private boolean softHeel = false;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;

    public HeelByNameScreen(Player player, boolean softHeel) {
        super((Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name"));
        this.player = player;
        this.softHeel = softHeel;
        List<Dog> dogsList = Minecraft.m_91087_().f_91073_.m_6443_(Dog.class, this.player.m_20191_().m_82377_(100.0, 50.0, 100.0), d -> d.m_21830_((LivingEntity)player));
        dogsList = FrequentHeelStore.get(this).sortDogList(dogsList);
        for (Dog d2 : dogsList) {
            this.dogNameList.add(d2.m_7755_().getString());
            this.dogIdList.add(d2.m_19879_());
        }
        this.updateEntries(this.dogNameList);
    }

    public static void open() {
        HeelByNameScreen.open(0);
    }

    public static void open(int blockCharInputMillis) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (stack == null) {
            return;
        }
        if (!(stack.m_41720_() instanceof WhistleItem)) {
            return;
        }
        boolean softHeel = false;
        if (stack.m_41782_()) {
            softHeel = stack.m_41783_().m_128471_("soft_heel");
        }
        HeelByNameScreen screen = new HeelByNameScreen((Player)mc.f_91074_, softHeel);
        screen.setBlockCharInputTime(blockCharInputMillis);
        mc.m_91152_((Screen)screen);
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(0, pY, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.m_93666_((Component)Component.m_237115_((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        showUuid.m_252865_(mX - 100 - showUuid.m_5711_() - 2);
        String soft_heel_title_id = "doggytalents.screen.whistler.heel_by_name.soft_heel";
        MutableComponent inital_softHeel_c1 = this.softHeel ? Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").m_130948_(Style.f_131099_.m_178520_(this.getHightlightSelectedColor())) : Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel");
        FlatButton softHeel = new FlatButton(0, pY += showUuid.m_93694_() + 2, 60, 20, (Component)inital_softHeel_c1, b -> {
            boolean bl = this.softHeel = !this.softHeel;
            if (this.softHeel) {
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").m_130948_(Style.f_131099_.m_178520_(this.getHightlightSelectedColor())));
            } else {
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel"));
            }
        }){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.whistler.heel_by_name.soft_heel.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByNameScreen.this.f_96547_));
                graphics.m_280666_(HeelByNameScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        softHeel.m_252865_(mX - 100 - softHeel.m_5711_() - 2);
        FlatButton help = new FlatButton(0, pY += softHeel.m_93694_() + 2, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            @Override
            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_87963_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.heel_by_name.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String base_help = I18n.m_118938_((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(base_help, 150, HeelByNameScreen.this.f_96547_));
                String additional_help = I18n.m_118938_((String)"doggytalents.screen.whistler.heel_by_name.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(additional_help, 150, HeelByNameScreen.this.f_96547_));
                graphics.m_280666_(HeelByNameScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        help.m_252865_(mX - 100 - help.m_5711_() - 2);
        this.m_142416_((GuiEventListener)showUuid);
        this.m_142416_((GuiEventListener)help);
        this.m_142416_((GuiEventListener)softHeel);
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"doggytalents.screen.whistler.heel_by_name.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    protected Component modifyEntryText(Component entryText, int entryId, boolean is_selected) {
        if (this.heelAndSit && is_selected) {
            entryText = entryText.m_6881_().m_130948_(Style.f_131099_.m_178520_(0xFF6F00));
        }
        return entryText;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        Integer dog_id = this.dogIdList.get(entry_id);
        Entity dog = this.f_96541_.f_91073_.m_6815_(dog_id.intValue());
        if (dog == null) {
            return;
        }
        String uuid = dog.m_20149_();
        if (uuid == null) {
            return;
        }
        MutableComponent uuid_c1 = Component.m_237113_((String)uuid.toString()).m_130940_(ChatFormatting.GRAY);
        if (this.f_96544_ >= 273) {
            int mX = this.f_96543_ / 2;
            int mY = this.f_96544_ / 2;
            int uuid_width = this.f_96547_.m_92852_((FormattedText)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.m_280430_(this.f_96547_, (Component)uuid_c1, tX, tY, -1);
        } else {
            graphics.m_280666_(this.f_96547_, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestHeel(this.dogIdList.get(id));
        Minecraft.m_91087_().m_91152_(null);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    private void requestHeel(int id) {
        FrequentHeelStore.get(this).pushDogToFrequentStack(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByNameData(id, this.heelAndSit, this.softHeel));
    }

    @Override
    public boolean m_7043_() {
        return false;
    }

    private static class FrequentHeelStore {
        private static FrequentHeelStore INSTANCE;
        private ArrayList<UUID> dogFrequentStack = new ArrayList();
        private Screen screen;
        private ToIntFunction<Dog> GET_FREQ_COUNT = d -> this.getFrequentWeightFor((Dog)d);
        private static final int STORE_CAP = 32;

        private FrequentHeelStore(Screen screen) {
            this.screen = screen;
        }

        public void pushDogToFrequentStack(int id) {
            Entity dog = this.screen.getMinecraft().f_91073_.m_6815_(id);
            if (dog == null) {
                return;
            }
            String uuid_str = dog.m_20149_();
            if (uuid_str == null) {
                return;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            if (indx > 0) {
                if (indx >= this.dogFrequentStack.size() - 1) {
                    return;
                }
                this.dogFrequentStack.remove(uuid);
            }
            this.dogFrequentStack.add(uuid);
            if (this.dogFrequentStack.size() > 32) {
                this.dogFrequentStack.remove(0);
            }
        }

        public int getFrequentWeightFor(Dog dog) {
            String uuid_str = dog.m_20149_();
            if (uuid_str == null) {
                return 0;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return 0;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            return Math.max(0, indx + 1);
        }

        public List<Dog> sortDogList(List<Dog> dogList) {
            return dogList.stream().sorted(Comparator.comparingInt(this.GET_FREQ_COUNT).reversed()).collect(Collectors.toList());
        }

        public static FrequentHeelStore get(Screen screen) {
            if (INSTANCE == null) {
                INSTANCE = new FrequentHeelStore(screen);
            }
            if (FrequentHeelStore.INSTANCE.screen != screen) {
                FrequentHeelStore.INSTANCE.screen = screen;
            }
            return INSTANCE;
        }
    }
}

