/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;

public class StringEntrySelectScreen
extends Screen {
    private List<String> entries;
    private List<Integer> filteredIndexes;
    protected final MouseUpdate mouseUpdate = new MouseUpdate(this);
    protected final EntryView entryView = new EntryView(this);
    protected final TextField searchField = new TextField(this);
    private TextOnlyButton prevPageButton;
    private TextOnlyButton nextPageButton;
    private boolean isSneakPressed = false;

    public StringEntrySelectScreen(Component title) {
        super(title);
        this.entries = new ArrayList<String>();
        this.filteredIndexes = new ArrayList<Integer>();
    }

    public void m_7856_() {
        super.m_7856_();
        this.addPageButtons();
        this.addUtilitiesButton();
    }

    protected void addPageButtons() {
        int half_width = this.f_96543_ / 2;
        int half_height = this.f_96544_ / 2;
        TextOnlyButton prevPage = new TextOnlyButton(half_width - this.getSelectAreaSize() / 2 - 20, half_height - 10, 20, 20, (Component)Component.m_237113_((String)"<"), b -> this.prevPage(), this.f_96547_);
        TextOnlyButton nextPage = new TextOnlyButton(half_width + this.getSelectAreaSize() / 2, half_height - 10, 20, 20, (Component)Component.m_237113_((String)">"), b -> this.nextPage(), this.f_96547_);
        this.prevPageButton = prevPage;
        this.nextPageButton = nextPage;
        this.m_142416_((GuiEventListener)prevPage);
        this.m_142416_((GuiEventListener)nextPage);
    }

    protected void addUtilitiesButton() {
    }

    protected void nextPage() {
        this.entryView.movePage(x -> x + 1);
    }

    protected void prevPage() {
        this.entryView.movePage(x -> x - 1);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.mouseUpdate.update(mouseX, mouseY);
        this.searchField.update();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.entryView.render(graphics);
        this.searchField.render(graphics);
        this.prevPageButton.f_93623_ = this.entryView.prevPageActive();
        this.nextPageButton.f_93623_ = this.entryView.nextPageActive();
    }

    protected void onMouseMoved(double mouseX, double mouseY) {
        this.entryView.onMouseMoved(mouseX, mouseY);
    }

    protected void drawSelectAreaBackground(GuiGraphics graphics) {
        int half_width = this.f_96543_ / 2;
        int half_height = this.f_96544_ / 2;
        graphics.m_280509_(half_width - this.getSelectAreaSize() / 2, half_height - this.getSelectAreaSize() / 2, half_width + this.getSelectAreaSize() / 2, half_height + this.getSelectAreaSize() / 2, Integer.MIN_VALUE);
    }

    protected void drawEntry(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        MutableComponent text = Component.m_237113_((String)this.entries.get(entry_id)).m_6270_(Style.f_131099_.m_178520_(color));
        text = this.modifyEntryText((Component)text, entry_id, is_selected);
        graphics.m_280430_(this.f_96547_, (Component)text, entry_x, entry_y, -1);
    }

    protected Component modifyEntryText(Component entryText, int entryId, boolean is_selected) {
        return entryText;
    }

    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
    }

    protected void drawPageIndicator(GuiGraphics graphics, int pageCount, int activePage) {
        int half_width = this.f_96543_ / 2;
        int half_height = this.f_96544_ / 2;
        String page_str = activePage + 1 + "/" + pageCount;
        int page_str_width = this.f_96547_.m_92895_(page_str);
        graphics.m_280488_(this.f_96547_, page_str, half_width - page_str_width / 2, half_height - this.getSelectAreaSize() / 2 - this.getPageIndicatorOffset(), -1);
    }

    public boolean m_5534_(char code, int p_231042_2_) {
        return this.searchField.charTyped(code, p_231042_2_);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean move_right;
        boolean move_left;
        boolean focus_search_field;
        boolean text_field_focused;
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = text_field_focused = this.searchField.focusState() == TextField.FocusState.FOCUS;
        if (keyCode == mc.f_91066_.f_92090_.getKey().m_84873_()) {
            this.isSneakPressed = true;
        }
        if (this.entryView.keyPressed(text_field_focused, keyCode, scanCode, modifiers)) {
            return true;
        }
        boolean bl2 = focus_search_field = keyCode == mc.f_91066_.f_92089_.getKey().m_84873_() && this.isSneakPressed && this.searchField.focusState() == TextField.FocusState.NONE;
        if (focus_search_field) {
            this.searchField.setFocusState(TextField.FocusState.READY);
            return true;
        }
        boolean bl3 = move_left = !text_field_focused && (keyCode == 263 || keyCode == mc.f_91066_.f_92086_.getKey().m_84873_());
        if (move_left) {
            if (this.prevPageButton.f_93623_) {
                this.prevPageButton.m_5716_(0.0, 0.0);
            }
            return true;
        }
        boolean bl4 = move_right = !text_field_focused && (keyCode == 262 || keyCode == mc.f_91066_.f_92088_.getKey().m_84873_());
        if (move_right) {
            if (this.nextPageButton.f_93623_) {
                this.nextPageButton.m_5716_(0.0, 0.0);
            }
            return true;
        }
        if (this.searchField.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        boolean is_confirm;
        boolean text_field_focus_ready;
        Minecraft mc = Minecraft.m_91087_();
        boolean bl = text_field_focus_ready = this.searchField.focusState() == TextField.FocusState.READY && keyCode == mc.f_91066_.f_92089_.getKey().m_84873_();
        if (text_field_focus_ready) {
            this.searchField.setFocusState(TextField.FocusState.FOCUS);
        }
        if (keyCode == mc.f_91066_.f_92090_.getKey().m_84873_()) {
            this.isSneakPressed = false;
        }
        boolean bl2 = is_confirm = keyCode == 257 || keyCode == mc.f_91066_.f_92089_.getKey().m_84873_() && !this.isSneakPressed && this.searchField.focusState() == TextField.FocusState.NONE;
        if (is_confirm) {
            Optional<Integer> selected_indx = this.entryView.getSelectedFilterId(this.filteredIndexes);
            if (selected_indx.isPresent()) {
                this.onEntrySelected(selected_indx.get());
            }
            return true;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        this.searchField.setFocusState(TextField.FocusState.NONE);
        Optional<Integer> clicked_id = this.entryView.getHoveringEntry(x, y, this.filteredIndexes);
        if (clicked_id.isPresent()) {
            this.onEntrySelected(clicked_id.get());
            return true;
        }
        return super.m_6375_(x, y, p_94697_);
    }

    protected void onEntrySelected(int id) {
    }

    protected void updateEntries(List<String> new_entries) {
        if (new_entries == null) {
            return;
        }
        this.entries = new_entries;
        this.updateFilteredIndexes();
    }

    protected void onTextFieldUpdated() {
        this.updateFilteredIndexes();
    }

    protected void updateFilteredIndexes() {
        this.filteredIndexes.clear();
        String search_str = this.searchField.getValue();
        if (search_str == null || search_str.isEmpty()) {
            for (int i = 0; i < this.entries.size(); ++i) {
                this.filteredIndexes.add(i);
            }
            this.onFilteredIndexesUpdated();
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            boolean matched;
            String entry = this.entries.get(i);
            if (entry.length() < search_str.length()) continue;
            boolean bl = matched = this.matchIgnoreCaseSearch() ? entry.toLowerCase().contains(search_str.toLowerCase()) : entry.contains(search_str);
            if (!matched) continue;
            this.filteredIndexes.add(i);
        }
        this.onFilteredIndexesUpdated();
    }

    protected void onFilteredIndexesUpdated() {
        this.entryView.onFilteredIndexesUpdated(this.filteredIndexes);
    }

    public void setBlockCharInputTime(int millis) {
        this.searchField.setBlockCharInputTime(millis);
    }

    public Optional<Integer> getHoveredEntry(int mouseX, int mouseY) {
        return this.entryView.getHoveringEntry(mouseX, mouseY, this.filteredIndexes);
    }

    protected int getMaxEntriesPerPage() {
        return 19;
    }

    protected int getSelectAreaSize() {
        return 200;
    }

    protected int getSearchBarOffset() {
        return 7;
    }

    protected int getPageIndicatorOffset() {
        return 10;
    }

    protected int getSpacePerEntry() {
        return 10;
    }

    protected int getHightlightSelectedColor() {
        return -61191;
    }

    protected int getMaxSearchBufferSize() {
        return 64;
    }

    protected boolean matchIgnoreCaseSearch() {
        return false;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return null;
    }

    public boolean m_7043_() {
        return false;
    }

    public static class MouseUpdate {
        private final StringEntrySelectScreen parent;
        private boolean startedUpdate = false;
        private int mouseX0 = 0;
        private int mouseY0 = 0;

        private MouseUpdate(StringEntrySelectScreen parent) {
            this.parent = parent;
        }

        public void update(int mouseX, int mouseY) {
            if (this.startedUpdate) {
                this.updateMouseMoved(mouseX, mouseY);
            } else {
                this.mayStartUpdatingMouseMove(mouseX, mouseY);
            }
        }

        private void updateMouseMoved(int mouseX, int mouseY) {
            boolean mouse_moved;
            boolean bl = mouse_moved = this.mouseX0 != mouseX || this.mouseY0 != mouseY;
            if (!mouse_moved) {
                return;
            }
            this.parent.onMouseMoved(mouseX, mouseY);
            this.mouseX0 = mouseX;
            this.mouseY0 = mouseY;
        }

        private void mayStartUpdatingMouseMove(int mouseX, int mouseY) {
            int half_width = this.parent.f_96543_ / 2;
            int half_height = this.parent.f_96544_ / 2;
            int dx = Math.abs(mouseX - half_width);
            int dy = Math.abs(mouseY - half_height);
            if (dx > 10 || dy > 10) {
                this.startedUpdate = true;
                this.mouseX0 = mouseX;
                this.mouseY0 = mouseY;
            }
        }
    }

    public static class EntryView {
        private final StringEntrySelectScreen parent;
        private int pageCount = 1;
        private int activePage = 0;
        private int selectedEntryInPage = 0;

        public boolean keyPressed(boolean textFieldFocused, int keyCode, int scanCode, int modifiers) {
            boolean is_up;
            boolean is_down;
            Minecraft mc = Minecraft.m_91087_();
            InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
            boolean bl = is_down = keyCode == 264 || !textFieldFocused && keyCode == mc.f_91066_.f_92087_.getKey().m_84873_();
            if (is_down) {
                this.moveSelectedEntryInPage(x -> x + 1);
                return true;
            }
            boolean bl2 = is_up = keyCode == 265 || !textFieldFocused && keyCode == mc.f_91066_.f_92085_.getKey().m_84873_();
            if (is_up) {
                this.moveSelectedEntryInPage(x -> x - 1);
                return true;
            }
            return false;
        }

        public void onMouseMoved(double mouseX, double mouseY) {
            Optional<Integer> new_indx_optional = this.getHoveredIndexInPage(mouseX, mouseY);
            if (!new_indx_optional.isPresent()) {
                return;
            }
            int new_indx = new_indx_optional.get();
            this.moveSelectedEntryInPage(x -> new_indx);
        }

        public void onFilteredIndexesUpdated(List<Integer> filtered_indexes) {
            this.resetSelectedEntryInPage();
            this.updatePages(filtered_indexes);
        }

        public Optional<Integer> getHoveringEntry(double x, double y, List<Integer> filtered_indexes) {
            if (filtered_indexes.isEmpty()) {
                return Optional.empty();
            }
            Optional<Integer> indx_optional = this.getHoveredIndexInPage(x, y);
            if (!indx_optional.isPresent()) {
                return Optional.empty();
            }
            return this.getSelectedFilterId(filtered_indexes);
        }

        public boolean prevPageActive() {
            return this.activePage > 0;
        }

        public boolean nextPageActive() {
            return this.activePage < this.pageCount - 1;
        }

        private EntryView(StringEntrySelectScreen parent) {
            this.parent = parent;
        }

        private void updatePages(List<Integer> filtered_indexes) {
            int filter_size = filtered_indexes.size();
            this.activePage = 0;
            this.pageCount = filter_size / this.parent.getMaxEntriesPerPage();
            if (filter_size % this.parent.getMaxEntriesPerPage() > 0) {
                ++this.pageCount;
            }
        }

        protected void render(GuiGraphics graphics) {
            this.parent.drawSelectAreaBackground(graphics);
            this.drawEntries(graphics);
            this.parent.drawPageIndicator(graphics, this.pageCount, this.activePage);
        }

        protected void drawEntries(GuiGraphics graphics) {
            int half_width = this.parent.f_96543_ / 2;
            int half_height = this.parent.f_96544_ / 2;
            int entry_offset = 0;
            int entry_start_x = half_width - this.parent.getSelectAreaSize() / 2 + 2;
            int entry_start_y = half_height - this.parent.getSelectAreaSize() / 2 + 2;
            int startIndx = this.activePage * this.parent.getMaxEntriesPerPage();
            int drawNo = 0;
            if (this.parent.filteredIndexes.isEmpty()) {
                this.parent.drawNoEntryMsg(graphics, entry_start_x, entry_start_y);
                return;
            }
            for (int i = startIndx; i < this.parent.filteredIndexes.size(); ++i) {
                this.parent.drawEntry(graphics, entry_start_x, entry_start_y + entry_offset, this.parent.filteredIndexes.get(i), i == startIndx + this.selectedEntryInPage);
                entry_offset += this.parent.getSpacePerEntry();
                if (++drawNo >= this.parent.getMaxEntriesPerPage()) break;
            }
        }

        public void movePage(IntFunction<Integer> mover) {
            if (this.pageCount <= 0) {
                return;
            }
            int new_page = mover.apply(this.activePage);
            this.activePage = Mth.m_14045_((int)new_page, (int)0, (int)(this.pageCount - 1));
            this.onPageMove();
        }

        protected void onPageMove() {
            this.resetSelectedEntryInPage();
        }

        public int getCurrentPageEntries() {
            boolean is_last_page;
            boolean bl = is_last_page = this.activePage >= this.pageCount - 1;
            if (!is_last_page) {
                return this.parent.getMaxEntriesPerPage();
            }
            int exccess = this.parent.filteredIndexes.size() % this.parent.getMaxEntriesPerPage();
            return exccess != 0 ? exccess : this.parent.filteredIndexes.size();
        }

        public Optional<Integer> getSelectedFilterId(List<Integer> filter_list) {
            if (filter_list.isEmpty()) {
                return Optional.empty();
            }
            int ret = this.activePage * this.parent.getMaxEntriesPerPage() + this.selectedEntryInPage;
            if (0 <= ret && ret < filter_list.size()) {
                return Optional.of(filter_list.get(ret));
            }
            return Optional.empty();
        }

        protected final void moveSelectedEntryInPage(IntFunction<Integer> mover) {
            int current_page_entries = this.getCurrentPageEntries();
            if (current_page_entries <= 0) {
                return;
            }
            int new_value = mover.apply(this.selectedEntryInPage);
            this.selectedEntryInPage = Mth.m_14045_((int)new_value, (int)0, (int)(current_page_entries - 1));
        }

        protected final void resetSelectedEntryInPage() {
            this.selectedEntryInPage = 0;
        }

        public Optional<Integer> getHoveredIndexInPage(double x, double y) {
            boolean outside_of_area;
            int entry_size = this.getCurrentPageEntries();
            int mX = this.parent.f_96543_ / 2;
            int mY = this.parent.f_96544_ / 2;
            int area_size = this.parent.getSelectAreaSize();
            boolean bl = outside_of_area = Math.abs(x - (double)mX) > (double)(area_size / 2) || Math.abs(y - (double)mY) > (double)(area_size / 2);
            if (outside_of_area) {
                return Optional.empty();
            }
            int baseY = mY - area_size / 2;
            int indx = Mth.m_14107_((double)(y - (double)baseY)) / this.parent.getSpacePerEntry();
            if (indx >= entry_size) {
                return Optional.empty();
            }
            return Optional.of(indx);
        }
    }

    public static class TextField {
        private final StringEntrySelectScreen parent;
        private long blockCharInputMillis = 0L;
        private long prevMillis = 0L;
        private String searchString = "";
        private FocusState focusState = FocusState.NONE;

        private TextField(StringEntrySelectScreen parent) {
            this.parent = parent;
        }

        public String getValue() {
            return this.searchString;
        }

        public void update() {
            if (this.blockCharInputMillis <= 0L) {
                return;
            }
            long passed = System.currentTimeMillis() - this.prevMillis;
            if (passed > 0L) {
                this.blockCharInputMillis -= passed;
                this.prevMillis = System.currentTimeMillis();
            }
        }

        public void render(GuiGraphics graphics) {
            int selected_area_size = this.parent.getSelectAreaSize();
            int half_width = this.parent.f_96543_ / 2;
            int half_height = this.parent.f_96544_ / 2;
            int txtorgx = half_width - selected_area_size / 2 + 10;
            int txtorgy = half_height + selected_area_size / 2 + this.parent.getSearchBarOffset();
            graphics.m_280509_(half_width - selected_area_size / 2, half_height + selected_area_size / 2 + 5, half_width + selected_area_size / 2, half_height + selected_area_size / 2 + 17, Integer.MIN_VALUE);
            if (this.isActive()) {
                graphics.m_280488_(this.parent.f_96547_, this.searchString + "_", txtorgx, txtorgy, -1);
            }
        }

        public void insertText(String x) {
            if (this.searchString.length() < this.parent.getMaxSearchBufferSize()) {
                this.searchString = this.searchString + x;
            }
            this.parent.onTextFieldUpdated();
        }

        public void popCharInText() {
            if (this.searchString.length() <= 0) {
                return;
            }
            this.searchString = this.searchString.substring(0, this.searchString.length() - 1);
            this.parent.onTextFieldUpdated();
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            if (!this.isActive()) {
                return false;
            }
            if (keyCode == 259) {
                this.popCharInText();
                return true;
            }
            return false;
        }

        public boolean charTyped(char code, int p_231042_2_) {
            if (!this.isActive()) {
                return false;
            }
            if (SharedConstants.m_136188_((char)code)) {
                this.insertText(Character.toString(code));
                return true;
            }
            return false;
        }

        public void setBlockCharInputTime(int millis) {
            this.blockCharInputMillis = millis;
            this.prevMillis = System.currentTimeMillis();
        }

        public boolean isActive() {
            return this.focusState == FocusState.FOCUS && this.blockCharInputMillis <= 0L;
        }

        public FocusState focusState() {
            return this.focusState;
        }

        public void setFocusState(FocusState focusState) {
            this.focusState = focusState;
        }

        public static enum FocusState {
            NONE,
            READY,
            FOCUS;

        }
    }
}

