/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.DoggyItems;
import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.WhisltleEditHotKeyData;
import doggytalents.common.network.packet.data.WhistleRequestModeData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class WhistleScreen
extends StringEntrySelectScreen {
    private final List<WhistleItem.WhistleMode> modeList;
    private boolean settingKeysMode = false;
    private int pKey = 0;
    private int[] hotkeysModeArr = new int[]{-1, -1, -1, -1};
    private boolean showModeHelp;
    private boolean dogOnDutyOnly;

    public WhistleScreen() {
        super((Component)Component.m_237115_((String)"doggytalents.screen.whistler.title"));
        this.modeList = Arrays.stream(WhistleItem.WhistleMode.VALUES).collect(Collectors.toList());
        this.updateEntries(this.modeList.stream().map(x -> I18n.m_118938_((String)x.getUnlocalisedTitle(), (Object[])new Object[0])).collect(Collectors.toList()));
    }

    public static void open(ItemStack whistle_stack) {
        Minecraft mc = Minecraft.m_91087_();
        WhistleScreen screen = new WhistleScreen();
        screen.dogOnDutyOnly = WhistleItem.isDogOnDutyOnly(whistle_stack);
        mc.m_91152_((Screen)screen);
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.f_96543_ / 2;
        int mY = this.f_96544_ / 2;
        int pY = mY - 100;
        FlatButton setKey = new FlatButton(mX - 100 - 60 - 2, pY, 60, 20, (Component)Component.m_237115_((String)"doggytalents.screen.whistler.screen.set_hotkey"), b -> {
            if (this.settingKeysMode) {
                this.settingKeysMode = false;
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.screen.set_hotkey"));
            } else {
                this.settingKeysMode = true;
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.screen.use_whistle"));
            }
        }){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_88315_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.screen.set_hotkey").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.whistler.screen.set_hotkey.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.f_96547_));
                graphics.m_280666_(WhistleScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        FlatButton onDuty = new FlatButton(mX - 100 - 60 - 2, pY += setKey.m_93694_() + 2, 60, 20, (Component)(this.dogOnDutyOnly ? Component.m_237115_((String)"doggytalents.screen.whistler.target.on_duty") : Component.m_237115_((String)"doggytalents.screen.whistler.target.all")), b -> {
            if (this.dogOnDutyOnly) {
                this.dogOnDutyOnly = false;
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.target.all"));
            } else {
                this.dogOnDutyOnly = true;
                b.m_93666_((Component)Component.m_237115_((String)"doggytalents.screen.whistler.target.on_duty"));
            }
        }){

            @Override
            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_87963_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                MutableComponent title = Component.m_237115_((String)"doggytalents.screen.whistler.target.title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
                list.add(title);
                String str = I18n.m_118938_((String)"doggytalents.screen.whistler.target.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.f_96547_));
                graphics.m_280666_(WhistleScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, pY += onDuty.m_93694_() + 2, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {}){

            @Override
            public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.m_87963_(graphics, mouseX, mouseY, pTicks);
                if (!this.f_93622_) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.m_237115_((String)"doggytalents.screen.whistler.screen.help_title").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                String str = I18n.m_118938_((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, WhistleScreen.this.f_96547_));
                graphics.m_280666_(WhistleScreen.this.f_96547_, list, mouseX, mouseY);
            }
        };
        this.m_142416_((GuiEventListener)help);
        this.m_142416_((GuiEventListener)setKey);
        this.m_142416_((GuiEventListener)onDuty);
        int pY_right = mY - 100;
        String mode_help_str_id = "doggytalents.screen.whistler.mode_help";
        MutableComponent initial_mode_help_str = this.showModeHelp ? Component.m_237115_((String)mode_help_str_id).m_130948_(Style.f_131099_.m_178520_(this.getHightlightSelectedColor())) : Component.m_237115_((String)mode_help_str_id);
        FlatButton show_whistle_help = new FlatButton(mX + 100 + 2, pY_right, 60, 20, (Component)initial_mode_help_str, b -> {
            boolean bl = this.showModeHelp = !this.showModeHelp;
            if (this.showModeHelp) {
                b.m_93666_((Component)Component.m_237115_((String)mode_help_str_id).m_130948_(Style.f_131099_.m_178520_(this.getHightlightSelectedColor())));
            } else {
                b.m_93666_((Component)Component.m_237115_((String)mode_help_str_id));
            }
        });
        this.m_142416_((GuiEventListener)show_whistle_help);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderModeHelp(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderModeHelp(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showModeHelp) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        WhistleItem.WhistleMode mode = this.modeList.get(entry_id);
        MutableComponent mode_help_c1 = Component.m_237115_((String)mode.getHelpMsg());
        if (this.f_96544_ >= 338) {
            int mX = this.f_96543_ / 2;
            int mY = this.f_96544_ / 2;
            List splited_c1 = this.f_96547_.m_92923_((FormattedText)mode_help_c1, 300);
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            for (FormattedCharSequence str : splited_c1) {
                int uuid_width = this.f_96547_.m_92724_(str);
                int tX = mX - uuid_width / 2;
                graphics.m_280648_(this.f_96547_, str, tX, tY, -1);
                Objects.requireNonNull(this.f_96547_);
                tY += 9 + 2;
            }
        } else {
            MutableComponent mode_name = Component.m_237115_((String)mode.getUnlocalisedTitle()).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)));
            graphics.m_280666_(this.f_96547_, List.of(mode_name, mode_help_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void drawEntry(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        if (this.settingKeysMode) {
            this.drawSetMode(graphics, entry_x, entry_y, entry_id, is_selected);
        } else {
            this.drawNonSetMode(graphics, entry_x, entry_y, entry_id, is_selected);
        }
    }

    private void drawNonSetMode(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        MutableComponent text = Component.m_237115_((String)this.modeList.get(entry_id).getUnlocalisedTitle());
        text.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_178520_(color));
        graphics.m_280430_(this.f_96547_, (Component)text, entry_x, entry_y, color);
    }

    private void drawSetMode(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        MutableComponent text;
        int color = -1;
        if (is_selected) {
            color = this.getHightlightSelectedColor();
        }
        WhistleItem.WhistleMode mode = this.modeList.get(entry_id);
        int hotkey_indx = this.findHotkeyForMode(mode.getIndex());
        int prefix_color = 0xFF6F00;
        if (is_selected) {
            boolean remove = false;
            prefix_color = 720707;
            if (hotkey_indx >= 0) {
                prefix_color = 0xFF3636;
                remove = true;
            }
            text = Component.m_237113_((String)(remove ? "- " : this.pKey + " "));
        } else if (hotkey_indx >= 0) {
            prefix_color = 0xFF6F00;
            text = Component.m_237113_((String)(hotkey_indx + " "));
        } else {
            text = Component.m_237113_((String)"  ");
        }
        text.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(prefix_color));
        MutableComponent title = Component.m_237115_((String)mode.getUnlocalisedTitle());
        title.m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(false)).m_178520_(color));
        text.m_7220_((Component)title);
        graphics.m_280430_(this.f_96547_, (Component)text, entry_x, entry_y, color);
    }

    public void m_86600_() {
        this.updateCurrentHotKeys();
        this.pKey = this.findEmptyHotkey();
    }

    private void updateCurrentHotKeys() {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            this.hotkeysModeArr[i] = -1;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        if (stack == null) {
            return;
        }
        if (stack.m_41720_() != DoggyItems.WHISTLE.get()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return;
        }
        int[] list = tag.m_128465_("hotkey_modes");
        if (list == null) {
            return;
        }
        for (int i = 0; i < this.hotkeysModeArr.length && i < list.length; ++i) {
            this.hotkeysModeArr[i] = list[i];
        }
    }

    private int findEmptyHotkey() {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            if (this.hotkeysModeArr[i] >= 0) continue;
            return i;
        }
        return 3;
    }

    private int findHotkeyForMode(int mode_id) {
        for (int i = 0; i < this.hotkeysModeArr.length; ++i) {
            if (this.hotkeysModeArr[i] != mode_id) continue;
            return i;
        }
        return -1;
    }

    private void sendHotKeyEdits(int hotkey_id, int mode_id) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhisltleEditHotKeyData(hotkey_id, mode_id));
    }

    @Override
    protected void onEntrySelected(int id) {
        this.proccessSelectIndx(id);
    }

    private void proccessSelectIndx(int indx) {
        if (this.settingKeysMode) {
            int new_mode_id = this.modeList.get(indx).getIndex();
            int send_key = this.pKey;
            int occupied_key = this.findHotkeyForMode(new_mode_id);
            if (occupied_key >= 0) {
                new_mode_id = -1;
                send_key = occupied_key;
            }
            this.sendHotKeyEdits(send_key, new_mode_id);
        } else {
            this.requestMode(this.modeList.get(indx).getIndex());
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    private void requestMode(int id) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new WhistleRequestModeData(id, this.dogOnDutyOnly));
    }

    @Override
    public boolean m_7043_() {
        return false;
    }
}

