/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.element;

import doggytalents.client.screen.framework.AbstractSlice;
import doggytalents.client.screen.framework.Store;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.element.ElementSize;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;

public abstract class AbstractElement
implements Renderable,
ContainerEventHandler,
NarratableEntry {
    @Nullable
    private GuiEventListener focused;
    private boolean isDragging;
    @Nullable
    private final AbstractElement parent;
    private final ArrayList<GuiEventListener> child = new ArrayList();
    private final ArrayList<Class<? extends AbstractSlice>> subscribedTo = new ArrayList();
    private final Screen screen;
    private ElementPosition position;
    private ElementSize size;
    private int backgroundColor;

    public AbstractElement(AbstractElement parent, Screen screen) {
        this.parent = this == parent ? null : parent;
        this.position = ElementPosition.getDefault(this);
        this.size = ElementSize.getDefault(this);
        this.screen = screen;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public AbstractElement init() {
        return this;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.child;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backgroundColor != 0) {
            int aX = this.getRealX();
            int aY = this.getRealY();
            graphics.m_280509_(aX, aY, aX + this.getSizeX(), aY + this.getSizeY(), this.backgroundColor);
        }
        this.renderElement(graphics, mouseX, mouseY, partialTicks);
        for (GuiEventListener c : this.child) {
            if (!(c instanceof Renderable)) continue;
            Renderable wid = (Renderable)c;
            wid.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void renderElement(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
    }

    public AbstractElement setPosition(ElementPosition.PosType type, int left, int top) {
        this.position = new ElementPosition(this, left, top, type);
        return this;
    }

    public AbstractElement setSize(int width, int height) {
        this.size = new ElementSize(this, width, height);
        return this;
    }

    public AbstractElement setSize(float ratioX, float ratioY) {
        this.size = new ElementSize(this, ratioX, ratioY);
        return this;
    }

    public AbstractElement setSize(int width, float ratioY) {
        this.size = new ElementSize(this, width, ratioY);
        return this;
    }

    public AbstractElement setSize(float ratioX, int height) {
        this.size = new ElementSize(this, ratioX, height);
        return this;
    }

    public AbstractElement setSize(int size) {
        this.size = new ElementSize(this, size);
        return this;
    }

    public AbstractElement setSizeDynamicX(int sizeY) {
        this.size = ElementSize.createDynamicX(this, sizeY);
        return this;
    }

    public AbstractElement setSizeDynamicY(int sizeX) {
        this.size = ElementSize.createDynamicY(this, sizeX);
        return this;
    }

    public AbstractElement setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public boolean addChildren(GuiEventListener element) {
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (guiEventListener != element) continue;
            return false;
        }
        if (this.checkChildrenExistedInParents(element)) {
            this.child.add(element);
            ElementSize pos = this.getSize();
            if (pos.isDynamic()) {
                pos.updateSize();
            }
            return true;
        }
        return false;
    }

    private boolean checkChildrenExistedInParents(GuiEventListener component) {
        for (AbstractElement p = this.getParent(); p != null; p = p.getParent()) {
            if (p != component) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public AbstractElement getParent() {
        return this.parent;
    }

    public ElementPosition getPosition() {
        return this.position;
    }

    public ElementSize getSize() {
        return this.size;
    }

    public int getRealX() {
        return this.position.getRealX();
    }

    public int getRealY() {
        return this.position.getRealY();
    }

    public int getSizeX() {
        return this.size.getWidth();
    }

    public int getSizeY() {
        return this.size.getHeight();
    }

    public Screen getScreen() {
        return this.screen;
    }

    public boolean m_5953_(double x, double y) {
        return x >= (double)this.getRealX() && y >= (double)this.getRealY() && x < (double)(this.getRealX() + this.getSizeX()) && y < (double)(this.getRealY() + this.getSizeY());
    }

    public void keyPressedRegardlessIfFocus(int keyCode, int scanCode, int modifiers) {
        this.onGlobalKeyPress(keyCode, scanCode, modifiers);
        for (GuiEventListener c : this.child) {
            if (!(c instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)c;
            e.keyPressedRegardlessIfFocus(keyCode, scanCode, modifiers);
        }
    }

    public void KeyReleasedRegardlessIfFocus(int keyCode, int scanCode, int modifiers) {
        this.onGlobalKeyRelease(keyCode, scanCode, modifiers);
        for (GuiEventListener c : this.child) {
            if (!(c instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)c;
            e.KeyReleasedRegardlessIfFocus(keyCode, scanCode, modifiers);
        }
    }

    public void onGlobalKeyPress(int keyCode, int scanCode, int modifiers) {
    }

    public void onGlobalKeyRelease(int keyCode, int scanCode, int modifiers) {
    }

    public boolean needsReRender(List<Class<? extends AbstractSlice>> changedSlices) {
        for (Class<? extends AbstractSlice> slice : changedSlices) {
            if (!this.subscribedTo.contains(slice)) continue;
            return true;
        }
        return false;
    }

    public void onStoreUpdated(List<Class<? extends AbstractSlice>> changedSlices) {
        if (this.needsReRender(changedSlices)) {
            this.reRender();
            return;
        }
        for (GuiEventListener c : this.child) {
            if (!(c instanceof AbstractElement)) continue;
            AbstractElement e = (AbstractElement)c;
            e.onStoreUpdated(changedSlices);
        }
    }

    public void reRender() {
        if (this.child.contains(this.m_7222_())) {
            this.m_7522_(null);
        }
        this.child.clear();
        this.init();
    }

    public <T, S extends AbstractSlice> T getStateAndSubscribesTo(Class<S> slice, Class<T> cast, T defaultState) {
        if (!this.subscribedTo.contains(slice)) {
            this.subscribedTo.add(slice);
        }
        return Store.get(this.getScreen()).getStateOrDefault(slice, cast, defaultState);
    }

    public final boolean m_7282_() {
        return this.isDragging;
    }

    public final void m_7897_(boolean p_94681_) {
        this.isDragging = p_94681_;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.getScreen().m_7222_();
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        this.getScreen().m_7522_(guiEventListener);
    }
}

