/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.framework.element;

import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;

public class ScrollView
extends AbstractElement {
    private static final double SCROLL_SPEED = 10.0;
    private static final int SCROLL_BAR_MARGIN_HORZ = 6;
    private static final int SCROLL_BAR_MARGIN_RIGHT = 4;
    private static final int SCROLL_BAR_THICK = 3;
    private static final int SCROLL_BAR_HANDLE_CLR = -2631209;
    private static final int SCROLL_BAR_REST_CLR = -1864902185;
    long millis0;
    long scrollBarAppearDuration = 0L;
    ScrollContentContainer container;

    public ScrollView(AbstractElement parent, Screen screen) {
        super(parent, screen);
    }

    @Override
    public AbstractElement init() {
        this.container = new ScrollContentContainer(this, this.getScreen());
        this.container.init();
        this.addChildren((GuiEventListener)this.container);
        this.scrollBarAppearDuration = 0L;
        return this;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280588_(this.getRealX(), this.getRealY(), this.getRealX() + this.getSizeX(), this.getRealY() + this.getSizeY());
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        long millis = System.currentTimeMillis();
        long millis_elapsed = millis - this.millis0;
        if (this.scrollBarAppearDuration > 0L && millis_elapsed > 0L) {
            this.scrollBarAppearDuration -= millis_elapsed;
            this.millis0 = millis;
            this.drawScrollBar(graphics, mouseX, mouseY, partialTicks);
        }
        graphics.m_280618_();
    }

    private void shiftWidgetOffsetRescursive(List<? extends GuiEventListener> childrens, int offset) {
        if (offset == 0) {
            return;
        }
        for (GuiEventListener guiEventListener : childrens) {
            if (guiEventListener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                widget.m_253211_(widget.m_252907_() + offset);
                continue;
            }
            if (!(guiEventListener instanceof AbstractElement)) continue;
            AbstractElement element = (AbstractElement)guiEventListener;
            this.shiftWidgetOffsetRescursive(element.m_6702_(), offset);
        }
    }

    private void drawScrollBar(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int fullBarSize = this.getSizeY() - 12;
        int containerSize = this.container.getSizeY();
        if (containerSize <= 0) {
            return;
        }
        if (containerSize <= this.getSizeY()) {
            return;
        }
        float viewportToFullRatio = (float)this.getSizeY() / (float)containerSize;
        int handleSize = Mth.m_14143_((float)(viewportToFullRatio * (float)fullBarSize));
        int maxHandleOffset = fullBarSize - handleSize;
        int handleOffset = Mth.m_14143_((float)(this.getPercentScrolled() * (float)maxHandleOffset));
        int barX = this.getRealX() + this.getSizeX() - 4 - 3;
        int barY = this.getRealY() + 6;
        graphics.m_280509_(barX, barY, barX + 3, barY + fullBarSize, -1864902185);
        int handleX = barX;
        int handleY = barY + handleOffset;
        graphics.m_280509_(handleX, handleY, handleX + 3, handleY + handleSize, -2631209);
    }

    public boolean m_6050_(double x, double y, double dir) {
        this.scrollBarAppearDuration = 1500L;
        this.millis0 = System.currentTimeMillis();
        int offset0 = this.container.getOffset();
        this.container.setOffset(Mth.m_14165_((double)((double)this.container.getOffset() + -dir * 10.0)));
        int maxOff = this.getMaxOffset();
        if (this.container.getOffset() < 0) {
            this.container.setOffset(0);
        } else if (this.container.getOffset() >= maxOff) {
            this.container.setOffset(maxOff);
        }
        int offset1 = this.container.getOffset();
        this.shiftWidgetOffsetRescursive(this.container.m_6702_(), -(offset1 - offset0));
        return super.m_6050_(x, y, dir);
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void addScrollChildren(AbstractElement element) {
        this.container.addChildren((GuiEventListener)element);
    }

    public int getMaxOffset() {
        return Math.max(0, this.container.getSizeY() - this.getSizeY());
    }

    public float getPercentScrolled() {
        int maxOff = this.getMaxOffset();
        if (maxOff <= 0) {
            return 1.0f;
        }
        return (float)this.container.getPosition().getScrollYOffset() / (float)maxOff;
    }

    public AbstractElement getContainer() {
        return this.container;
    }

    public boolean m_6375_(double x, double y, int p_94697_) {
        if (!this.m_5953_(x, y)) {
            return false;
        }
        return super.m_6375_(x, y, p_94697_);
    }

    private static class ScrollContentContainer
    extends AbstractElement {
        public ScrollContentContainer(AbstractElement parent, Screen screen) {
            super(parent, screen);
        }

        @Override
        public AbstractElement init() {
            this.setPosition(ElementPosition.PosType.SCROLL_ABSOLUTE, 0, 0).setSizeDynamicY(this.getParent().getSizeX()).getPosition().setChildDirection(ElementPosition.ChildDirection.COL);
            return this;
        }

        @Override
        public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        }

        public int getOffset() {
            return this.getPosition().getScrollYOffset();
        }

        public void setOffset(int off) {
            this.getPosition().setScrollYOffset(off);
        }
    }
}

