/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyTileEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DogBathBlockEntity
extends BlockEntity {
    public int tickTillProvoke = 10;

    public DogBathBlockEntity(BlockPos pos, BlockState blockState) {
        super(DoggyTileEntityTypes.DOG_BATH.get(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (level == null) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        if (!(blockEntity instanceof DogBathBlockEntity)) {
            return;
        }
        DogBathBlockEntity bath = (DogBathBlockEntity)blockEntity;
        if (--bath.tickTillProvoke > 0) {
            return;
        }
        bath.tickTillProvoke = 10;
        List dogList = level.m_45976_(Dog.class, new AABB(pos).m_82377_(5.0, 3.0, 5.0));
        if (dogList.isEmpty()) {
            return;
        }
        for (Dog dog : dogList) {
            if (dog.isBusy() || !dog.isDoingFine() || dog.m_21827_() || dog.m_21825_() || dog.getAnim() != DogAnimation.NONE || (double)dog.m_217043_().m_188501_() >= 0.02) continue;
            dog.triggerAction(new DogDrinkFromFoodBowl(dog, bath));
            bath.tickTillProvoke += 40 + dog.m_217043_().m_188503_(61);
            break;
        }
    }

    public static class DogDrinkFromFoodBowl
    extends TriggerableAction {
        private final DogBathBlockEntity bath;
        private int tickTillPathRecalc;
        private int goToBowlTimeout = 0;
        private boolean isDoingAnim;
        private int stopTick;
        private int animTick;

        public DogDrinkFromFoodBowl(Dog dog, DogBathBlockEntity bath) {
            super(dog, false, false);
            this.bath = bath;
        }

        @Override
        public void onStart() {
            this.goToBowlTimeout = 200;
            this.isDoingAnim = false;
            this.animTick = 0;
        }

        @Override
        public void tick() {
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.isDoingAnim) {
                if (!this.stillInDrinkDistance()) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
                if (this.dog.getAnim() != DogAnimation.DRINK_WATER) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
                if (this.dog.f_19797_ >= this.stopTick) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            } else {
                boolean dist_can_start_drinking = this.distCanStartDrinking();
                if (!dist_can_start_drinking) {
                    --this.goToBowlTimeout;
                }
                if (this.goToBowlTimeout <= 0 && !dist_can_start_drinking) {
                    this.setState(TriggerableAction.ActionState.FINISHED);
                    return;
                }
            }
            Vec3 bowlPos = this.getBowPos();
            this.dog.m_21563_().m_24950_(bowlPos.f_82479_, bowlPos.f_82480_, bowlPos.f_82481_, 10.0f, (float)this.dog.m_8132_());
            if (this.isDoingAnim) {
                this.doAnim();
            } else {
                this.moveToBowl(this.distCanStartDrinking());
            }
        }

        private void moveToBowl(boolean is_close_to_bowl) {
            if (is_close_to_bowl) {
                this.isDoingAnim = true;
                this.dog.setAnim(DogAnimation.DRINK_WATER);
                this.stopTick = this.dog.f_19797_ + DogAnimation.DRINK_WATER.getLengthTicks();
                this.dog.m_21573_().m_26573_();
                return;
            }
            Vec3 bowlPos = this.getBowPos();
            if (--this.tickTillPathRecalc <= 0) {
                this.tickTillPathRecalc = 10;
                if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                    this.dog.m_21573_().m_26519_(bowlPos.f_82479_, bowlPos.f_82480_, bowlPos.f_82481_, (double)this.dog.getUrgentSpeedModifier());
                }
            }
        }

        private void doAnim() {
            Level level;
            ++this.animTick;
            if (5 <= this.animTick && this.animTick <= 35 && this.animTick % 4 == 0) {
                this.dog.m_5496_(SoundEvents.f_11911_, 0.2f, this.dog.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
            }
            if (this.animTick == 50 && (level = this.dog.m_9236_()) instanceof ServerLevel) {
                ServerLevel sLevel = (ServerLevel)level;
                sLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.dog.m_20185_(), this.dog.m_20186_(), this.dog.m_20189_(), 10, (double)this.dog.m_20205_(), (double)0.8f, (double)this.dog.m_20205_(), 0.1);
            }
            float backward_strafe_dist = 0.6f;
            if (this.getBowlDistanceSqr() < (double)(backward_strafe_dist * backward_strafe_dist)) {
                this.dog.m_21566_().m_24988_(-0.5f, 0.0f);
            }
        }

        @Override
        public void onStop() {
            if (this.dog.getAnim() == DogAnimation.DRINK_WATER) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }

        private boolean stillValidTarget() {
            if (this.bath.m_58901_()) {
                return false;
            }
            return !(this.getBowlDistanceSqr() > 256.0);
        }

        private boolean distCanStartDrinking() {
            double max_dist = (double)(this.dog.m_20205_() / 2.0f) + 0.5;
            return this.getBowlDistanceSqr() <= max_dist * max_dist;
        }

        private boolean stillInDrinkDistance() {
            double max_dist = (double)(this.dog.m_20205_() / 2.0f) + 0.5 + 0.3;
            return this.getBowlDistanceSqr() <= max_dist * max_dist;
        }

        private double getBowlDistanceSqr() {
            Vec3 bowlPos = this.getBowPos();
            return this.dog.m_20238_(bowlPos);
        }

        private Vec3 getBowPos() {
            return Vec3.m_82539_((Vec3i)this.bath.m_58899_());
        }
    }
}

