/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block.tileentity;

import doggytalents.DoggyItems;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.common.block.RiceMillBlock;
import doggytalents.common.inventory.container.RiceMillMenu;
import doggytalents.common.util.InventoryUtil;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;

public class RiceMillBlockEntity
extends BlockEntity {
    public static final int TOTOAL_SLOTS = 3;
    public static final int[] GRAIN_SLOTS = new int[]{0};
    public static final int BOWL_SLOT = 1;
    public static final int[] INPUT_SLOT = new int[]{0, 1};
    public static final int[] OUTPUT_SLOT = new int[]{2};
    private RiceMillContainer container = new RiceMillContainer(this);
    private InvWrapper containerWrapper = new InvWrapper((Container)this.container);
    public static final int TOTOAL_DATA_SLOT = 2;
    public static final int GRINDING_TIME_ID = 0;
    public static final int GRINDING_TINE_FINISH_ID = 1;
    private int grindingTime;
    private int grindingTimeWhenFinish = 50;
    private RiceMillSyncedData syncedData = new RiceMillSyncedData(this);
    private RiceMillMenuProvider menuProvider = new RiceMillMenuProvider(this);
    public static final int GRIND_ANIM_TICK_LEN = 200;
    private int animationTick = 0;
    private boolean isSpinning = false;
    private MillRecipe currentRecipe = MillRecipe.EMPTY;
    private ItemStack prevInputStack = ItemStack.f_41583_;
    private boolean prevHasBowl = false;
    private static final ArrayList<MillRecipe> MILL_RECIPES = new ArrayList();
    private int tickTillUpdateWaterSource = 15;
    private int tickTillUpdateEject = 8;

    public static void initGrindMap() {
        MILL_RECIPES.clear();
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_GRAINS.get(), 3).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_GRAINS.get(), 1).withOutput(DoggyItems.UNCOOKED_RICE.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_WHEAT.get(), 1).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.RICE_WHEAT.get(), 1).withOutput(DoggyItems.UNCOOKED_RICE.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.UNCOOKED_RICE.get(), 3).needsBowl().withOutput(DoggyItems.UNCOOKED_RICE_BOWL.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_BEANS_DRIED.get(), 3).needsBowl().withOutput(DoggyItems.SOY_MILK.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS_DRIED.get(), 1).needsBowl().withOutput(DoggyItems.SOY_MILK.get(), 1).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS.get(), 1).withOutput(DoggyItems.SOY_BEANS.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.SOY_PODS_DRIED.get(), 1).withOutput(DoggyItems.SOY_BEANS_DRIED.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(DoggyItems.EDAMAME.get(), 1).withOutput(DoggyItems.EDAMAME_UNPODDED.get(), 3).build());
        MILL_RECIPES.add(MillRecipe.Builder.withInput(Items.f_42405_, 1).withOutput(Items.f_42406_, 1).build());
    }

    public RiceMillBlockEntity(BlockPos pos, BlockState blockState) {
        super(DoggyTileEntityTypes.RICE_MILL.get(), pos, blockState);
    }

    public static void openContainer(ServerPlayer player, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)mill.menuProvider, (BlockPos)mill.m_58899_());
    }

    public static void tick(Level level, BlockPos pos, BlockState blockState, BlockEntity blockEntity) {
        if (level == null) {
            return;
        }
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        RiceMillBlockEntity.updateSpinning(level, mill);
        RiceMillBlockEntity.updateAnimation(mill);
        RiceMillBlockEntity.grindTick(level, pos, blockState, mill);
        RiceMillBlockEntity.ejectTick(level, mill);
    }

    private static void updateSpinning(Level level, RiceMillBlockEntity mill) {
        if (--mill.tickTillUpdateWaterSource > 0) {
            return;
        }
        mill.tickTillUpdateWaterSource = 15;
        mill.isSpinning = RiceMillBlockEntity.scanIfMillCanSpin(level, mill);
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    private static void updateAnimation(RiceMillBlockEntity mill) {
        if (mill.isSpinning) {
            ++mill.animationTick;
        }
        if (mill.animationTick >= 200) {
            mill.animationTick = 0;
        }
    }

    private static boolean scanIfMillCanSpin(Level level, RiceMillBlockEntity mill) {
        BlockPos pos = mill.m_58899_();
        BlockState state = mill.m_58900_();
        Direction facing = RiceMillBlock.getFacing(state);
        Direction.Axis side_axis = facing.m_122427_().m_122434_();
        for (int i = 0; i < 3; ++i) {
            BlockPos middle_pos;
            BlockState middle_state;
            boolean waterPart = i <= 0;
            if (!RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, middle_state = level.m_8055_(middle_pos = pos.m_7918_(facing.m_122429_(), i - 1, facing.m_122431_())))) {
                return false;
            }
            BlockPos side_pos_1 = null;
            BlockPos side_pos_2 = null;
            if (side_axis == Direction.Axis.X) {
                side_pos_1 = middle_pos.m_7918_(1, 0, 0);
                side_pos_2 = middle_pos.m_7918_(-1, 0, 0);
            } else {
                side_pos_1 = middle_pos.m_7918_(0, 0, 1);
                side_pos_2 = middle_pos.m_7918_(0, 0, -1);
            }
            BlockState side_state_1 = level.m_8055_(side_pos_1);
            if (!RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, side_state_1)) {
                return false;
            }
            BlockState side_state_2 = level.m_8055_(side_pos_2);
            if (RiceMillBlockEntity.isValidBlockForSpiningInPart(waterPart, side_state_2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBlockForSpiningInPart(boolean waterPart, BlockState state) {
        if (waterPart) {
            return state.m_60713_(Blocks.f_49990_);
        }
        return state.m_60795_();
    }

    private static void grindTick(Level level, BlockPos pos, BlockState blockState, RiceMillBlockEntity mill) {
        if (level.f_46443_) {
            return;
        }
        ItemStack inputStack = mill.container.m_8020_(INPUT_SLOT[0]);
        RiceMillBlockEntity.recipeUpdateTick(mill, inputStack);
        MillRecipe currentRecipe = mill.currentRecipe;
        if (RiceMillBlockEntity.isGrinding(mill, inputStack, currentRecipe)) {
            ++mill.grindingTime;
            if (mill.grindingTime >= mill.grindingTimeWhenFinish) {
                RiceMillBlockEntity.createFinishProduct(mill, inputStack, currentRecipe);
                mill.grindingTime = 0;
            }
        } else {
            mill.grindingTime = 0;
        }
    }

    private static void recipeUpdateTick(RiceMillBlockEntity mill, ItemStack currentInputStack) {
        ItemStack bowlStack = mill.container.m_8020_(1);
        boolean hasBowl = bowlStack.m_150930_(Items.f_42399_);
        boolean changed = RiceMillBlockEntity.checkAndDetectChangeInMillInput(mill, currentInputStack, hasBowl);
        if (changed) {
            RiceMillBlockEntity.changeRecipeIfNeeded(mill, currentInputStack, hasBowl);
        }
    }

    private static void changeRecipeIfNeeded(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        if (currentInputStack.m_41619_()) {
            return;
        }
        if (RiceMillBlockEntity.currentRecipeStillMatch(mill, currentInputStack, hasBowl)) {
            return;
        }
        mill.currentRecipe = RiceMillBlockEntity.findMillRecipe(currentInputStack, hasBowl);
    }

    private static boolean currentRecipeStillMatch(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        MillRecipe currentRecipe = mill.currentRecipe;
        if (currentRecipe.empty()) {
            return false;
        }
        boolean isMatch = currentRecipe.matches(currentInputStack, hasBowl);
        return isMatch;
    }

    private static boolean checkAndDetectChangeInMillInput(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        if (!RiceMillBlockEntity.isChanged(mill, currentInputStack, hasBowl)) {
            return false;
        }
        mill.prevHasBowl = hasBowl;
        mill.prevInputStack = currentInputStack.m_41619_() ? ItemStack.f_41583_ : currentInputStack.m_41777_();
        return true;
    }

    private static boolean isChanged(RiceMillBlockEntity mill, ItemStack currentInputStack, boolean hasBowl) {
        if (currentInputStack.m_41619_() && mill.prevInputStack.m_41619_()) {
            return false;
        }
        if (currentInputStack.m_41619_() != mill.prevInputStack.m_41619_()) {
            return true;
        }
        if (currentInputStack.m_41720_() != mill.prevInputStack.m_41720_()) {
            return true;
        }
        if (currentInputStack.m_41613_() != mill.prevInputStack.m_41613_()) {
            return true;
        }
        return mill.prevHasBowl != hasBowl;
    }

    private static MillRecipe findMillRecipe(ItemStack stack, boolean hasBowl) {
        if (stack.m_41619_()) {
            return MillRecipe.EMPTY;
        }
        for (MillRecipe recipe : MILL_RECIPES) {
            if (!recipe.matches(stack, hasBowl)) continue;
            return recipe;
        }
        return MillRecipe.EMPTY;
    }

    private static boolean isGrinding(RiceMillBlockEntity mill, ItemStack inputStack, MillRecipe currentRecipe) {
        if (currentRecipe.empty()) {
            return false;
        }
        return mill.isSpinning && RiceMillBlockEntity.hasEnoughIngredient(mill, inputStack, currentRecipe) && RiceMillBlockEntity.productSlotIsAvailable(mill, currentRecipe);
    }

    private static boolean productSlotIsAvailable(RiceMillBlockEntity mill, MillRecipe recipe) {
        if (recipe.empty()) {
            return false;
        }
        ItemStack currentOutputStack = mill.container.m_8020_(OUTPUT_SLOT[0]);
        if (currentOutputStack.m_41619_()) {
            return true;
        }
        Item outputItemFromInput = recipe.outputItem();
        if (outputItemFromInput == null) {
            return false;
        }
        if (!currentOutputStack.m_150930_(outputItemFromInput)) {
            return false;
        }
        return currentOutputStack.m_41613_() + recipe.outputAmount() <= InventoryUtil.maxStackSizeWithContainer((Container)mill.container, OUTPUT_SLOT[0], currentOutputStack);
    }

    private static boolean hasEnoughIngredient(RiceMillBlockEntity mill, ItemStack inputStack, MillRecipe recipe) {
        if (recipe.empty()) {
            return false;
        }
        ItemStack bowSlotStack = mill.container.m_8020_(1);
        if (recipe.needBowl() && !bowSlotStack.m_150930_(Items.f_42399_)) {
            return false;
        }
        int requireGrainLeft = recipe.inputAmount();
        Item inputItem = inputStack.m_41720_();
        for (int grainSlot : GRAIN_SLOTS) {
            if (requireGrainLeft < 0) break;
            ItemStack grainSlotStack = mill.container.m_8020_(grainSlot);
            if (!grainSlotStack.m_150930_(inputItem)) continue;
            requireGrainLeft -= grainSlotStack.m_41613_();
        }
        return requireGrainLeft <= 0;
    }

    private static void createFinishProduct(RiceMillBlockEntity mill, ItemStack currentInput, MillRecipe currentRecipe) {
        ItemStack resultStack;
        if (!RiceMillBlockEntity.isGrinding(mill, currentInput, currentRecipe)) {
            return;
        }
        Item inputItem = currentInput.m_41720_();
        if (currentRecipe.empty()) {
            return;
        }
        ItemStack bowSlotStack = mill.container.m_8020_(1);
        if (currentRecipe.needBowl() && bowSlotStack.m_150930_(Items.f_42399_)) {
            bowSlotStack = bowSlotStack.m_41777_();
            bowSlotStack.m_41774_(1);
            mill.container.m_6836_(1, bowSlotStack);
        }
        int grainsNeeded = currentRecipe.inputAmount();
        for (int grainSlot : GRAIN_SLOTS) {
            if (grainsNeeded <= 0) break;
            ItemStack grainSlotStack = mill.container.m_8020_(grainSlot);
            if (!grainSlotStack.m_150930_(inputItem)) continue;
            int stackCount = (grainSlotStack = grainSlotStack.m_41777_()).m_41613_();
            if (stackCount <= grainsNeeded) {
                grainsNeeded -= stackCount;
                grainSlotStack = ItemStack.f_41583_;
            } else {
                grainSlotStack.m_41774_(grainsNeeded);
                grainsNeeded = 0;
            }
            mill.container.m_6836_(grainSlot, grainSlotStack);
        }
        if ((resultStack = currentRecipe.produce()) == ItemStack.f_41583_) {
            return;
        }
        mill.containerWrapper.insertItem(OUTPUT_SLOT[0], resultStack, false);
    }

    private boolean isInputMaterialForSlotId(ItemStack stack, int slotId) {
        if (slotId == 1) {
            return stack.m_150930_(Items.f_42399_);
        }
        return RiceMillBlockEntity.isInputSlotValid(stack);
    }

    public static boolean isInputSlotValid(ItemStack stack) {
        return !stack.m_150930_(Items.f_42399_);
    }

    private static void ejectTick(Level level, RiceMillBlockEntity mill) {
        if (level.f_46443_) {
            return;
        }
        if (--mill.tickTillUpdateEject > 0) {
            return;
        }
        mill.tickTillUpdateEject = 8;
        ItemStack output = mill.container.m_8020_(OUTPUT_SLOT[0]);
        if (output.m_41619_()) {
            return;
        }
        Optional<BlockEntity> recipentOptional = RiceMillBlockEntity.getAttachedRecipent(mill);
        if (!recipentOptional.isPresent()) {
            return;
        }
        BlockEntity recipent = recipentOptional.get();
        ItemStack remaining = RiceMillBlockEntity.tryEjectToRecipent(recipent, output);
        if (remaining != output) {
            mill.container.m_6836_(OUTPUT_SLOT[0], remaining);
        }
    }

    private static Optional<BlockEntity> getAttachedRecipent(RiceMillBlockEntity mill) {
        BlockPos pos = mill.m_58899_();
        BlockState state = mill.m_58900_();
        Level level = mill.m_58904_();
        if (level == null) {
            return Optional.empty();
        }
        Direction facing = RiceMillBlock.getFacing(state);
        Direction attached_dir = facing.m_122427_();
        BlockPos attach_pos = pos.m_7918_(attached_dir.m_122429_(), 0, attached_dir.m_122431_());
        BlockEntity attach_blockEntity = level.m_7702_(attach_pos);
        if (attach_blockEntity instanceof FurnaceBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof SmokerBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof ChestBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        if (attach_blockEntity instanceof HopperBlockEntity) {
            return Optional.of(attach_blockEntity);
        }
        return Optional.empty();
    }

    private static ItemStack tryEjectToRecipent(BlockEntity recipent, ItemStack currentStack) {
        if (currentStack.m_41619_()) {
            return currentStack;
        }
        if (recipent instanceof AbstractFurnaceBlockEntity) {
            AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)recipent;
            int furnaceIn = FurnaceBlockEntityDelegate.FURNACE_IN;
            ItemStack current_in = furnace.m_8020_(furnaceIn);
            if (!current_in.m_41619_() && !ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)current_in)) {
                return currentStack;
            }
            if (!current_in.m_41619_() && current_in.m_41613_() >= InventoryUtil.maxStackSizeWithContainer((Container)furnace, furnaceIn, current_in)) {
                return currentStack;
            }
            if (current_in.m_41619_()) {
                current_in = new ItemStack((ItemLike)currentStack.m_41720_());
            } else {
                current_in = current_in.m_41777_();
                current_in.m_41769_(1);
            }
            furnace.m_6836_(furnaceIn, current_in);
            currentStack = currentStack.m_41777_();
            currentStack.m_41774_(1);
            return currentStack;
        }
        if (recipent instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)recipent;
            currentStack = RiceMillBlockEntity.tryInputStackInContainer(currentStack, (Container)chest);
        } else if (recipent instanceof HopperBlockEntity) {
            HopperBlockEntity hopper = (HopperBlockEntity)recipent;
            currentStack = RiceMillBlockEntity.tryInputStackInContainer(currentStack, (Container)hopper);
        }
        return currentStack;
    }

    private static ItemStack tryInputStackInContainer(ItemStack currentStack, Container target) {
        int freeSlot = -1;
        for (int i = 0; i < target.m_6643_(); ++i) {
            ItemStack item = target.m_8020_(i);
            if (item.m_41619_()) {
                freeSlot = i;
                break;
            }
            if (!ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)item) || item.m_41613_() >= InventoryUtil.maxStackSizeWithContainer(target, i, item)) continue;
            freeSlot = i;
            break;
        }
        if (freeSlot < 0) {
            return currentStack;
        }
        ItemStack targetItem = target.m_8020_(freeSlot);
        if (!targetItem.m_41619_() && !ItemStack.m_41656_((ItemStack)currentStack, (ItemStack)targetItem)) {
            return currentStack;
        }
        if (!targetItem.m_41619_() && targetItem.m_41613_() >= InventoryUtil.maxStackSizeWithContainer(target, freeSlot, targetItem)) {
            return currentStack;
        }
        if (targetItem.m_41619_()) {
            targetItem = new ItemStack((ItemLike)currentStack.m_41720_());
        } else {
            targetItem = targetItem.m_41777_();
            targetItem.m_41769_(1);
        }
        target.m_6836_(freeSlot, targetItem);
        currentStack = currentStack.m_41777_();
        currentStack.m_41774_(1);
        return currentStack;
    }

    public WorldlyContainer getWorldlyContainer() {
        return this.container;
    }

    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        AABB aabb = new AABB(pos, pos.m_7918_(1, 1, 1));
        Direction facing = RiceMillBlock.getFacing(state);
        Vec3i facing_norm = facing.m_122436_();
        Vec3 expand_vec = new Vec3((double)facing_norm.m_123341_(), 1.0, (double)facing_norm.m_123343_());
        aabb = aabb.m_82369_(expand_vec);
        Direction.Axis side_axis = facing.m_122427_().m_122434_();
        aabb = side_axis == Direction.Axis.X ? aabb.m_82377_(1.0, 0.0, 0.0) : aabb.m_82377_(0.0, 0.0, 1.0);
        return aabb;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.container.deserializeNBT(tag);
        this.grindingTime = tag.m_128451_("grindingTime");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.container.serializeNBT(tag);
        tag.m_128405_("grindingTime", this.grindingTime);
    }

    public static class MillRecipe {
        public static MillRecipe EMPTY = Builder.empty().build();
        private Item inputItem = null;
        private int inputAmount = 0;
        private boolean needBowl = true;
        private Item outputItem = null;
        private int outputAmount = 1;

        private MillRecipe() {
        }

        public Item inputItem() {
            return this.inputItem;
        }

        public int inputAmount() {
            return this.inputAmount;
        }

        public boolean needBowl() {
            return this.needBowl;
        }

        @Nullable
        public Item outputItem() {
            return this.outputItem;
        }

        public int outputAmount() {
            return this.outputAmount;
        }

        public boolean empty() {
            return this.outputItem == null || this.inputItem == null;
        }

        public boolean matches(ItemStack inputStack, boolean hasBowl) {
            if (this.empty()) {
                return false;
            }
            if (hasBowl != this.needBowl) {
                return false;
            }
            if (inputStack == null) {
                return false;
            }
            if (!inputStack.m_150930_(this.inputItem)) {
                return false;
            }
            return inputStack.m_41613_() >= this.inputAmount;
        }

        public ItemStack produce() {
            if (this.empty()) {
                return ItemStack.f_41583_;
            }
            if (this.outputItem == null) {
                return ItemStack.f_41583_;
            }
            return new ItemStack((ItemLike)this.outputItem, this.outputAmount);
        }

        public static class Builder {
            private Item inputItem = null;
            private int inputAmount = 0;
            private boolean needBowl = false;
            private Item outputItem = null;
            private int outputAmount = 1;

            private Builder() {
            }

            public static Builder empty() {
                return new Builder();
            }

            public static Builder withInput(Item item, int amount) {
                Builder ret = new Builder();
                ret.inputItem = item;
                ret.inputAmount = amount;
                return ret;
            }

            public Builder needsBowl() {
                this.needBowl = true;
                return this;
            }

            public Builder withOutput(Item item, int amount) {
                this.outputAmount = amount;
                this.outputItem = item;
                return this;
            }

            public MillRecipe build() {
                MillRecipe ret = new MillRecipe();
                ret.inputItem = this.inputItem;
                ret.inputAmount = this.inputAmount;
                ret.needBowl = this.needBowl;
                ret.outputItem = this.outputItem;
                ret.outputAmount = this.outputAmount;
                return ret;
            }
        }
    }

    public static class RiceMillContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final RiceMillBlockEntity mill;

        public RiceMillContainer(RiceMillBlockEntity mill) {
            super(3);
            this.mill = mill;
        }

        public int[] m_7071_(Direction dir) {
            if (dir.m_122434_() == Direction.Axis.Y) {
                return new int[0];
            }
            BlockState state = this.mill.m_58900_();
            Direction facing = RiceMillBlock.getFacing(state);
            if (facing.m_122428_() == dir) {
                return INPUT_SLOT;
            }
            return new int[0];
        }

        public boolean m_7155_(int slotId, ItemStack stack, @Nullable Direction dir) {
            if (dir == null) {
                return false;
            }
            if (dir.m_122434_() == Direction.Axis.Y) {
                return false;
            }
            BlockState state = this.mill.m_58900_();
            Direction facing = RiceMillBlock.getFacing(state);
            if (facing.m_122428_() == dir) {
                return this.mill.isInputMaterialForSlotId(stack, slotId);
            }
            return false;
        }

        public boolean m_7157_(int slotId, ItemStack stack, Direction dir) {
            return false;
        }

        public void m_6596_() {
            this.mill.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return Container.m_272074_((BlockEntity)this.mill, (Player)player);
        }

        public void serializeNBT(CompoundTag compound) {
            ListTag itemsList = new ListTag();
            for (int i = 0; i < this.m_6643_(); ++i) {
                ItemStack stack = this.m_8020_(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128344_("Slot", (byte)i);
                stack.m_41739_(itemTag);
                itemsList.add((Object)itemTag);
            }
            compound.m_128365_("MillItems", (Tag)itemsList);
        }

        public void deserializeNBT(CompoundTag compound) {
            if (compound.m_128425_("MillItems", 9)) {
                ListTag tagList = compound.m_128437_("MillItems", 10);
                for (int i = 0; i < tagList.size(); ++i) {
                    CompoundTag itemTag = tagList.m_128728_(i);
                    int slot = itemTag.m_128451_("Slot");
                    if (slot < 0 || slot >= this.m_6643_()) continue;
                    this.m_6836_(slot, ItemStack.m_41712_((CompoundTag)itemTag));
                }
            }
        }
    }

    public static class RiceMillSyncedData
    implements ContainerData {
        private final RiceMillBlockEntity mill;

        public RiceMillSyncedData(RiceMillBlockEntity mill) {
            this.mill = mill;
        }

        public int m_6413_(int syncedSlotId) {
            switch (syncedSlotId) {
                case 0: {
                    return this.mill.grindingTime;
                }
                case 1: {
                    return this.mill.grindingTimeWhenFinish;
                }
            }
            return 0;
        }

        public void m_8050_(int syncedSlotId, int val) {
        }

        public int m_6499_() {
            return 2;
        }
    }

    public static class RiceMillMenuProvider
    implements MenuProvider {
        private final RiceMillBlockEntity mill;

        public RiceMillMenuProvider(RiceMillBlockEntity mill) {
            this.mill = mill;
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int containerId, Inventory inv, Player player) {
            return new RiceMillMenu(containerId, inv, (Container)this.mill.container, this.mill.syncedData);
        }

        public Component m_5446_() {
            return Component.m_237115_((String)"container.doggytalents.rice_mill");
        }
    }

    public static class FurnaceBlockEntityDelegate
    extends AbstractFurnaceBlockEntity {
        public static int FURNACE_IN = 0;

        protected FurnaceBlockEntityDelegate(BlockEntityType<?> p_154991_, BlockPos p_154992_, BlockState p_154993_, RecipeType<? extends AbstractCookingRecipe> p_154994_) {
            super(p_154991_, p_154992_, p_154993_, p_154994_);
        }

        protected Component m_6820_() {
            return Component.m_237119_();
        }

        protected AbstractContainerMenu m_6555_(int p_58627_, Inventory p_58628_) {
            return null;
        }
    }
}

