/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.mojang.datafixers.util.Pair;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.network.packet.ParticlePackets;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BoostingFoodHandler
implements IDogFoodHandler {
    @Override
    public boolean isFood(ItemStack stackIn) {
        return this.isBoostingFood(stackIn);
    }

    @Override
    public boolean canConsume(AbstractDog dogIn, ItemStack stackIn, @Nullable Entity entityIn) {
        return this.isFood(stackIn);
    }

    @Override
    public InteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        if (!dog.m_9236_().f_46443_) {
            Item item = stack.m_41720_();
            FoodProperties props = item.m_41473_();
            if (props == null) {
                return InteractionResult.FAIL;
            }
            int heal = props.m_38744_() * 5;
            dog.addHunger(heal);
            dog.consumeItemFromStack(entityIn, stack);
            for (Pair pair : props.m_38749_()) {
                if (pair.getFirst() == null || !(dog.m_217043_().m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                dog.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
            if (dog.m_9236_() instanceof ServerLevel) {
                ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)item));
            }
            dog.m_5496_(SoundEvents.f_11912_, dog.m_6121_(), (dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isBoostingFood(ItemStack stack) {
        Item item = stack.m_41720_();
        return item == Items.f_42436_ || item == Items.f_42410_ || item == Items.f_42437_ || item == Items.f_42677_;
    }
}

