/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.Team;

public class DogAllyCheck {
    public static boolean isAlliedToDog(Dog dog, Entity entity) {
        return DogAllyCheck.isAlliedToDog(dog, entity, dog.m_269323_());
    }

    public static boolean isAlliedToDog(Dog dog, Entity entity, @Nullable LivingEntity owner) {
        boolean ally_check;
        if (dog == null || entity == null) {
            return false;
        }
        if (entity == dog) {
            return true;
        }
        UUID owner_uuid = dog.m_21805_();
        if (owner_uuid == null) {
            return false;
        }
        boolean bl = ally_check = owner != null ? DogAllyCheck.checkOwnerAvailable(dog, entity, owner_uuid, owner) : DogAllyCheck.checkOwnerNotAvailable(dog, entity, owner_uuid);
        if (ally_check) {
            return true;
        }
        boolean all_player_ally_to_dog = DogAllyCheck.checkAllPlayerCannotHitDog(dog, entity);
        return all_player_ally_to_dog;
    }

    private static boolean checkOwnerAvailable(Dog dog, Entity entity, UUID owner_uuid, LivingEntity owner) {
        if (entity == owner) {
            return true;
        }
        if (owner.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal other_dog = (TamableAnimal)entity;
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            LivingEntity owner_other = other_dog.m_269323_();
            if (owner_other != null) {
                return owner.m_7307_((Entity)owner_other);
            }
            if (entity instanceof Dog) {
                Dog other_dog_actual = (Dog)entity;
                return DogAllyCheck.checkSameTeamWithOfflineOwner(other_dog_actual, (Entity)owner);
            }
            return false;
        }
        return false;
    }

    private static boolean checkOwnerNotAvailable(Dog dog, Entity entity, UUID owner_uuid) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal other_dog = (TamableAnimal)entity;
            if (DogAllyCheck.checkSameOwnerUUIDWithDog(owner_uuid, other_dog)) {
                return true;
            }
            LivingEntity owner_other = other_dog.m_269323_();
            return owner_other != null && DogAllyCheck.checkSameTeamWithOfflineOwner(dog, (Entity)owner_other);
        }
        return DogAllyCheck.checkSameTeamWithOfflineOwner(dog, entity);
    }

    private static boolean checkSameTeamWithOfflineOwner(Dog dog, Entity entity) {
        Optional<Component> owner_name_optional = dog.getOwnersName();
        if (!owner_name_optional.isPresent()) {
            return false;
        }
        String owner_name = owner_name_optional.get().getString();
        if (owner_name == null || owner_name.isEmpty()) {
            return false;
        }
        Team team = entity.m_5647_();
        if (team == null) {
            return false;
        }
        return team.m_6809_().contains(owner_name);
    }

    private static boolean checkSameOwnerUUIDWithDog(UUID dog_owner_uuid, TamableAnimal entity) {
        UUID other_owner_uuid = entity.m_21805_();
        if (other_owner_uuid == null) {
            return false;
        }
        return dog_owner_uuid.equals(other_owner_uuid);
    }

    private static boolean checkAllPlayerCannotHitDog(Dog dog, Entity entity) {
        if (!((Boolean)ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG.get()).booleanValue()) {
            return false;
        }
        if (entity instanceof Player) {
            return true;
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal other_dog = (TamableAnimal)entity;
            return other_dog.m_21805_() != null;
        }
        return false;
    }
}

