/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalents;
import doggytalents.api.feature.DogSize;
import doggytalents.client.DTNClientDogSleepOnManager;
import doggytalents.common.entity.Dog;
import doggytalents.common.talent.BedDogTalent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;

public class DogSleepOnManager {
    private static final DogSleepOnManager SERVER_INSTANCE = new DogSleepOnManager();
    private final Map<UUID, SleepOnPair> sleepingOnPairs = Maps.newHashMap();
    private final List<SleepOnPair> toRemove = new ArrayList<SleepOnPair>();

    private DogSleepOnManager() {
    }

    public static DogSleepOnManager getServer(Level level) {
        if (level.f_46443_) {
            throw new IllegalStateException("Only access this class's instance from the Logical Server.");
        }
        return SERVER_INSTANCE;
    }

    public static DogSleepOnManager getServer(MinecraftServer server) {
        if (server == null) {
            throw new IllegalStateException("Only access this class's instance from the Logical Server.");
        }
        return SERVER_INSTANCE;
    }

    public StartSleepOnDogResult setOrRequestSleepOn(Dog dog, Player player) {
        StartSleepOnDogResult sleep_condition = this.isSleepCondition(dog);
        if (!sleep_condition.ok()) {
            return sleep_condition;
        }
        if (dog.sleepOnManager.isSleepOnReady()) {
            return this.setPlayerSleepOn(dog, player);
        }
        dog.sleepOnManager.setRequestedSleepOn(true);
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult setPlayerSleepOn(Dog dog, Player player) {
        StartSleepOnDogResult can_start = this.canPlayerStartSleepOnDog(dog, player);
        if (!can_start.ok()) {
            return can_start;
        }
        Optional<Pair<Float, Vec3>> sleep_pair_optional = this.findSleepRot(dog, player);
        if (!sleep_pair_optional.isPresent()) {
            return DogSleepOnFailMessage.NO_POS.asResult();
        }
        Pair<Float, Vec3> sleep_pair = sleep_pair_optional.get();
        float sleep_yrot = ((Float)sleep_pair.getLeft()).floatValue();
        player.m_5802_(dog.m_20183_());
        player.m_20219_((Vec3)sleep_pair.getRight());
        this.rotateDogPerpenToSleepYRot(dog, sleep_yrot);
        DogSleepOnManager.rotatePlayerYRotToDog(dog, player, sleep_yrot);
        dog.setSleepOnState(new DogSleepOnState(player.m_20148_(), true, sleep_yrot));
        this.addDogSleepOnPair(player, dog);
        ((ServerLevel)player.m_9236_()).m_8878_();
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult canPlayerStartSleepOnDog(Dog dog, Player player) {
        StartSleepOnDogResult sleep_condition = this.isSleepCondition(dog);
        if (!sleep_condition.ok()) {
            return sleep_condition;
        }
        if (!dog.sleepOnManager.sleepOnReady) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        return StartSleepOnDogResult.OK;
    }

    public StartSleepOnDogResult isSleepCondition(Dog dog) {
        if (!dog.isDoingFine()) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        ServerLevel level = (ServerLevel)dog.m_9236_();
        if (level.m_46461_()) {
            return DogSleepOnFailMessage.NOT_SLEEP_TIME.asResult();
        }
        if (!level.m_143333_()) {
            return DogSleepOnFailMessage.CANT_SLEEP_THROUGH_NIGHT.asResult();
        }
        if (!dog.getDogSize().largerOrEquals(DogSize.MODERATO)) {
            return DogSleepOnFailMessage.TOO_SMOL.asResult();
        }
        if (dog.getDogSize().largerOrEquals(DogSize.FORTE)) {
            return DogSleepOnFailMessage.TOO_BIG.asResult();
        }
        Optional<BedDogTalent> inst = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst.isPresent()) {
            return DogSleepOnFailMessage.OTHER.asResult();
        }
        StartSleepOnDogResult inst_result = BedDogTalent.isSleepCondition(dog, inst.get());
        if (!inst_result.ok()) {
            return inst_result;
        }
        return StartSleepOnDogResult.OK;
    }

    private Optional<Pair<Float, Vec3>> findSleepRot(Dog dog, Player player) {
        float check_yrot1 = player.m_146908_() + 180.0f;
        Vec3 check_pos1 = this.getPlayerSleepPos(dog, check_yrot1);
        if (this.checkIfSleepPosIsEligible(dog, check_pos1)) {
            return Optional.of(Pair.of((Object)Float.valueOf(check_yrot1), (Object)check_pos1));
        }
        float dog_yrot = dog.m_146908_();
        for (int i = 0; i < 8; ++i) {
            float check_yrot = dog_yrot + (float)i * 45.0f;
            Vec3 check_pos = this.getPlayerSleepPos(dog, check_yrot);
            if (!this.checkIfSleepPosIsEligible(dog, check_pos)) continue;
            return Optional.of(Pair.of((Object)Float.valueOf(check_yrot), (Object)check_pos));
        }
        return Optional.empty();
    }

    private boolean checkIfSleepPosIsEligible(Dog dog, Vec3 check_pos) {
        Iterable air_iterater = BlockPos.m_121940_((BlockPos)BlockPos.m_274446_((Position)check_pos.m_82520_(-1.0, 0.0, -1.0)), (BlockPos)BlockPos.m_274446_((Position)check_pos.m_82520_(1.0, 0.0, 1.0)));
        for (BlockPos pos : air_iterater) {
            BlockState state = dog.m_9236_().m_8055_(pos);
            if (state.m_60795_()) continue;
            return false;
        }
        Iterable solid_iterater = BlockPos.m_121940_((BlockPos)BlockPos.m_274446_((Position)check_pos.m_82520_(-1.0, -1.0, -1.0)), (BlockPos)BlockPos.m_274446_((Position)check_pos.m_82520_(1.0, -1.0, 1.0)));
        for (BlockPos pos : solid_iterater) {
            BlockState state = dog.m_9236_().m_8055_(pos);
            if (state.m_60838_((BlockGetter)dog.m_9236_(), pos)) continue;
            return false;
        }
        return true;
    }

    private Vec3 getPlayerSleepPos(Dog dog, float dog_sleep_rot) {
        Vec3 sleep_on_pos = this.getSleepOnHeadPos(dog, dog_sleep_rot);
        Vec3 dog_view_vec = dog.calcDogViewVec(0.0f, dog_sleep_rot);
        double distance_to_dog = 0.3;
        return new Vec3(dog_view_vec.f_82479_, 0.0, dog_view_vec.f_82481_).m_82541_().m_82490_(0.3).m_82549_(sleep_on_pos);
    }

    private Vec3 getSleepOnHeadPos(Dog dog, float dog_sleep_rot) {
        float side_translate = -0.3f;
        float translate_rot = dog_sleep_rot + 90.0f;
        Vec3 translate_vec = dog.calcDogViewVec(0.0f, translate_rot).m_82490_((double)-0.3f);
        return dog.m_20182_().m_82549_(translate_vec);
    }

    private void rotateDogPerpenToSleepYRot(Dog dog, float dog_sleep_yrot) {
        float rotate_yrot = Mth.m_14177_((float)(dog_sleep_yrot + 90.0f));
        dog.m_146922_(rotate_yrot);
        dog.f_20885_ = dog.f_20883_ = dog.m_146908_();
    }

    public Optional<Dog> getSleepingOnDog(LivingEntity entity) {
        if (this.sleepingOnPairs.isEmpty()) {
            return Optional.empty();
        }
        if (!(entity instanceof Player)) {
            return Optional.empty();
        }
        Player player = (Player)entity;
        return Optional.ofNullable(this.sleepingOnPairs.get(player.m_20148_()).dog());
    }

    public void stopPlayerSleepOn(Dog dog) {
        dog.setSleepOnState(DogSleepOnState.NULL);
        this.clearPlayerSleepOnFor(dog);
    }

    public static void tickServer(MinecraftServer server) {
        DogSleepOnManager.getServer(server).invalidateSleepers();
    }

    public static void onServerStop(MinecraftServer server) {
        DogSleepOnManager.getServer((MinecraftServer)server).sleepingOnPairs.clear();
    }

    private void invalidateSleepers() {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        for (Map.Entry<UUID, SleepOnPair> entry : this.sleepingOnPairs.entrySet()) {
            SleepOnPair pair = entry.getValue();
            if (this.stillValidSleepingPair(pair.dog(), pair.player())) continue;
            this.toRemove.add(pair);
        }
        if (this.toRemove.isEmpty()) {
            return;
        }
        for (SleepOnPair x : this.toRemove) {
            this.stopPlayerSleepOn(x.dog());
        }
        this.toRemove.clear();
    }

    private boolean stillValidSleepingPair(Dog dog, Player player) {
        if (!player.m_6084_() || !dog.m_6084_()) {
            return false;
        }
        if (!player.m_5803_()) {
            return false;
        }
        DogSleepOnState dog_sleeping_state = dog.getSleepOnState();
        if (!dog_sleeping_state.is_sleeping()) {
            return false;
        }
        if (!this.isSleepCondition(dog).ok()) {
            return false;
        }
        Vec3 sleep_pos = this.getPlayerSleepPos(dog, dog_sleeping_state.sleep_yrot());
        return !(player.m_20238_(sleep_pos) > 0.010000000000000002);
    }

    private void addDogSleepOnPair(Player player, Dog dog) {
        UUID uuid = player.m_20148_();
        if (uuid == null) {
            return;
        }
        this.sleepingOnPairs.put(uuid, new SleepOnPair(dog, player));
    }

    private void removeSleepingOnDogToMap(UUID sleeper_id) {
        this.sleepingOnPairs.remove(sleeper_id);
    }

    private void clearPlayerSleepOnFor(Dog dog) {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        ArrayList<UUID> toRemove = new ArrayList<UUID>();
        for (Map.Entry<UUID, SleepOnPair> entry : this.sleepingOnPairs.entrySet()) {
            if (entry.getValue().dog() != dog) continue;
            toRemove.add(entry.getKey());
        }
        for (UUID key : toRemove) {
            this.removeSleepingOnDogToMap(key);
        }
    }

    private void checkAndClearWhenPlayerWakeUp(Player player) {
        if (this.sleepingOnPairs.isEmpty()) {
            return;
        }
        SleepOnPair pair = this.sleepingOnPairs.get(player.m_20148_());
        if (pair == null) {
            return;
        }
        this.stopPlayerSleepOn(pair.dog());
    }

    private void notifySleepSuccesAllDogAndStopSleeping(ServerLevel level) {
        this.invalidateSleepers();
        for (Map.Entry<UUID, SleepOnPair> x : this.sleepingOnPairs.entrySet()) {
            SleepOnPair pair = x.getValue();
            Dog dog = pair.dog();
            if (!this.stillValidSleepingPair(dog, pair.player()) || dog.m_9236_() != level) continue;
            this.notifySleepSuccessDog(dog);
        }
    }

    private void notifySleepSuccessDog(Dog dog) {
        Optional<BedDogTalent> inst = dog.getTalent(DoggyTalents.BED_DOG.get(), BedDogTalent.class);
        if (!inst.isPresent()) {
            return;
        }
        inst.get().onSuccessfulSleep(dog);
    }

    public static void canPlayerContinueSleeping(SleepingLocationCheckEvent event) {
        LivingEntity player = event.getEntity();
        Optional<Dog> dog_optional = DogSleepOnManager.getServer(player.m_20194_()).getSleepingOnDog(player);
        if (!dog_optional.isPresent()) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
    }

    public static void beforeSleepFinishedForAllPlayer(SleepFinishedTimeEvent event) {
        ServerLevel level = (ServerLevel)event.getLevel();
        DogSleepOnManager.getServer((Level)level).notifySleepSuccesAllDogAndStopSleeping(level);
    }

    public static void onPlayerWakeUp(Player player) {
        ServerLevel level = (ServerLevel)player.m_9236_();
        DogSleepOnManager.getServer((Level)level).checkAndClearWhenPlayerWakeUp(player);
    }

    public static void onDogSleepOnDataUpdated(Dog dog, DogSleepOnState state) {
        if (dog.m_9236_().f_46443_) {
            DTNClientDogSleepOnManager.get().onDogSleepOnDataUpdated(dog, state);
        }
    }

    public static void onSleepGoalStop(Dog dog) {
        dog.sleepOnManager.onSleepOnGoalStop();
        DogSleepOnManager.getServer(dog.m_9236_()).stopPlayerSleepOn(dog);
    }

    public static void onHurt(Dog dog) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (!dog.getSleepOnState().is_sleeping()) {
            return;
        }
        DogSleepOnManager.getServer(dog.m_9236_()).stopPlayerSleepOn(dog);
    }

    public static boolean shouldBlockPush(Dog dog) {
        return dog.getSleepOnState().is_sleeping();
    }

    public static void rotatePlayerYRotToDog(Dog dog, Player player, float dog_sleep_yrot) {
        float rotate_yrot = Mth.m_14177_((float)(dog_sleep_yrot - 180.0f));
        player.m_146922_(rotate_yrot);
        player.f_20885_ = player.f_20883_ = player.m_146908_();
    }

    public static Optional<Player> getSleeperFromDog(Dog dog) {
        DogSleepOnState state = dog.getSleepOnState();
        return DogSleepOnManager.getSleeperFromDog(dog, state);
    }

    public static Optional<Player> getSleeperFromDog(Dog dog, DogSleepOnState state) {
        Player sleeper = dog.m_9236_().m_46003_(state.sleeper());
        return Optional.ofNullable(sleeper);
    }

    public static class StartSleepOnDogResult {
        public static StartSleepOnDogResult OK = new StartSleepOnDogResult(Optional.empty());
        private Optional<DogSleepOnFailMessage> failMsg = Optional.empty();

        public StartSleepOnDogResult(Optional<DogSleepOnFailMessage> failMsg) {
            this.failMsg = failMsg;
        }

        public boolean ok() {
            return !this.failMsg.isPresent();
        }

        public boolean other() {
            return this.isFailMsg(DogSleepOnFailMessage.OTHER);
        }

        public DogSleepOnFailMessage failMsg() {
            return this.failMsg.orElse(null);
        }

        public boolean isFailMsg(DogSleepOnFailMessage msg) {
            return this.failMsg.isPresent() && this.failMsg.get() == msg;
        }
    }

    public static class PerDog {
        private final Dog dog;
        private boolean sleepOnRequested = false;
        private boolean sleepOnReady = false;
        private int requestTimeout = 0;

        public PerDog(Dog dog) {
            this.dog = dog;
        }

        public void tick() {
            if (!this.dog.m_9236_().f_46443_) {
                this.invalidateRequest();
            }
        }

        public void setSleepOnReady(boolean val) {
            this.sleepOnReady = val;
        }

        public boolean isSleepOnReady() {
            return this.sleepOnReady;
        }

        private void invalidateRequest() {
            if (!this.sleepOnRequested) {
                return;
            }
            if (this.requestTimeout > 0) {
                --this.requestTimeout;
            }
            if (this.requestTimeout <= 0) {
                this.sleepOnRequested = false;
            }
        }

        public void setRequestedSleepOn(boolean val) {
            this.sleepOnRequested = val;
            this.requestTimeout = 20;
        }

        public boolean isSleepOnRequested() {
            return this.sleepOnRequested;
        }

        public void onSleepOnGoalStop() {
            this.sleepOnRequested = false;
            this.sleepOnReady = false;
        }
    }

    public static enum DogSleepOnFailMessage {
        NOT_SLEEP_TIME("not_sleep_time", (dog, locId) -> Component.m_237110_((String)locId, (Object[])new Object[]{dog.m_7755_().getString()})),
        OTHER("other", (dog, locId) -> Component.m_237115_((String)locId)),
        CANT_SLEEP_THROUGH_NIGHT("cant_sleep_thru_night", (dog, locId) -> Component.m_237115_((String)locId)),
        DOG_LOW_HUNGER("low_hunger", (dog, locId) -> Component.m_237110_((String)locId, (Object[])new Object[]{dog.m_7755_().getString(), dog.getGenderSubject()})),
        COOLDOWN("cooldown", (dog, locId) -> Component.m_237119_()),
        NO_POS("no_pos", (dog, locId) -> Component.m_237110_((String)locId, (Object[])new Object[]{dog.m_7755_().getString(), dog.getGenderSubject()})),
        TOO_SMOL("to_smol", (dog, locId) -> Component.m_237110_((String)locId, (Object[])new Object[]{dog.m_7755_().getString(), dog.getGenderSubject()})),
        TOO_BIG("to_big", (dog, locId) -> Component.m_237110_((String)locId, (Object[])new Object[]{dog.m_7755_().getString(), dog.getGenderSubject()}));

        private final String locId;
        private final BiFunction<Dog, String, Component> msgGetter;

        private DogSleepOnFailMessage(String locId, BiFunction<Dog, String, Component> msgGetter) {
            this.locId = "talent.doggytalents.bed_dog.fail." + locId;
            this.msgGetter = msgGetter;
        }

        public Component getMsg(Dog dog) {
            return this.msgGetter.apply(dog, this.locId);
        }

        public StartSleepOnDogResult asResult() {
            return new StartSleepOnDogResult(Optional.of(this));
        }
    }

    public record DogSleepOnState(UUID sleeper, boolean is_sleeping, float sleep_yrot) {
        public static DogSleepOnState NULL = new DogSleepOnState(Util.f_137441_, false, 0.0f);
    }

    private record SleepOnPair(Dog dog, Player player) {
    }
}

