/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.accessory;

import com.google.common.collect.Maps;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.render.AccessoryModelManager;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.AccessoryModelRenderEntries;
import doggytalents.client.entity.render.layer.accessory.modelrenderentry.IAccessoryHasModel;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogPose;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class FieryReflector
extends Accessory
implements IAccessoryHasModel {
    private final Type type;

    public FieryReflector(Supplier<? extends ItemLike> itemIn, Type type) {
        super(DoggyAccessoryTypes.WINGS, itemIn);
        this.setAccessoryRenderType(Accessory.AccessoryRenderType.MODEL);
        this.type = type;
    }

    public FieryReflector(Supplier<? extends ItemLike> itemIn) {
        super(DoggyAccessoryTypes.WINGS, itemIn);
        this.setAccessoryRenderType(Accessory.AccessoryRenderType.MODEL);
        this.type = Type.DIVINE_RETRIBUTION;
    }

    @Override
    public AccessoryModelManager.Entry getRenderEntry() {
        return AccessoryModelRenderEntries.FIERY_REFL;
    }

    @Override
    public AccessoryInstance getDefault() {
        return new Inst(this, this.type);
    }

    public static enum Type {
        DIVINE_RETRIBUTION,
        SOUL_REFLECTOR;

    }

    public static class Inst
    extends AccessoryInstance
    implements IDogAlteration {
        public static final int MAX_COOKED = 10;
        public static final int COOK_RADIUS = 1;
        private final Map<ItemEntity, Integer> cooking = Maps.newHashMap();
        private int tickTillRefresh = 0;
        private final Type type;
        private final ArrayList<Pair<Item, ResourceLocation>> recipeCache = new ArrayList(5);
        public boolean debugForceLowFlameRender = false;

        public Inst(Accessory typeIn, Type type) {
            super(typeIn);
            this.type = type;
        }

        @Override
        public void tick(AbstractDog dogIn) {
            this.invalidateCache();
            this.invalidateCooking(dogIn);
            this.tickReflectorEffect(dogIn);
            this.tickDoingCooking(dogIn);
        }

        @Override
        public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
            Dog dog;
            if (dogIn.m_9236_().f_46443_ && playerIn.m_21120_(handIn).m_41720_() == Items.f_42401_ && dogIn instanceof Dog && (dog = (Dog)dogIn).isDogInAnimDebug()) {
                this.debugForceLowFlameRender = !this.debugForceLowFlameRender;
            }
            return InteractionResult.PASS;
        }

        private void tickReflectorEffect(AbstractDog dogIn) {
            if (dogIn.isDefeated()) {
                return;
            }
            if (dogIn.m_9236_().f_46443_) {
                if (dogIn instanceof Dog) {
                    Dog dog = (Dog)dogIn;
                    this.addFlameParticles(dog);
                }
                this.playSizzleSound(dogIn);
            }
        }

        private void tickDoingCooking(AbstractDog dog) {
            if (dog.isDefeated()) {
                return;
            }
            if (--this.tickTillRefresh <= 0) {
                this.tickTillRefresh = 10;
                this.populateCooking(dog);
            }
            this.cookAllCooking(dog);
        }

        private void addFlameParticles(Dog dog) {
            boolean higher_flame;
            float offsetY = 0.24f;
            DogPose pose = dog.getDogPose();
            boolean bl = higher_flame = !(pose != DogPose.STAND && pose != DogPose.FLYING || this.debugForceLowFlameRender && dog.isDogInAnimDebug());
            if (higher_flame) {
                offsetY += dog.getDogVisualBbHeight();
            }
            float a1 = dog.getClientAnimatedYBodyRotInRadians();
            float dx1 = -Mth.m_14031_((float)a1);
            float dz1 = Mth.m_14089_((float)a1);
            float f1 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            float f2 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * dog.getDogVisualBbWidth() * 0.5f;
            SimpleParticleType flame_particle = this.type == Type.SOUL_REFLECTOR ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_;
            dog.m_9236_().m_7106_((ParticleOptions)flame_particle, dog.m_20185_() + (double)f1 - (double)dx1 * ((double)dog.getDogVisualBbWidth() * 1.8), dog.m_20186_() + (double)offsetY, dog.m_20189_() + (double)f2 - (double)dz1 * ((double)dog.getDogVisualBbWidth() * 1.8), (double)(-dx1) * 0.05, -0.01, (double)(-dz1) * 0.05);
        }

        private void playSizzleSound(AbstractDog dog) {
            RandomSource r = dog.m_217043_();
            if (r.m_188503_(24) == 0) {
                dog.m_9236_().m_7785_(dog.m_20185_(), dog.m_20186_() + (double)dog.m_20206_() + 0.24, dog.m_20189_(), SoundEvents.f_11936_, SoundSource.AMBIENT, 0.6f * r.m_188501_(), r.m_188501_() * 0.7f + 0.3f, false);
            }
        }

        private void populateCooking(AbstractDog dog) {
            if (this.cooking.size() >= 10) {
                return;
            }
            List<ItemEntity> checkingItems = this.getRandomNearbyItemEntities(dog);
            for (ItemEntity e : checkingItems) {
                ItemStack item;
                SmeltingRecipe recipe;
                if (this.cooking.size() >= 10) break;
                if (this.cooking.containsKey(e) || (recipe = this.getCookedRecipe(dog, item = e.m_32055_())) == null) continue;
                this.cooking.put(e, recipe.m_43753_());
            }
        }

        private void invalidateCooking(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            if (dog.isDefeated()) {
                this.cooking.clear();
                return;
            }
            ArrayList<ItemEntity> removeList = new ArrayList<ItemEntity>();
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                if (this.stillValidCooking(dog, entry.getKey())) continue;
                removeList.add(entry.getKey());
            }
            for (ItemEntity e : removeList) {
                this.cooking.remove(e);
            }
        }

        private void cookAllCooking(AbstractDog dog) {
            if (dog.m_9236_().f_46443_) {
                this.cookAllCookingClient(dog);
            } else {
                this.cookAllCookingServer(dog);
            }
        }

        private void cookAllCookingServer(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            ArrayList<ItemEntity> finished = new ArrayList<ItemEntity>();
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                entry.setValue(entry.getValue() - 1);
                if (entry.getValue() > 0) continue;
                this.finishCooking(dog, entry.getKey());
                finished.add(entry.getKey());
            }
            for (ItemEntity e : finished) {
                this.cooking.remove(e);
            }
        }

        private void cookAllCookingClient(AbstractDog dog) {
            if (this.cooking.isEmpty()) {
                return;
            }
            if (dog.m_217043_().m_188500_() < 0.1) {
                dog.m_9236_().m_7785_(dog.m_20185_(), dog.m_20186_(), dog.m_20189_(), SoundEvents.f_11907_, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            for (Map.Entry<ItemEntity, Integer> entry : this.cooking.entrySet()) {
                ItemEntity e = entry.getKey();
                if (dog.m_217043_().m_188503_(3) != 0) continue;
                float f1 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * e.m_20205_() * 0.5f;
                float f2 = (dog.m_217043_().m_188501_() * 2.0f - 1.0f) * e.m_20205_() * 0.5f;
                dog.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, e.m_20185_() + (double)f1, e.m_20186_(), e.m_20189_() + (double)f2, 0.0, 0.05, 0.0);
            }
        }

        private void finishCooking(AbstractDog dog, ItemEntity e) {
            ItemStack uncookedItem = e.m_32055_().m_41777_();
            SmeltingRecipe recipe = this.getCookedRecipe(dog, uncookedItem);
            if (recipe == null) {
                return;
            }
            ItemStack cookedItem = recipe.m_8043_(dog.m_9236_().m_9598_()).m_41777_();
            ItemEntity cookedItemEntity = new ItemEntity(dog.m_9236_(), e.m_20185_(), e.m_20186_(), e.m_20189_(), cookedItem);
            cookedItemEntity.m_32060_();
            dog.m_9236_().m_7967_((Entity)cookedItemEntity);
            uncookedItem.m_41774_(1);
            if (uncookedItem.m_41619_()) {
                e.m_146870_();
            } else {
                e.m_32045_(uncookedItem);
            }
        }

        private boolean stillValidCooking(AbstractDog dog, ItemEntity e) {
            double maxDist = (double)(dog.m_20205_() / 2.0f + 1.0f) + 0.5;
            return e.m_6084_() && e.m_20280_((Entity)dog) <= maxDist * maxDist;
        }

        private SmeltingRecipe getCookedRecipe(AbstractDog dog, ItemStack stack) {
            if (stack.m_41619_()) {
                return null;
            }
            Item item = stack.m_41720_();
            ResourceLocation firstCheck = this.getCachedRecipeLoc(item);
            Optional pairOptional = dog.m_9236_().m_7465_().m_220248_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), dog.m_9236_(), firstCheck);
            if (!pairOptional.isPresent()) {
                return null;
            }
            com.mojang.datafixers.util.Pair pair = (com.mojang.datafixers.util.Pair)pairOptional.get();
            ResourceLocation res = (ResourceLocation)pair.getFirst();
            SmeltingRecipe recipe = (SmeltingRecipe)pair.getSecond();
            if (res == null || recipe == null) {
                return null;
            }
            this.cacheResult(item, res);
            return recipe;
        }

        private List<ItemEntity> getRandomNearbyItemEntities(AbstractDog dog) {
            int amount = 10;
            List cookingItems = dog.m_9236_().m_45976_(ItemEntity.class, dog.m_20191_().m_82400_(1.0));
            if (cookingItems.size() <= 10) {
                return cookingItems;
            }
            Collections.shuffle(cookingItems);
            return cookingItems.subList(0, 10);
        }

        private void invalidateCache() {
            this.recipeCache.clear();
        }

        private void cacheResult(Item item, ResourceLocation res) {
            if (item == null || res == null) {
                return;
            }
            this.recipeCache.add((Pair<Item, ResourceLocation>)Pair.of((Object)item, (Object)res));
        }

        @Nullable
        private ResourceLocation getCachedRecipeLoc(Item item) {
            for (Pair<Item, ResourceLocation> pair : this.recipeCache) {
                if (pair.getLeft() != item) continue;
                return (ResourceLocation)pair.getRight();
            }
            return null;
        }
    }
}

