/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.entity.ai.triggerable.DogWantAttentionAction;
import doggytalents.common.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DogBeingPetGoal
extends Goal {
    private Dog dog;
    private boolean petEnd = false;
    private boolean startInterupt = false;
    private int petEndTickLeft = 0;
    private DogAnimation currentLoopAnim = DogAnimation.FACERUB_PP;
    private static final List<DogAnimation> facerubloopAnims_p_pp = List.of(DogAnimation.FACERUB_PP, DogAnimation.FACERUB_PP2, DogAnimation.FACERUB_P, DogAnimation.FACERUB_P2);
    private static final List<DogAnimation> facerubloopAnims_f_ff = List.of(DogAnimation.FACERUB_F, DogAnimation.FACERUB_F2, DogAnimation.FACERUB_F, DogAnimation.FACERUB_FF2);
    private static final List<DogAnimation> hugloopAnims_p_pp = List.of(DogAnimation.HUG_PP, DogAnimation.HUG_PP2, DogAnimation.HUG_P, DogAnimation.HUG_P2);
    private static final List<DogAnimation> hugloopAnims_f_ff = List.of(DogAnimation.HUG_F, DogAnimation.HUG_F2, DogAnimation.HUG_F, DogAnimation.HUG_FF2);
    private static final List<DogAnimation> bellyloopAnims_p_pp = List.of(DogAnimation.BELLY_PET_PP, DogAnimation.BELLY_PET_PP2, DogAnimation.BELLY_PET_P, DogAnimation.BELLY_PET_P2);
    private static final List<DogAnimation> bellyloopAnims_f_ff = List.of(DogAnimation.BELLY_PET_F, DogAnimation.BELLY_PET_F2, DogAnimation.BELLY_PET_FF, DogAnimation.BELLY_PET_FF2);
    private static final List<DogAnimation> backhugloopAnims_p_pp = List.of(DogAnimation.BACKHUG_PP, DogAnimation.BACKHUG_PP2, DogAnimation.BACKHUG_P, DogAnimation.BACKHUG_P2);
    private static final List<DogAnimation> backhugloopAnims_f_ff = List.of(DogAnimation.BACKHUG_F, DogAnimation.BACKHUG_F2, DogAnimation.BACKHUG_F, DogAnimation.BACKHUG_FF2);
    private DogPettingManager.DogPettingType currentType = DogPettingManager.DogPettingType.FACERUB;
    private int tickTillChangeLoop = 0;
    private int petTick_ff_threshold = 0;
    private int petTick = 0;
    private int sound_cooldown;
    private int triggerCooldown;
    private boolean startWithBellyRub = false;

    public DogBeingPetGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.m_21827_()) {
            return false;
        }
        if (!this.dog.pettingManager.isPetting()) {
            return false;
        }
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.m_6060_()) {
            return false;
        }
        if (!DogPettingManager.isDogPoseCanPet(this.dog.getDogPose())) {
            return false;
        }
        return this.dog.m_20096_();
    }

    public boolean m_8045_() {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (!this.dog.m_21827_()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (!this.dog.m_21825_()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        return !this.petEnd || this.petEndTickLeft > 0;
    }

    public void dogBeingPetGoalPreStart() {
        DogAnimation anim = this.dog.getAnim();
        this.currentType = this.dog.getPettingState().type();
        if (this.currentType != DogPettingManager.DogPettingType.BELLY_RUB) {
            this.startWithBellyRub = false;
            return;
        }
        this.startWithBellyRub = anim == DogAnimation.BELLY_RUB || anim == DogAnimation.REST_BELLY_LOOP;
    }

    public void m_8056_() {
        this.currentType = this.dog.getPettingState().type();
        DogAnimation start_anim = this.getStartAnim();
        DogAnimation first_anim = this.getFirstAnim();
        DogAnimation end_anim = this.getEndAnim();
        this.petEndTickLeft = end_anim.getLengthTicks();
        if (this.startWithBellyRub) {
            start_anim = first_anim;
        }
        this.dog.setAnimForIdle(start_anim);
        this.currentLoopAnim = first_anim;
        this.tickTillChangeLoop = first_anim.getLengthTicks() * 3;
        this.petEnd = false;
        this.startInterupt = false;
        this.petTick = 0;
        int r = this.dog.m_217043_().m_216332_(0, 25);
        this.petTick_ff_threshold = (5 + r) * 20;
        this.sound_cooldown = 0;
        this.triggerCooldown = this.startTriggerCooldown(this.dog);
        this.dog.dogSoundManager.setAmbientLocked(true);
    }

    private void resetLoopAnim() {
        List<DogAnimation> petloopAnims_target = this.getLoopAnims_pp_p();
        if (this.petTick >= this.petTick_ff_threshold) {
            petloopAnims_target = this.getLoopAnims_ff_f();
        }
        int r_anim = this.dog.m_217043_().m_188503_(petloopAnims_target.size());
        this.currentLoopAnim = petloopAnims_target.get(r_anim);
        int r_loop_count = 1;
        this.tickTillChangeLoop = r_loop_count * this.currentLoopAnim.getLengthTicks();
    }

    public void m_8037_() {
        LivingEntity owner;
        DogAnimation end_anim = this.getEndAnim();
        DogAnimation start_anim = this.getStartAnim();
        if (this.startInterupt) {
            end_anim = this.getEndAnimWhileStartInterupt(end_anim);
        }
        if (!this.petEnd && !this.dog.pettingManager.isPetting()) {
            this.petEnd = true;
            if (this.dog.getAnim() == this.getStartAnim()) {
                this.startInterupt = true;
                end_anim = this.getEndAnimWhileStartInterupt(end_anim);
            }
            this.petEndTickLeft = end_anim.getLengthTicks();
        }
        if (this.petEnd) {
            --this.petEndTickLeft;
            if (this.dog.getAnim() != end_anim) {
                this.dog.setAnim(end_anim);
            }
            this.dog.pettingManager.setLocked(true);
            this.dog.dogSoundManager.interuptPlaying();
            return;
        }
        if (this.dog.getAnim() == DogAnimation.NONE || this.dog.getAnim() == start_anim && this.dog.animationManager.isHolding()) {
            this.dog.setAnim(this.currentLoopAnim);
        }
        if (this.dog.getAnim() == this.currentLoopAnim) {
            --this.tickTillChangeLoop;
        }
        if (this.tickTillChangeLoop <= 0) {
            this.resetLoopAnim();
            this.dog.setAnim(this.currentLoopAnim);
        }
        if ((owner = this.dog.m_269323_()) != null) {
            this.lookWhenPet(owner);
        }
        ++this.petTick;
        this.updateAmbientSound();
        this.updateTriggerNearbyDogsJealous();
        this.rejuvinateDog();
    }

    private void lookWhenPet(LivingEntity owner) {
        if (this.currentType == DogPettingManager.DogPettingType.BELLY_RUB) {
            this.lookPerpenticullarToOwner(owner);
        } else {
            this.dog.m_21563_().m_24960_((Entity)owner, 10.0f, (float)this.dog.m_8132_());
        }
    }

    private void lookPerpenticullarToOwner(LivingEntity owner) {
        Vec3 dog_pos = this.dog.m_146892_();
        Vec3 owner_pos = owner.m_20182_();
        Vec3 v_dog_owner = owner_pos.m_82546_(dog_pos);
        v_dog_owner = v_dog_owner.m_82492_(0.0, v_dog_owner.f_82480_, 0.0).m_82541_().m_82524_(90.0f).m_82549_(dog_pos);
        this.dog.m_21563_().m_24964_(v_dog_owner);
    }

    private void updateAmbientSound() {
        if (this.sound_cooldown > 0) {
            --this.sound_cooldown;
            return;
        }
        SoundEvent selectedEvent = null;
        float r = this.dog.m_217043_().m_188501_();
        if ((double)r >= 0.1) {
            return;
        }
        Pair<SoundEvent, Boolean> pair = this.dog.dogMood.getPettingAmbient();
        selectedEvent = (SoundEvent)pair.getLeft();
        boolean is_classic = (Boolean)pair.getRight();
        int n = this.sound_cooldown = is_classic ? 20 : 40;
        if (this.petTick < this.petTick_ff_threshold) {
            this.sound_cooldown = 50;
        }
        if (selectedEvent != null) {
            if (!is_classic) {
                this.dog.dogSoundManager.playInterruptible(selectedEvent, this.dog.m_6121_(), this.dog.m_6100_());
            } else {
                this.dog.m_5496_(selectedEvent, this.dog.m_6121_(), this.dog.m_6100_());
            }
        }
    }

    private void updateTriggerNearbyDogsJealous() {
        if (--this.triggerCooldown > 0) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOG_PETITNG_JEALOUS.get()).booleanValue()) {
            return;
        }
        this.triggerCooldown = this.shortTriggerCooldown(this.dog);
        Optional<Dog> target_optional = EntityUtil.getRandomEntityAround((LivingEntity)this.dog, Dog.class, 7, 1, filter_dog -> this.isTargetJealousDog((Dog)filter_dog));
        if (!target_optional.isPresent()) {
            return;
        }
        Dog target = target_optional.get();
        float r = this.dog.m_217043_().m_188501_();
        if (r > target.pettingManager.getJealousChance()) {
            return;
        }
        this.triggerCooldown = this.longTriggerCooldown(this.dog);
        LivingEntity owner = target.m_269323_();
        if (owner == null) {
            return;
        }
        target.triggerAction(new DogWantAttentionAction(target, owner));
    }

    private void rejuvinateDog() {
        if (this.dog.m_217043_().m_188503_(60) != 0) {
            return;
        }
        boolean add_hunger = this.dog.m_217043_().m_188499_();
        if (add_hunger) {
            if (this.dog.getDogHunger() < 25.0f) {
                this.dog.addHunger(1.0f);
            }
        } else if (this.dog.m_21223_() / this.dog.m_21233_() < 0.25f) {
            this.dog.m_5634_(1.0f);
        }
    }

    private int startTriggerCooldown(Dog dog) {
        return 100;
    }

    private int longTriggerCooldown(Dog dog) {
        return 200 + dog.m_217043_().m_188503_(6) * 20;
    }

    private int shortTriggerCooldown(Dog dog) {
        return 40 + dog.m_217043_().m_188503_(6) * 20;
    }

    private boolean isTargetJealousDog(Dog target) {
        if (!target.isDoingFine()) {
            return false;
        }
        if (target.isBusy()) {
            return false;
        }
        LivingEntity owner = target.m_269323_();
        if (owner == null || owner != this.dog.m_269323_()) {
            return false;
        }
        DogPettingManager pet_manager = target.pettingManager;
        if (!DogPettingManager.isDogAbleToBePet(target)) {
            return false;
        }
        return !(pet_manager.getJealousChance() <= 0.0f);
    }

    public void m_8041_() {
        DogAnimation anim = this.dog.getAnim();
        if (!anim.interupting()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        this.dog.pettingManager.stopPetting();
        this.dog.pettingManager.setLocked(false);
        this.dog.dogSoundManager.interuptPlaying();
        this.dog.dogSoundManager.setAmbientLocked(false);
    }

    public boolean m_183429_() {
        return true;
    }

    private DogAnimation getStartAnim() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return DogAnimation.HUG_START;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return DogAnimation.BACKHUG_START;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return DogAnimation.BELLY_PET_START;
        }
        return DogAnimation.FACERUB_START;
    }

    private DogAnimation getFirstAnim() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return DogAnimation.HUG_PP;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return DogAnimation.BACKHUG_PP;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return DogAnimation.BELLY_PET_PP;
        }
        return DogAnimation.FACERUB_PP;
    }

    private DogAnimation getEndAnim() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return DogAnimation.HUG_END;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return DogAnimation.BACKHUG_END;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return DogAnimation.BELLY_PET_END;
        }
        return DogAnimation.FACERUB_END;
    }

    private DogAnimation getEndAnimWhileStartInterupt(DogAnimation current) {
        return DogAnimation.FACERUB_END;
    }

    private List<DogAnimation> getLoopAnims_pp_p() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return hugloopAnims_p_pp;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return backhugloopAnims_p_pp;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return bellyloopAnims_p_pp;
        }
        return facerubloopAnims_p_pp;
    }

    private List<DogAnimation> getLoopAnims_ff_f() {
        DogPettingManager.DogPettingType type = this.currentType;
        if (type == DogPettingManager.DogPettingType.HUG) {
            return hugloopAnims_f_ff;
        }
        if (type == DogPettingManager.DogPettingType.BACK_HUG) {
            return backhugloopAnims_f_ff;
        }
        if (type == DogPettingManager.DogPettingType.BELLY_RUB) {
            return bellyloopAnims_f_ff;
        }
        return facerubloopAnims_f_ff;
    }
}

