/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public class DogFindWaterGoal
extends Goal {
    private final int SEARCH_RANGE = 12;
    private Dog dog;
    private int tickUntilSearch;
    private int tickUntilPathRecalc;
    private BlockPos waterPos;
    private Path tempPath;

    public DogFindWaterGoal(Dog dog) {
        this.dog = dog;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.dog.m_5825_()) {
            return false;
        }
        if (this.dog.shouldDogNotAfraidOfFire()) {
            return false;
        }
        if (!this.dog.m_20096_()) {
            return false;
        }
        if (!this.dog.m_6060_()) {
            return false;
        }
        this.waterPos = null;
        if (--this.tickUntilSearch <= 0) {
            this.tickUntilSearch = 5;
            this.waterPos = this.searchForWaterPos();
        }
        if (this.waterPos == null) {
            return false;
        }
        Path path = this.dog.m_21573_().m_7864_(this.waterPos, 1);
        if (path == null || !DogUtil.canPathReachTargetBlock(this.dog, path, this.waterPos, 1, 1)) {
            this.tickUntilSearch += 10;
            return false;
        }
        this.tempPath = path;
        return true;
    }

    public boolean m_8045_() {
        if (!this.dog.m_6060_()) {
            return false;
        }
        return this.waterPos != null;
    }

    public void m_8056_() {
        this.dog.m_21573_().m_26536_(this.tempPath, (double)this.dog.getUrgentSpeedModifier());
        this.tickUntilPathRecalc = 10;
        this.tempPath = null;
    }

    public void m_8041_() {
        this.tempPath = null;
    }

    public void m_8037_() {
        BlockPos dog_bp = this.dog.m_20183_();
        PathNavigation n = this.dog.m_21573_();
        if (this.isWaterPos(this.waterPos)) {
            if (n.m_26571_() && dog_bp.m_123331_((Vec3i)this.waterPos) <= 1.0) {
                this.dog.m_21566_().m_6849_((double)this.waterPos.m_123341_() + 0.5, (double)this.waterPos.m_123342_(), (double)this.waterPos.m_123343_() + 0.5, 1.0);
            }
            if (--this.tickUntilPathRecalc <= 0) {
                this.tickUntilPathRecalc = 10;
                DogUtil.moveToIfReachOrElse(this.dog, this.waterPos, this.dog.getUrgentSpeedModifier(), 1, this.dog.m_6056_(), dog1 -> {
                    this.waterPos = null;
                });
            }
        } else {
            this.waterPos = this.searchForWaterPos();
        }
    }

    private BlockPos searchForWaterPos() {
        BlockPos b0 = this.dog.m_20183_();
        BlockPos.MutableBlockPos b0m = b0.m_122032_();
        for (int inflate = 1; inflate <= 12; ++inflate) {
            int j;
            int i;
            int minX = b0.m_123341_() - inflate;
            int maxX = b0.m_123341_() + inflate;
            int minZ = b0.m_123343_() - inflate;
            int maxZ = b0.m_123343_() + inflate;
            b0m.m_142451_(minX);
            b0m.m_142443_(minZ);
            for (i = minX; i <= maxX; ++i) {
                b0m.m_142451_(i);
                for (j = -4; j <= 4; ++j) {
                    b0m.m_142448_(b0.m_123342_() + j);
                    if (!this.isWaterPos((BlockPos)b0m)) continue;
                    return b0m.m_7949_();
                }
            }
            for (i = minZ + 1; i <= maxZ; ++i) {
                b0m.m_142443_(i);
                for (j = -4; j <= 4; ++j) {
                    b0m.m_142448_(b0.m_123342_() + j);
                    if (!this.isWaterPos((BlockPos)b0m)) continue;
                    return b0m.m_7949_();
                }
            }
            for (i = maxX - 1; i >= minX; --i) {
                b0m.m_142451_(i);
                for (j = -4; j <= 4; ++j) {
                    b0m.m_142448_(b0.m_123342_() + j);
                    if (!this.isWaterPos((BlockPos)b0m)) continue;
                    return b0m.m_7949_();
                }
            }
            for (i = maxZ - 1; i >= minZ + 1; --i) {
                b0m.m_142443_(i);
                for (j = -4; j <= 4; ++j) {
                    b0m.m_142448_(b0.m_123342_() + j);
                    if (!this.isWaterPos((BlockPos)b0m)) continue;
                    return b0m.m_7949_();
                }
            }
        }
        return null;
    }

    private boolean isWaterPos(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        if (this.dog.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return true;
        }
        return this.dog.m_9236_().m_46758_(pos);
    }
}

