/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class DogLowHealthGoal {

    public static class RunAway
    extends Goal {
        public static final int CAUTIOUS_RADIUS = 6;
        private Type type = Type.OWNER;
        private Dog dog;
        private float oldWaterCost;
        private int tickTillMoveAwayRecalc = 0;
        private int tickTillCheckTeleport = 0;
        private LivingEntity owner;
        private BlockPos restrictPos;
        private Vec3 moveAwayPos;
        private List<Mob> enemies = List.of();
        private int tickTillUpdateEnemyRecalc = 0;

        public RunAway(Dog dog) {
            this.dog = dog;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.tickTillUpdateEnemyRecalc > 0) {
                --this.tickTillUpdateEnemyRecalc;
            }
            if (!this.dog.isDoingFine()) {
                return false;
            }
            if (this.dog.m_21825_()) {
                return false;
            }
            if (!this.dog.isDogLowHealth()) {
                return false;
            }
            if (this.dog.getLowHealthStrategy() != Dog.LowHealthStrategy.RUN_AWAY) {
                return false;
            }
            if (this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT, DogMode.GUARD_MINOR)) {
                return false;
            }
            if (this.dog.getMode().shouldFollowOwner()) {
                LivingEntity owner = this.dog.m_269323_();
                if (owner == null) {
                    return false;
                }
                this.owner = owner;
                this.type = Type.OWNER;
            } else {
                if (!this.dog.getMode().canWander()) {
                    return false;
                }
                if (!this.dog.m_21536_() || this.dog.m_21534_() == null) {
                    return false;
                }
                this.restrictPos = this.dog.m_21534_();
                this.type = Type.RESTRICT;
            }
            this.enemies = List.of();
            if (this.tickTillUpdateEnemyRecalc <= 0) {
                this.tickTillUpdateEnemyRecalc = 3;
                this.updateEnemies(6);
            }
            return !this.enemies.isEmpty();
        }

        public boolean m_8045_() {
            if (this.enemies.isEmpty()) {
                return false;
            }
            if (this.type == Type.OWNER) {
                if (!this.dog.getMode().shouldFollowOwner()) {
                    return false;
                }
                if (!this.owner.m_142065_()) {
                    return false;
                }
            } else {
                if (!this.dog.getMode().canWander()) {
                    return false;
                }
                if (!this.dog.m_21536_() || this.dog.m_21534_() == null) {
                    return false;
                }
                if (!this.restrictPos.equals((Object)this.dog.m_21534_())) {
                    return false;
                }
            }
            return this.dog.isDogLowHealth();
        }

        public void m_8056_() {
            this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
            this.dog.setDogFollowingSomeone(true);
            this.dog.m_21573_().m_26573_();
            this.moveAwayPos = this.findMoveAwayPos();
            if (this.moveAwayPos != null) {
                this.tickTillMoveAwayRecalc = 5;
                this.dog.m_21573_().m_26519_(this.moveAwayPos.f_82479_, this.moveAwayPos.f_82480_, this.moveAwayPos.f_82481_, (double)this.dog.getUrgentSpeedModifier());
            }
        }

        public void m_8037_() {
            PathNavigation dogNav = this.dog.m_21573_();
            if (--this.tickTillMoveAwayRecalc <= 0) {
                this.tickTillMoveAwayRecalc = 3 + this.dog.m_217043_().m_188503_(3);
                this.updateMoveAway();
                if (this.moveAwayPos != null) {
                    dogNav.m_26519_(this.moveAwayPos.f_82479_, this.moveAwayPos.f_82480_, this.moveAwayPos.f_82481_, (double)this.dog.getUrgentSpeedModifier());
                }
            }
            if (--this.tickTillCheckTeleport <= 0) {
                this.tickTillCheckTeleport = 5;
                if (this.type == Type.OWNER && this.dog.getMode().shouldFollowOwner() && this.dog.m_20280_((Entity)this.owner) > 400.0) {
                    DogUtil.dynamicSearchAndTeleportToOwnwer(this.dog, this.owner, 4);
                }
            }
        }

        private void updateEnemies(int search_radius) {
            this.enemies = this.dog.m_9236_().m_6443_(Mob.class, this.dog.m_20191_().m_82377_((double)search_radius, 3.0, (double)search_radius), mob -> mob.m_6084_() && mob.m_5448_() == this.dog);
        }

        private void updateMoveAway() {
            this.moveAwayPos = null;
            this.updateEnemies(6);
            this.moveAwayPos = this.findMoveAwayPos();
        }

        private Vec3 findMoveAwayPos() {
            Vec3 moveAwayPos;
            Vec3 centerPos = this.findAverageCenterOfAllTargetingEnemies();
            if (centerPos == null) {
                return null;
            }
            Vec3 ownerPos = this.type == Type.OWNER ? this.owner.m_20182_() : Vec3.m_82539_((Vec3i)this.restrictPos);
            Vec3 dogPos = this.dog.m_20182_();
            Vec3 avoid_offset = dogPos.m_82546_(centerPos).m_82541_().m_82490_(8.0);
            Vec3 v_dogPos_ownerPos = ownerPos.m_82546_(dogPos);
            double alpha = v_dogPos_ownerPos.m_82526_(avoid_offset) / (v_dogPos_ownerPos.m_82553_() * avoid_offset.m_82553_());
            if (alpha < -0.8) {
                moveAwayPos = this.dog.f_19797_ % 2 == 0 ? dogPos.m_82520_(avoid_offset.f_82481_, 0.0, -avoid_offset.f_82479_) : dogPos.m_82520_(-avoid_offset.f_82481_, 0.0, avoid_offset.f_82479_);
            } else {
                Vec3 avoidPos = dogPos.m_82549_(avoid_offset);
                moveAwayPos = new Vec3((avoidPos.f_82479_ + ownerPos.f_82479_) / 2.0, (avoidPos.f_82480_ + ownerPos.f_82480_) / 2.0, (avoidPos.f_82481_ + ownerPos.f_82481_) / 2.0);
            }
            return moveAwayPos;
        }

        public Vec3 findAverageCenterOfAllTargetingEnemies() {
            if (this.enemies.isEmpty()) {
                return null;
            }
            double size = this.enemies.size();
            double avg_x = 0.0;
            double avg_y = 0.0;
            double avg_z = 0.0;
            for (Mob enemy : this.enemies) {
                avg_x += enemy.m_20185_();
                avg_y += enemy.m_20186_();
                avg_z += enemy.m_20189_();
            }
            return new Vec3(avg_x /= size, avg_y /= size, avg_z /= size);
        }

        public void m_8041_() {
            this.dog.m_21573_().m_26573_();
            this.dog.setDogFollowingSomeone(false);
            this.owner = null;
            this.enemies = List.of();
            this.moveAwayPos = null;
        }

        private static enum Type {
            OWNER,
            RESTRICT;

        }
    }

    public static class StickToOwner
    extends Goal {
        private final Dog dog;
        private final float stopDist;
        private LivingEntity owner;
        private int timeToRecalcPath;
        private int tickTillSearchForTp = 0;
        private int tickTillInitTeleport = 0;
        private int tickTillInitWhine = 0;
        private float oldWaterCost;
        private boolean whine = false;

        public StickToOwner(Dog dogIn) {
            this.dog = dogIn;
            this.stopDist = 1.5f;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity owner;
            if (this.tickTillInitTeleport > 0) {
                --this.tickTillInitTeleport;
            }
            if (this.tickTillInitWhine > 0) {
                --this.tickTillInitWhine;
            }
            if ((owner = this.dog.m_269323_()) == null) {
                return false;
            }
            if (!this.dog.isDoingFine()) {
                return false;
            }
            if (!this.dog.isDogLowHealth()) {
                return false;
            }
            if (this.dog.getLowHealthStrategy() != Dog.LowHealthStrategy.STICK_TO_OWNER) {
                return false;
            }
            if (owner.m_5833_()) {
                return false;
            }
            if (this.dog.m_21825_()) {
                return false;
            }
            this.owner = owner;
            return true;
        }

        public boolean m_8045_() {
            return this.dog.isDogLowHealth();
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.dog.m_21439_(BlockPathTypes.WATER);
            this.dog.setDogFollowingSomeone(true);
            this.whine = true;
            if (this.tickTillInitTeleport <= 0) {
                this.tickTillInitTeleport = 10;
                DogUtil.dynamicSearchAndTeleportToOwnwer(this.dog, this.owner, 4);
            }
        }

        public void m_8041_() {
            double distanceToOwner;
            if (this.dog.hasBone() && (distanceToOwner = this.owner.m_20280_((Entity)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
                IThrowableItem throwableItem = this.dog.getThrowableItem();
                ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
                this.dog.m_5552_(fetchItem, 0.0f);
                this.dog.setBoneVariant(ItemStack.f_41583_);
            }
            this.owner = null;
            this.dog.m_21573_().m_26573_();
            this.dog.setDogFollowingSomeone(false);
            this.dog.setBegging(false);
            this.dog.dogSoundManager.interuptPlaying();
        }

        public void m_8037_() {
            if (this.tickTillInitWhine > 0) {
                --this.tickTillInitWhine;
            }
            if (this.dog.m_20280_((Entity)this.owner) > (double)(this.stopDist * this.stopDist)) {
                this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
                if (--this.timeToRecalcPath <= 0) {
                    this.timeToRecalcPath = 5;
                    DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 25.0, false, --this.tickTillSearchForTp <= 0, 400.0, this.dog.m_6056_());
                    if (this.tickTillSearchForTp <= 0) {
                        this.tickTillSearchForTp = 10;
                    }
                }
            } else {
                if (this.whine && this.tickTillInitWhine <= 0) {
                    this.whine = false;
                    this.owner.m_213846_((Component)Component.m_237110_((String)("dog.msg.low_health." + this.dog.m_217043_().m_188503_(4)), (Object[])new Object[]{this.dog.m_7755_()}));
                    SoundEvent sound = this.dog.dogMood.getWhineAttentionSound();
                    this.dog.dogSoundManager.playInterruptible(sound, this.dog.m_6121_(), this.dog.m_6100_());
                    this.tickTillInitWhine = 40;
                }
                this.dog.m_21563_().m_148051_((Entity)this.owner);
            }
        }
    }
}

