/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DoggyTalents;
import doggytalents.api.feature.DogMode;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.phys.AABB;

public class GuardModeGoal
extends NearestAttackableTargetGoal<Mob> {
    private final Dog dog;
    private LivingEntity owner;
    private static final int GUARD_DISTANCE_SQR = 25;
    private static final int GUARD_DISTANCE = 5;

    public GuardModeGoal(Dog dog) {
        super((Mob)dog, Mob.class, 3, false, false, e -> e instanceof Enemy);
        this.dog = dog;
    }

    public boolean m_8036_() {
        this.owner = this.dog.m_269323_();
        if (this.owner == null) {
            return false;
        }
        if (!this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT)) {
            return false;
        }
        return super.m_8036_();
    }

    protected double m_7623_() {
        return 6.0;
    }

    protected void m_26073_() {
        this.f_26050_ = this.dog.m_9236_().m_45963_(this.f_26048_, this.f_26051_, (LivingEntity)this.dog, this.owner.m_20185_(), this.owner.m_20188_(), this.owner.m_20189_(), this.m_7255_(this.m_7623_()));
    }

    public void m_8041_() {
        this.owner = null;
    }

    public static class Major
    extends Goal {
        private final Dog dog;
        private LivingEntity owner;
        private int tickUntilPathRecalc = 0;

        public Major(Dog dog) {
            this.dog = dog;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.dog.isMode(DogMode.GUARD, DogMode.GUARD_FLAT)) {
                return false;
            }
            this.owner = this.dog.m_269323_();
            if (this.owner == null) {
                return false;
            }
            LivingEntity target = this.dog.m_5448_();
            return target == null || !(target.m_20280_((Entity)this.owner) <= 25.0);
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            if (this.dog.m_20280_((Entity)this.owner) > 2.0 && --this.tickUntilPathRecalc <= 0) {
                this.tickUntilPathRecalc = 5;
                if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                    if (this.dog.m_20280_((Entity)this.owner) > 25.0) {
                        DogUtil.guessAndTryToTeleportToOwner(this.dog, this.owner, 4);
                    } else {
                        this.dog.m_21573_().m_5624_((Entity)this.owner, 1.5);
                    }
                }
            }
        }

        public void m_8041_() {
            this.owner = null;
        }
    }

    public static class Minor
    extends Goal {
        private final Dog dog;
        private LivingEntity owner;
        private LivingEntity nearestDanger;
        private int tickUntilSearch = 0;
        private int tickUntilGrowl = 0;
        private int tickUntilPathRecalc = 0;
        private final int SEARCH_RADIUS = 5;

        public Minor(Dog dog) {
            this.dog = dog;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.dog.isMode(DogMode.GUARD_MINOR)) {
                return false;
            }
            this.owner = this.dog.m_269323_();
            return this.owner != null;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            if (this.nearestDanger != null) {
                this.dog.m_21563_().m_24960_((Entity)this.nearestDanger, 10.0f, (float)this.dog.m_8132_());
            }
            if (this.dog.m_20280_((Entity)this.owner) > 2.0 && --this.tickUntilPathRecalc <= 0) {
                this.tickUntilPathRecalc = 5;
                if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                    if (this.dog.m_20280_((Entity)this.owner) > 25.0) {
                        DogUtil.guessAndTryToTeleportToOwner(this.dog, this.owner, 4);
                    } else {
                        this.dog.m_21573_().m_5624_((Entity)this.owner, 1.5);
                    }
                }
            }
            if (--this.tickUntilSearch <= 0) {
                this.tickUntilSearch = 10;
                boolean wasSafe = this.nearestDanger == null;
                this.findDanger();
                if (this.nearestDanger != null && wasSafe) {
                    this.tickUntilGrowl = 0;
                }
            }
            if (this.nearestDanger != null && --this.tickUntilGrowl <= 0) {
                this.tickUntilGrowl = 25;
                SoundEvent sound = this.dog.dogMood.getSeriousGrowl();
                this.dog.m_5496_(sound, 1.0f, (this.dog.m_217043_().m_188501_() - this.dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
            }
        }

        protected void findDanger() {
            if (this.dog.getDogLevel((Supplier)DoggyTalents.RESCUE_DOG) > 0) {
                return;
            }
            this.nearestDanger = this.dog.m_9236_().m_45963_(Mob.class, TargetingConditions.m_148352_().m_26888_(target -> {
                if (this.dog.getDogLevel((Supplier)DoggyTalents.CREEPER_SWEEPER) > 0) {
                    return target instanceof Creeper;
                }
                return target instanceof Enemy;
            }), (LivingEntity)this.dog, this.owner.m_20185_(), this.owner.m_20188_(), this.owner.m_20189_(), new AABB(this.owner.m_20183_()).m_82377_(5.0, 4.0, 5.0));
        }

        public void m_8041_() {
            this.owner = null;
        }
    }
}

