/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class DogPathNavigation
extends GroundPathNavigation
implements IDogNavLock {
    private Dog dog;
    private boolean locked;
    private boolean moveInTargetNode = false;

    public DogPathNavigation(Dog dog, Level level) {
        super((Mob)dog, level);
        this.dog = dog;
    }

    public void m_7638_() {
        super.m_7638_();
        if (this.m_26571_() && this.f_26496_ != null && this.f_26496_.m_77392_()) {
            this.m_26573_();
        }
    }

    protected void m_7636_() {
        boolean isCloseEnough;
        if (this.invalidateIfNextNodeIsTooHigh()) {
            return;
        }
        Vec3 currentPos = this.m_7475_();
        this.f_26505_ = 0.45f;
        BlockPos nextPos = this.f_26496_.m_77400_();
        double dx = Math.abs(this.f_26494_.m_20185_() - ((double)nextPos.m_123341_() + 0.5));
        double dy = Math.abs(this.f_26494_.m_20186_() - (double)nextPos.m_123342_());
        double dz = Math.abs(this.f_26494_.m_20189_() - ((double)nextPos.m_123343_() + 0.5));
        boolean bl = isCloseEnough = dx <= (double)this.f_26505_ && dy < 1.0 && dz <= (double)this.f_26505_;
        if (isCloseEnough) {
            this.f_26496_.m_77374_();
            this.checkDogAndMoveInTargetNodeWhenReach();
        }
        this.m_6481_(currentPos);
        this.dogCheckIfMissedFirstNodeAndMaybeSkip();
    }

    private void dogCheckIfMissedFirstNodeAndMaybeSkip() {
        boolean kinda_far_from_first_node;
        boolean missed_first_node;
        if (this.m_26571_()) {
            return;
        }
        Path path = this.m_26570_();
        if (path == null || path.m_77398_() < 2) {
            return;
        }
        boolean bl = missed_first_node = path.m_77399_() == 0;
        if (!missed_first_node) {
            return;
        }
        Node first_node = path.m_77375_(0);
        Node second_node = path.m_77375_(1);
        if (second_node.f_77282_ != BlockPathTypes.WALKABLE) {
            return;
        }
        double min_bb_clip = 0.1;
        double max_dist_from_first_node = 0.5 + (double)(this.dog.m_20205_() / 2.0f) - 0.1;
        double dog_dist_from_first_node_sqr = this.dog.m_20238_(new Vec3((double)first_node.f_77271_ + 0.5, this.dog.m_20186_(), (double)first_node.f_77273_ + 0.5));
        boolean bl2 = kinda_far_from_first_node = dog_dist_from_first_node_sqr > max_dist_from_first_node * max_dist_from_first_node;
        if (kinda_far_from_first_node) {
            return;
        }
        BlockPos bpos = this.dog.m_20183_();
        int y_diff = second_node.f_77272_ - bpos.m_123342_();
        if (y_diff > 0 || y_diff < -1) {
            return;
        }
        Vec3 pos = this.dog.m_20182_();
        Vec3 second_node_pos = Vec3.m_82539_((Vec3i)second_node.m_77288_());
        Vec3 dist_vec = pos.m_82546_(second_node_pos);
        double len_xz_sqr = dist_vec.f_82479_ * dist_vec.f_82479_ + dist_vec.f_82481_ * dist_vec.f_82481_;
        if (len_xz_sqr > 2.0) {
            return;
        }
        path.m_77374_();
    }

    protected boolean invalidateIfNextNodeIsTooHigh() {
        boolean is_first_fence_node;
        Path path = this.f_26496_;
        if (path == null) {
            return true;
        }
        BlockPos nextPos = path.m_77400_();
        double dy = this.dog.m_20186_() - (double)nextPos.m_123342_();
        if (dy < -1.75) {
            this.m_26573_();
            return true;
        }
        Node nextNode = path.m_77401_();
        boolean bl = is_first_fence_node = nextNode.f_77282_ == BlockPathTypes.FENCE && path.m_77399_() == 0;
        if (!is_first_fence_node && this.dog.m_21439_(nextNode.f_77282_) < 0.0f) {
            this.m_26573_();
            return true;
        }
        return false;
    }

    private void checkDogAndMoveInTargetNodeWhenReach() {
        if (!this.moveInTargetNode) {
            return;
        }
        Path path = this.f_26496_;
        if (path == null) {
            return;
        }
        if (!path.m_77392_() || path.m_77398_() <= 0 || !path.m_77403_()) {
            return;
        }
        BlockPos target = path.m_77406_();
        Node end_node = path.m_77395_();
        if (target == null || end_node == null) {
            return;
        }
        if (end_node.m_77288_().equals((Object)target)) {
            return;
        }
        BlockPathTypes type = WalkNodeEvaluator.m_77604_((BlockGetter)this.dog.m_9236_(), (BlockPos.MutableBlockPos)target.m_122032_());
        if (this.dog.m_21439_(type) < 0.0f) {
            return;
        }
        Node node = new Node(target.m_123341_(), target.m_123342_(), target.m_123343_());
        node.f_77282_ = type;
        this.f_26496_ = new Path(List.of(node), target, true);
    }

    public void setDogMoveInTargetNode() {
        this.moveInTargetNode = true;
    }

    protected boolean m_7632_() {
        return super.m_7632_() && !this.dog.isOnSwitchNavCooldown() && !this.locked;
    }

    public void m_26569_() {
        boolean prevLock = this.locked;
        this.locked = false;
        super.m_26569_();
        this.locked = prevLock;
    }

    public boolean m_26536_(@Nullable Path p_26537_, double p_26538_) {
        this.moveInTargetNode = false;
        return super.m_26536_(p_26537_, p_26538_);
    }

    protected boolean m_7367_(BlockPathTypes type) {
        if (this.dog.m_5825_()) {
            if (type == BlockPathTypes.LAVA) {
                return true;
            }
            if (type == BlockPathTypes.DAMAGE_FIRE) {
                return true;
            }
            if (type == BlockPathTypes.DANGER_FIRE) {
                return true;
            }
        }
        return super.m_7367_(type);
    }

    public boolean m_6342_(BlockPos pos) {
        if (this.dog.m_5825_() && this.f_26495_.m_6425_(pos).m_205070_(FluidTags.f_13132_)) {
            return true;
        }
        return super.m_6342_(pos);
    }

    protected PathFinder m_5532_(int p_26453_) {
        this.f_26508_ = new WalkNodeEvaluator(){

            protected double m_142213_(BlockPos pos) {
                if (DogPathNavigation.this.dog.m_5825_() && this.f_77312_.m_6425_(pos).m_205070_(FluidTags.f_13132_)) {
                    return pos.m_123342_();
                }
                return super.m_142213_(pos);
            }

            @Nullable
            protected Node m_164725_(int x, int y, int z, int floorLevel, double maxUpStep, Direction dir, BlockPathTypes centerType) {
                if (centerType == BlockPathTypes.DOOR_WOOD_CLOSED && DogPathNavigation.this.dog.canDogPassGate()) {
                    centerType = BlockPathTypes.WALKABLE;
                }
                return super.m_164725_(x, y, z, floorLevel, maxUpStep, dir, centerType);
            }

            public BlockPathTypes m_8086_(BlockGetter getter, int x, int y, int z) {
                BlockState state;
                BlockPathTypes retType = super.m_8086_(getter, x, y, z);
                if (retType == BlockPathTypes.FENCE && DogPathNavigation.this.dog.canDogPassGate() && (state = getter.m_8055_(new BlockPos(x, y, z))).m_60734_() instanceof FenceGateBlock) {
                    retType = BlockPathTypes.WALKABLE;
                }
                return retType;
            }
        };
        this.f_26508_.m_77351_(true);
        return new PathFinder(this.f_26508_, p_26453_);
    }

    @Override
    public void lockDogNavigation() {
        this.locked = true;
    }

    @Override
    public void unlockDogNavigation() {
        this.locked = false;
    }

    @Nullable
    protected Path m_148222_(@Nonnull Set<BlockPos> pos, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        this.dogThrowIfLockAndDebug();
        return super.m_148222_(pos, p_148224_, p_148225_, p_148226_, p_148227_);
    }

    private void dogThrowIfLockAndDebug() {
    }
}

