/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.talent.WolfMountTalent;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DogGoAndCarryPlayerAction
extends TriggerableAction {
    @Nonnull
    private final LivingEntity owner;
    private int timeout;
    private int tickTillPathRecalc;
    private static final int force_ride_distance = 2;

    public DogGoAndCarryPlayerAction(Dog dog, LivingEntity owner) {
        super(dog, false, false);
        this.owner = owner;
    }

    @Override
    public void onStart() {
        this.timeout = 100;
        this.tickTillPathRecalc = 8;
    }

    @Override
    public void tick() {
        if (!WolfMountTalent.isValidCarryMeDog(this.dog)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!WolfMountTalent.isValidCarryMeTarget(this.owner)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (--this.timeout <= 0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        double dist_sqr = this.dog.m_20280_((Entity)this.owner);
        if (dist_sqr <= 4.0) {
            this.owner.m_20329_((Entity)this.dog);
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
        if (--this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 20;
            DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 400.0, false, false, 400.0, this.dog.m_6056_());
        }
    }

    @Override
    public void onStop() {
    }

    @Override
    public boolean canOverrideSit() {
        return true;
    }

    @Override
    public boolean goBackToSitPosWhenFinished() {
        return false;
    }
}

