/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.api.registry.Talent;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.talent.OokamiKazeTalent;
import doggytalents.common.util.DogUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DogGunpowderProjectile
extends ThrowableProjectile {
    private int tickTillScan = 0;

    public DogGunpowderProjectile(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public DogGunpowderProjectile(Level worldIn, LivingEntity livingEntityIn) {
        super((EntityType)DoggyEntityTypes.DOG_GUNPOWDER_PROJ.get(), livingEntityIn, worldIn);
    }

    protected void m_8097_() {
    }

    protected void m_6532_(HitResult hitResult) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_19983_(new ItemStack((ItemLike)Items.f_42403_));
        }
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.scanDogAroundAndTrigger();
        }
    }

    private void scanDogAroundAndTrigger() {
        if (this.tickTillScan > 0) {
            --this.tickTillScan;
            return;
        }
        if (this.m_19749_() == null) {
            return;
        }
        Vec3 pos = this.m_20182_();
        AABB aabb = new AABB(pos.m_82520_(-5.0, -5.0, -5.0), pos.m_82520_(5.0, 0.0, 5.0));
        Vec3 moveVec = this.m_20184_();
        Vec3 moveVecXZ = new Vec3(moveVec.f_82479_, 0.0, moveVec.f_82481_).m_82541_();
        if (moveVecXZ.m_82553_() < 1.0) {
            return;
        }
        List dogs = this.m_9236_().m_6443_(Dog.class, aabb, filter_dog -> this.isValidDog((Dog)filter_dog, moveVecXZ));
        if (dogs.isEmpty()) {
            return;
        }
        this.tickTillScan = 3;
        Dog nearestDog = (Dog)dogs.get(0);
        double minDist = nearestDog.m_20280_((Entity)this);
        for (Dog dog : dogs) {
            double dist = dog.m_20280_((Entity)this);
            if (!(dist < minDist)) continue;
            nearestDog = dog;
            minDist = dist;
        }
        OokamiKazeTalent talentInst = nearestDog.getTalent((Supplier)DoggyTalents.OOKAMIKAZE).map(inst -> inst.cast(OokamiKazeTalent.class)).orElse(null);
        if (talentInst == null) {
            return;
        }
        if (!talentInst.canExplode()) {
            return;
        }
        double dy = this.m_20182_().f_82480_ - nearestDog.m_20182_().f_82480_;
        double minDistXZ = new Vec3(this.m_20182_().f_82479_ - nearestDog.m_20182_().f_82479_, 0.0, this.m_20182_().f_82481_ - nearestDog.m_20182_().f_82481_).m_82556_();
        if (minDist < 4.0) {
            nearestDog.triggerAction(talentInst.actionCreator(nearestDog, null));
            this.feedDog(nearestDog);
        } else if (dy >= 1.5 && minDistXZ >= 10.0) {
            nearestDog.triggerAction(talentInst.actionCreator(nearestDog, this));
        }
    }

    private boolean isValidDog(Dog dog, Vec3 lookVecXZ) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (dog.m_21827_()) {
            return false;
        }
        if (dog.m_269323_() != this.m_19749_()) {
            return false;
        }
        if (!this.checkIfDogCanCatch(dog, lookVecXZ) && dog.m_20280_((Entity)this) >= 4.0) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return dog.getDogLevel((Talent)DoggyTalents.OOKAMIKAZE.get()) > 0;
    }

    private boolean checkIfDogCanCatch(Dog dog, Vec3 lookVecXZ) {
        Vec3 dogPosXZ = new Vec3(dog.m_20182_().f_82479_, 0.0, dog.m_20182_().f_82481_);
        Vec3 posXZ = new Vec3(this.m_20182_().f_82479_, 0.0, this.m_20182_().f_82481_);
        double dist = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(dogPosXZ, posXZ, lookVecXZ);
        if (dist < 0.0) {
            return false;
        }
        return dist < 2.25;
    }

    public void feedDog(Dog dog) {
        if (dog.m_9236_() instanceof ServerLevel) {
            ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)Items.f_42403_));
        }
        dog.m_5496_(SoundEvents.f_11912_, dog.m_6121_(), (dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.2f + 1.0f);
        this.m_146870_();
    }
}

