/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.container;

import doggytalents.DoggyContainerTypes;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RiceMillMenu
extends AbstractContainerMenu {
    private int grainSlotEnd;
    private int bowlSlotId;
    private int outputSlotId;
    private int playerInventoryBegin;
    private Container millContainer;
    private ContainerData syncedData;
    private RiceMillBlockEntity clientMill = null;

    public RiceMillMenu(int containerId, Inventory inv, BlockPos millPos) {
        this(containerId, inv, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(2));
        Player player = inv.f_35978_;
        Level level = player.m_9236_();
        if (level.f_46443_) {
            this.findClientMill(level, millPos);
        }
    }

    private void findClientMill(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        this.clientMill = mill;
    }

    public RiceMillBlockEntity getClientMill() {
        return this.clientMill;
    }

    public RiceMillMenu(int containerId, Inventory inv, Container millContainer, ContainerData syncedData) {
        super((MenuType)DoggyContainerTypes.RICE_MILL.get(), containerId);
        RiceMillMenu.m_38869_((Container)millContainer, (int)3);
        RiceMillMenu.m_38886_((ContainerData)syncedData, (int)2);
        this.millContainer = millContainer;
        this.syncedData = syncedData;
        for (int i = 0; i < RiceMillBlockEntity.GRAIN_SLOTS.length; ++i) {
            int grainSlot = RiceMillBlockEntity.GRAIN_SLOTS[i];
            this.m_38897_(new Slot(millContainer, grainSlot, 20, 17 + (i + 1) * 18){

                public boolean m_5857_(ItemStack stack) {
                    return RiceMillBlockEntity.isInputSlotValid(stack);
                }
            });
        }
        this.grainSlotEnd = RiceMillBlockEntity.GRAIN_SLOTS.length - 1;
        Slot bowlSlot = this.m_38897_(new Slot(millContainer, 1, 58, 35){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_(Items.f_42399_);
            }
        });
        this.bowlSlotId = bowlSlot.f_40219_;
        Slot outputSlot = this.m_38897_(new Slot(millContainer, RiceMillBlockEntity.OUTPUT_SLOT[0], 116, 35){

            public boolean m_5857_(ItemStack p_40231_) {
                return false;
            }
        });
        this.outputSlotId = outputSlot.f_40219_;
        this.playerInventoryBegin = this.outputSlotId + 1;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inv, k, 8 + k * 18, 142));
        }
        this.m_38884_(syncedData);
    }

    public ItemStack m_7648_(Player player, int clickedSlotId) {
        Slot clickedSlot = (Slot)this.f_38839_.get(clickedSlotId);
        if (clickedSlot == null || !clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack clickedItem = clickedSlot.m_7993_();
        ItemStack clickedItem0 = clickedItem.m_41777_();
        boolean moveResult = false;
        moveResult = clickedSlotId >= this.playerInventoryBegin ? this.m_38903_(clickedItem, 0, this.playerInventoryBegin, false) : this.m_38903_(clickedItem, this.playerInventoryBegin, this.f_38839_.size(), false);
        if (!moveResult) {
            return ItemStack.f_41583_;
        }
        if (clickedItem.m_41619_()) {
            clickedSlot.m_5852_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        if (clickedItem.m_41613_() == clickedItem0.m_41613_()) {
            return ItemStack.f_41583_;
        }
        return clickedItem0;
    }

    public boolean m_6875_(Player player) {
        return this.millContainer.m_6542_(player);
    }

    public float getGrindProgress() {
        float grindTime = this.syncedData.m_6413_(0);
        float finishTime = this.syncedData.m_6413_(1);
        float ret = grindTime / finishTime;
        return Mth.m_14036_((float)ret, (float)0.0f, (float)1.0f);
    }
}

