/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyEntityTypes;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.event.EventHandler;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class DoggyCharmItem
extends Item
implements IDogItem {
    public DoggyCharmItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction enumfacing = context.m_43719_();
        BlockState iblockstate = world.m_8055_(blockpos);
        if (player == null) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            return InteractionResult.SUCCESS;
        }
        if (!EventHandler.isWithinTrainWolfLimit(player)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockpos1 = iblockstate.m_60812_((BlockGetter)world, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(enumfacing);
        Entity entity = ((EntityType)DoggyEntityTypes.DOG.get()).m_20592_((ServerLevel)world, itemstack, context.m_43723_(), blockpos1, MobSpawnType.SPAWN_EGG, !Objects.equals(blockpos, blockpos1) && enumfacing == Direction.UP, false);
        if (entity instanceof Dog) {
            Dog dog = (Dog)entity;
            if (player != null) {
                dog.m_7105_(true);
                dog.m_21816_(player.m_20148_());
                dog.maxHealth();
                if (((Boolean)ConfigHandler.SERVER.RANDOM_VAR_WITH_CHARM.get()).booleanValue()) {
                    dog.setDogVariant(DogVariantUtil.getRandom(dog.m_217043_()));
                }
            }
            itemstack.m_41774_(1);
            if (player instanceof ServerPlayer) {
                ServerPlayer sP = (ServerPlayer)player;
                CriteriaTriggers.f_10562_.m_285767_(sP, blockpos1, itemstack);
                sP.m_36335_().m_41524_((Item)this, 30);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (worldIn.f_46443_ || !(worldIn instanceof ServerLevel)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (playerIn == null) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        if (!EventHandler.isWithinTrainWolfLimit(playerIn)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
        }
        BlockHitResult raytraceresult = Item.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.m_82425_();
            if (!(worldIn.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos, raytraceresult.m_82434_(), itemstack)) {
                Entity entity = ((EntityType)DoggyEntityTypes.DOG.get()).m_20592_((ServerLevel)worldIn, itemstack, playerIn, blockpos, MobSpawnType.SPAWN_EGG, false, false);
                if (entity instanceof Dog) {
                    Dog dog = (Dog)entity;
                    dog.m_7105_(true);
                    dog.m_21816_(playerIn.m_20148_());
                    dog.maxHealth();
                    if (((Boolean)ConfigHandler.SERVER.RANDOM_VAR_WITH_CHARM.get()).booleanValue()) {
                        dog.setDogVariant(DogVariantUtil.getRandom(dog.m_217043_()));
                    }
                    itemstack.m_41774_(1);
                    if (playerIn instanceof ServerPlayer) {
                        ServerPlayer sP = (ServerPlayer)playerIn;
                        CriteriaTriggers.f_10562_.m_285767_(sP, blockpos, itemstack);
                    }
                    playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    playerIn.m_36335_().m_41524_((Item)this, 30);
                    return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
                }
                return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
            }
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemstack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemstack);
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player player, InteractionHand handIn) {
        if (!(dogIn instanceof Dog)) {
            return InteractionResult.FAIL;
        }
        Dog dog = (Dog)dogIn;
        if (!player.m_7500_()) {
            return InteractionResult.FAIL;
        }
        if (!player.m_6144_()) {
            return InteractionResult.FAIL;
        }
        if (!dog.canInteract((LivingEntity)player)) {
            return InteractionResult.FAIL;
        }
        if (dog.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        DogVariant current_variant = dog.dogVariant();
        DogVariant next_variant = DogVariantUtil.cycle(current_variant);
        dog.setDogVariant(next_variant);
        return InteractionResult.SUCCESS;
    }

    public boolean m_5812_(ItemStack stack) {
        return DoggyCharmItem.isCharmForcedGlint(stack) || super.m_5812_(stack);
    }

    public static boolean isCharmForcedGlint(ItemStack stack) {
        return ItemUtil.getWrappedTag(stack).m_128441_("dtn_charm_forced_glint");
    }

    public static void setCharmForcedGlint(ItemStack stack, boolean glint) {
        ItemUtil.modifyTag(stack, tg -> {
            if (glint) {
                tg.m_128379_("dtn_charm_forced_glint", true);
            } else {
                tg.m_128473_("dtn_charm_forced_glint");
            }
        });
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> components, TooltipFlag flags) {
        String desc_id = this.m_5671_(stack) + ".description";
        components.add((Component)Component.m_237115_((String)desc_id));
    }
}

