/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.screen.AllStandSwitchModeScreen;
import doggytalents.client.screen.CarryMeScreen;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.client.screen.HeelByNameScreen;
import doggytalents.client.screen.WhistleScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.DogGoBehindOwnerAction;
import doggytalents.common.entity.ai.triggerable.DogHowlAction;
import doggytalents.common.entity.ai.triggerable.DogMoveToBedAction;
import doggytalents.common.entity.misc.DoggyBeamEntity;
import doggytalents.common.talent.BedDogTalent;
import doggytalents.common.talent.MobRetrieverTalent;
import doggytalents.common.talent.RoaringGaleTalent;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.ItemUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class WhistleItem
extends Item
implements IDogItem {
    public WhistleItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player player, InteractionHand hand) {
        WhistleMode mode;
        ItemStack stack = player.m_21120_(hand);
        int id_mode = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            id_mode = stack.m_41783_().m_128445_("mode");
        }
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        return (mode = WhistleMode.VALUES[id_mode]) == WhistleMode.MOB_RETRIEVER || mode == WhistleMode.RIDE_WITH_ME || mode == WhistleMode.HOWL || mode == WhistleMode.BED_DOG_WHISTLE ? InteractionResult.FAIL : InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (world.f_46443_) {
                WhistleScreen.open(stack);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        byte id_mode = 0;
        boolean on_duty_only = false;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            id_mode = stack.m_41783_().m_128445_("mode");
        }
        if (stack.m_41782_()) {
            on_duty_only = stack.m_41783_().m_128471_("dog_on_duty_only");
        }
        List dogsList = world.m_6443_(Dog.class, player.m_20191_().m_82377_(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.m_21830_((LivingEntity)player));
        if (id_mode >= WhistleMode.VALUES.length) {
            id_mode = 0;
        }
        WhistleMode mode = WhistleMode.VALUES[id_mode];
        this.useMode(mode, on_duty_only, dogsList, world, player, hand, false);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.m_21120_(hand));
    }

    public void useMode(WhistleMode mode, boolean dogOnDutyOnly, List<Dog> dogsList, Level world, Player player, InteractionHand hand, boolean isKeyBind) {
        if (mode == null) {
            return;
        }
        switch (mode.getSound()) {
            case NONE: {
                break;
            }
            case LONG: {
                world.m_5594_(null, player.m_20183_(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.6f + world.f_46441_.m_188501_() * 0.1f, 0.8f + world.f_46441_.m_188501_() * 0.2f);
                break;
            }
            case SHORT: {
                world.m_5594_(null, player.m_20183_(), DoggySounds.WHISTLE_SHORT.get(), SoundSource.PLAYERS, 0.6f + world.f_46441_.m_188501_() * 0.1f, 0.8f + world.f_46441_.m_188501_() * 0.2f);
            }
        }
        boolean successful = false;
        switch (mode) {
            case STAND: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.m_21839_(false);
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    successful = true;
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.come"));
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HEEL: {
                if (world.f_46443_) {
                    return;
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                List<Dog> heel_list = dogsList.stream().filter(filter_dog -> {
                    if (dogOnDutyOnly && !filter_dog.dogOnDuty()) {
                        return false;
                    }
                    if (filter_dog.m_21827_()) {
                        return false;
                    }
                    if (!filter_dog.getMode().shouldFollowOwner()) {
                        return false;
                    }
                    return filter_dog.m_20280_((Entity)filter_dog.m_269323_()) > 9.0;
                }).collect(Collectors.toList());
                if (max_heel_count > 0 && heel_list.size() > max_heel_count) {
                    Collections.sort(heel_list, new EntityUtil.Sorter((Entity)player));
                    heel_list = heel_list.subList(0, max_heel_count);
                }
                if (heel_list.isEmpty()) {
                    return;
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(world, heel_list, (LivingEntity)player, 3);
                player.m_213846_((Component)Component.m_237115_((String)"dogcommand.heel"));
                return;
            }
            case STAY: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    boolean wandering_ignore;
                    if (dogOnDutyOnly && !dog.dogOnDuty()) continue;
                    boolean bl = wandering_ignore = dog.getMode().canWander() && (Boolean)ConfigHandler.SERVER.WANDERING_DOG_WHISTLE.get() == false;
                    if (wandering_ignore) continue;
                    dog.m_21839_(true);
                    dog.m_21573_().m_26573_();
                    dog.m_6710_(null);
                    successful = true;
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.stay"));
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case STOP_ATTACKING: {
                if (world.f_46443_) {
                    return;
                }
                for (Dog dog : dogsList) {
                    successful = true;
                    dog.m_6710_(null);
                }
                if (successful) {
                    player.m_213846_((Component)Component.m_237115_((String)"dogcommand.stop_attacking"));
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case SHELPERD: {
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case TACTICAL: {
                if (world.f_46443_) {
                    return;
                }
                DoggyBeamEntity doggyBeam = new DoggyBeamEntity(world, (LivingEntity)player);
                doggyBeam.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 2.0f, 1.0f);
                world.m_7967_((Entity)doggyBeam);
                player.m_36335_().m_41524_((Item)this, 10);
                return;
            }
            case ROAR: {
                Optional<Integer> cooldown_optional = RoaringGaleTalent.roar(dogsList, world, player);
                cooldown_optional.ifPresent(x -> player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), x.intValue()));
                return;
            }
            case HEEL_BY_NAME: {
                if (world.f_46443_) {
                    HeelByNameScreen.open(isKeyBind ? 200 : 0);
                }
                return;
            }
            case TO_BED: {
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                if (dogsList.isEmpty()) {
                    return;
                }
                if (player.m_9236_().f_46443_) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    BlockPos bedPos;
                    noDogs = false;
                    if (!dog.readyForNonTrivialAction() || (bedPos = (BlockPos)dog.getBedPos((ResourceKey<Level>)player.m_9236_().m_46472_()).orElse(null)) == null || dog.m_20183_().equals((Object)bedPos) && dog.m_21825_() || !(dog.m_20238_(Vec3.m_82539_((Vec3i)bedPos)) < 400.0)) continue;
                    dog.triggerActionDelayed(2, new DogMoveToBedAction(dog, bedPos, false));
                }
                return;
            }
            case GO_BEHIND: {
                if (player.m_9236_().f_46443_) {
                    return;
                }
                boolean noDogs = true;
                for (Dog dog : dogsList) {
                    LivingEntity owner;
                    if (dogOnDutyOnly && !dog.dogOnDuty() || !dog.getMode().shouldFollowOwner() || dog.m_21827_() || (owner = dog.m_269323_()) == null || dog.m_20280_((Entity)owner) > 400.0) continue;
                    dog.m_6710_(null);
                    dog.clearTriggerableAction();
                    dog.triggerAction(new DogGoBehindOwnerAction(dog, owner));
                    noDogs = false;
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HEEL_BY_GROUP: {
                if (world.f_46443_) {
                    HeelByGroupScreen.open();
                }
                return;
            }
            case MOB_RETRIEVER: {
                AABB search_area;
                Vec3 view_vec;
                Vec3 max_reach_vec;
                Vec3 max_pos;
                if (world.f_46443_) {
                    return;
                }
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                Optional<Dog> retrieverOptional = MobRetrieverTalent.chooseNearestDog(player, world);
                if (retrieverOptional.isEmpty()) {
                    return;
                }
                Dog retriever = retrieverOptional.get();
                Optional<TalentInstance> talentOptional = retriever.getTalent((Talent)DoggyTalents.MOB_RETRIEVER.get());
                if (talentOptional.isEmpty()) {
                    return;
                }
                MobRetrieverTalent talentInst = (MobRetrieverTalent)talentOptional.get();
                int reach_range = MobRetrieverTalent.getSelectTargetRange();
                Vec3 eye_pos = player.m_146892_();
                EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eye_pos, (Vec3)(max_pos = eye_pos.m_82549_(max_reach_vec = (view_vec = player.m_20252_(1.0f)).m_82490_((double)reach_range))), (AABB)(search_area = player.m_20191_().m_82369_(max_reach_vec).m_82377_(1.0, 1.0, 1.0)), e -> {
                    if (!(e instanceof LivingEntity)) {
                        return false;
                    }
                    LivingEntity living = (LivingEntity)e;
                    return talentInst.isValidTarget(retriever, living);
                }, (double)(reach_range * reach_range));
                if (hitResult == null) {
                    return;
                }
                Entity entity = hitResult.m_82443_();
                if (entity == null) {
                    return;
                }
                talentInst.setTarget(retriever, (LivingEntity)entity);
                return;
            }
            case HEEL_BY_LOOK: {
                this.heelByLook(world, player);
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case RIDE_WITH_ME: {
                this.rideWithMe(world, player);
                player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
                return;
            }
            case HOWL: {
                this.howl(world, player);
                return;
            }
            case ALL_STAND_SWITCH_MODE: {
                if (world.f_46443_) {
                    AllStandSwitchModeScreen.open(player);
                }
                return;
            }
            case SSSSSHHHH: {
                this.sssshhhh(world, player, dogsList);
                return;
            }
            case CROSS_ORIGIN_TP: {
                this.crossOriginTpForDogs(world, player, dogsList);
                return;
            }
            case BED_DOG_WHISTLE: {
                BedDogTalent.useBedDog(world, player);
                return;
            }
            case DUTY_WHISTLE: {
                this.allStandOnDuty(world, player, dogsList);
                return;
            }
            case CARRY_ME: {
                if (world.f_46443_) {
                    CarryMeScreen.open(player);
                }
                return;
            }
        }
    }

    private void rideWithMe(Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (dog.m_20159_()) {
            dog.m_19877_();
            return;
        }
        Entity vehicle = player.m_20202_();
        if (vehicle == null) {
            return;
        }
        dog.authorizeRiding();
        boolean result = dog.m_20329_(vehicle);
        if (result) {
            player.m_213846_((Component)Component.m_237110_((String)"dogcommand.ride_with_me", (Object[])new Object[]{dog.m_7755_().getString()}));
        }
    }

    private void heelByLook(Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30, filter_dog -> filter_dog.isDoingFine());
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        DogUtil.dynamicSearchAndTeleportToOwnwer(dog, (LivingEntity)player, 2);
        player.m_213846_((Component)Component.m_237110_((String)"dogcommand.heel_by_name", (Object[])new Object[]{dog.m_7755_().getString()}));
        dog.m_21839_(false);
    }

    private void howl(Level level, Player player) {
        if (level.f_46443_) {
            return;
        }
        int reach_range = 30;
        Optional<Dog> dog_optional = DogUtil.getLookingAtDog(player, 30);
        if (!dog_optional.isPresent()) {
            return;
        }
        Dog dog = dog_optional.get();
        if (!dog.readyForNonTrivialAction()) {
            return;
        }
        dog.triggerAction(new DogHowlAction(dog));
        player.m_9236_().m_5594_(null, player.m_20183_(), DoggySounds.WHISTLE_SHORT.get(), SoundSource.PLAYERS, 0.6f + player.m_9236_().f_46441_.m_188501_() * 0.1f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.2f);
    }

    private void sssshhhh(Level level, Player player, List<Dog> dogs) {
        if (level.f_46443_) {
            return;
        }
        player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
        boolean shh_ed = false;
        for (Dog dog : dogs) {
            if (!this.canShh(player, dog)) continue;
            shh_ed = true;
            dog.setSilentTickLeft(400);
        }
        if (shh_ed) {
            player.m_213846_((Component)Component.m_237115_((String)"dogcommand.ssshhh"));
            level.m_5594_(null, player.m_20183_(), DoggySounds.WHISTLE_LONG.get(), SoundSource.PLAYERS, 0.1f, 0.8f + level.f_46441_.m_188501_() * 0.2f);
        }
    }

    private void crossOriginTpForDogs(Level level, Player player, List<Dog> dogs) {
        if (level.f_46443_) {
            return;
        }
        player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
        dogs = dogs.stream().filter(x -> !x.m_21825_()).collect(Collectors.toList());
        if (dogs.isEmpty()) {
            return;
        }
        boolean all_cross_origin = true;
        for (Dog dog : dogs) {
            if (dog.crossOriginTp()) continue;
            all_cross_origin = false;
            break;
        }
        boolean switch_to = !all_cross_origin;
        for (Dog dog : dogs) {
            dog.setCrossOriginTp(switch_to);
        }
        if (switch_to) {
            player.m_213846_((Component)Component.m_237115_((String)"dogcommand.cross_origin.set"));
        } else {
            player.m_213846_((Component)Component.m_237115_((String)"dogcommand.cross_origin.unset"));
        }
    }

    private void allStandOnDuty(Level level, Player player, List<Dog> dogs) {
        if (level.f_46443_) {
            return;
        }
        player.m_36335_().m_41524_((Item)DoggyItems.WHISTLE.get(), 20);
        for (Dog dog : dogs) {
            dog.setDogOnDuty(!dog.m_21827_());
        }
    }

    private boolean canShh(Player player, Dog dog) {
        return !(dog.m_20280_((Entity)player) > 256.0);
    }

    public static boolean isDogOnDutyOnly(ItemStack stack) {
        CompoundTag tag = ItemUtil.getTag(stack);
        return tag.m_128471_("dog_on_duty_only");
    }

    public static boolean isHoldingDutyWhistle(LivingEntity entity) {
        ItemStack stack = entity.m_21205_();
        if (!stack.m_150930_((Item)DoggyItems.WHISTLE.get())) {
            return false;
        }
        int mode = 0;
        CompoundTag tag = ItemUtil.getTag(stack);
        if (tag.m_128425_("mode", 99)) {
            mode = (byte)Mth.m_14045_((int)tag.m_128445_("mode"), (int)0, (int)(WhistleMode.VALUES.length - 1));
        }
        return WhistleMode.VALUES[mode] == WhistleMode.DUTY_WHISTLE;
    }

    public String m_5671_(ItemStack stack) {
        byte mode = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128425_("mode", 99)) {
            mode = stack.m_41783_().m_128445_("mode");
        }
        return this.m_5524_() + "." + mode;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        String desc_id = this.m_5524_() + ".description";
        components.add((Component)Component.m_237115_((String)desc_id).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
    }

    public static enum WhistleMode {
        STAND(0, WhistleSound.LONG),
        HEEL(1, WhistleSound.LONG),
        STAY(2, WhistleSound.SHORT),
        STOP_ATTACKING(3, WhistleSound.SHORT),
        SHELPERD(4, WhistleSound.SHORT),
        TACTICAL(5, WhistleSound.NONE),
        ROAR(6, WhistleSound.NONE),
        HEEL_BY_NAME(7, WhistleSound.NONE),
        TO_BED(8, WhistleSound.LONG),
        GO_BEHIND(9, WhistleSound.SHORT),
        HEEL_BY_GROUP(10, WhistleSound.NONE),
        MOB_RETRIEVER(11, WhistleSound.SHORT),
        HEEL_BY_LOOK(12, WhistleSound.SHORT),
        RIDE_WITH_ME(13, WhistleSound.SHORT),
        HOWL(14, WhistleSound.NONE),
        ALL_STAND_SWITCH_MODE(15, WhistleSound.NONE),
        SSSSSHHHH(16, WhistleSound.NONE),
        CROSS_ORIGIN_TP(17, WhistleSound.SHORT),
        BED_DOG_WHISTLE(18, WhistleSound.NONE),
        DUTY_WHISTLE(19, WhistleSound.SHORT),
        CARRY_ME(20, WhistleSound.NONE);

        public static final WhistleMode[] VALUES;
        private int id;
        private WhistleSound sound;

        private WhistleMode(int id, WhistleSound sound) {
            this.id = id;
            this.sound = sound;
        }

        public int getIndex() {
            return this.id;
        }

        public WhistleSound getSound() {
            return this.sound;
        }

        public String getUnlocalisedTitle() {
            return "item.doggytalents.whistle." + this.getIndex();
        }

        public String getHelpMsg() {
            return this.getUnlocalisedTitle() + ".help";
        }

        static {
            VALUES = (WhistleMode[])Arrays.stream(WhistleMode.values()).sorted(Comparator.comparingInt(WhistleMode::getIndex)).toArray(WhistleMode[]::new);
        }
    }

    public static enum WhistleSound {
        NONE,
        SHORT,
        LONG;

    }
}

