/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogIncapMsgData;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class DogIncapMsgPackets {

    public static class Response
    implements IPacket<DogIncapMsgData.Response> {
        @Override
        public void encode(DogIncapMsgData.Response data, FriendlyByteBuf buf) {
            buf.writeInt(data.entityId);
            buf.m_130072_(data.msg, 256);
        }

        @Override
        public DogIncapMsgData.Response decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            String msg = buf.m_130136_(256);
            return new DogIncapMsgData.Response(msg, id);
        }

        @Override
        public void handle(DogIncapMsgData.Response data, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                    Minecraft mc = Minecraft.m_91087_();
                    Entity e = mc.f_91073_.m_6815_(data.entityId);
                    if (e instanceof Dog) {
                        Dog d = (Dog)e;
                        d.incapacitatedMananger.setIncapMsg(data.msg);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class Request
    extends DogPacket<DogIncapMsgData.Request> {
        @Override
        public DogIncapMsgData.Request decode(FriendlyByteBuf buf) {
            int id = buf.readInt();
            return new DogIncapMsgData.Request(id);
        }

        @Override
        public void handleDog(Dog dog, DogIncapMsgData.Request data, Supplier<NetworkEvent.Context> ctx) {
            if (dog.m_9236_().f_46443_) {
                return;
            }
            ServerPlayer sender = ctx.get().getSender();
            if (dog.m_269323_() != sender) {
                return;
            }
            String msg = dog.incapacitatedMananger.getIncapMsg();
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new DogIncapMsgData.Response(msg, dog.m_19879_()));
        }
    }
}

