/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogPettingData;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class DogPettingPacket
extends DogPacket<DogPettingData> {
    @Override
    public void encode(DogPettingData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        buf.writeBoolean(data.val);
        if (data.val) {
            buf.writeInt(data.type.getId());
        }
    }

    @Override
    public DogPettingData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        boolean val = buf.readBoolean();
        DogPettingManager.DogPettingType petting_type = val ? DogPettingManager.DogPettingType.fromId(buf.readInt()) : null;
        return new DogPettingData(entityId, val, petting_type);
    }

    @Override
    public void handleDog(Dog dogIn, DogPettingData data, Supplier<NetworkEvent.Context> ctx) {
        if (data.val) {
            dogIn.pettingManager.setPetting((Player)ctx.get().getSender(), data.type);
        } else {
            dogIn.pettingManager.stopPetting();
        }
    }
}

