/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.WhistleRequestModeData;
import doggytalents.common.util.ItemUtil;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class WhistleRequestModePacket
implements IPacket<WhistleRequestModeData> {
    @Override
    public void encode(WhistleRequestModeData data, FriendlyByteBuf buf) {
        buf.writeInt(data.id);
        buf.writeBoolean(data.dogOnDutyOnly);
    }

    @Override
    public WhistleRequestModeData decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        boolean on_duty_only = buf.readBoolean();
        return new WhistleRequestModeData(id, on_duty_only);
    }

    @Override
    public void handle(WhistleRequestModeData data, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LogicalSide side = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide();
            if (!side.isServer()) {
                return;
            }
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack stack = player.m_21205_();
            if (!(stack.m_41720_() instanceof WhistleItem)) {
                return;
            }
            CompoundTag tag = stack.m_41784_();
            tag.m_128344_("mode", (byte)data.id);
            tag.m_128379_("dog_on_duty_only", data.dogOnDutyOnly);
            ItemUtil.putTag(stack, tag);
        });
        ctx.get().setPacketHandled(true);
    }
}

