/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogFlyingMoveControl;
import doggytalents.common.entity.ai.nav.DogFlyingNavigation;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraftforge.common.ForgeMod;

public class FlyingFurballTalent
extends TalentInstance {
    private static UUID FLYING_FURBALL_BOOST_UUID = UUID.fromString("2a802049-97d0-4de5-934e-e24ed1d2ab9f");
    private static UUID FLYING_FURBALL_GRAVITY_UUID = UUID.fromString("76390e7e-e38d-4de5-8fce-83af09b03a3e");
    private DogFlyingMoveControl moveControl;
    private DogFlyingNavigation navigation;
    private boolean startedGliding = false;
    private boolean wasFlying = false;
    private int flyHoldTick = 0;
    private boolean allowFlying = true;

    public FlyingFurballTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (!(dog instanceof Dog)) {
            return;
        }
        Dog d = (Dog)dog;
        d.setAttributeModifier(Attributes.f_22280_, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
        this.moveControl = new DogFlyingMoveControl(d, this);
        this.navigation = new DogFlyingNavigation(d, dog.m_9236_());
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier(Attributes.f_22280_, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dogIn) {
        Dog d;
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        dogIn.removeAttributeModifier(Attributes.f_22280_, FLYING_FURBALL_BOOST_UUID);
        dogIn.resetMoveControl();
        dogIn.resetNavigation();
        dogIn.setDogFlying(false);
        this.stopGliding(dogIn);
        dogIn.m_20242_(false);
        if (dogIn instanceof Dog && (d = (Dog)dogIn).getAnim() == DogAnimation.FLY_AIR_BOURNE) {
            d.setAnim(DogAnimation.NONE);
        }
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        dog.f_19789_ = 0.0f;
        if (this.flyHoldTick > 0) {
            --this.flyHoldTick;
        }
        boolean isDogFlying = dog.isDogFlying();
        if (dog.m_21573_() != this.navigation && this.shouldSwitchToFlying(dog)) {
            dog.setMoveControl((MoveControl)this.moveControl);
            dog.setNavigation((PathNavigation)this.navigation);
            this.startGliding(dog);
        } else if (dog.m_21573_() == this.navigation && this.shouldSwitchAwayFromFlying(dog)) {
            dog.resetMoveControl();
            dog.resetNavigation();
            this.stopGliding(dog);
        }
        if (isDogFlying && this.shouldStopFlying(dog)) {
            dog.setDogFlying(false);
            dog.m_20242_(false);
        }
        if (!isDogFlying && this.canBeginFlying(dog)) {
            dog.setDogFlying(true);
            this.flyHoldTick = 15;
        }
        if (isDogFlying = dog.isDogFlying()) {
            if (this.wasFlying) {
                if (dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                    dog.setAnim(DogAnimation.FLY_AIR_BOURNE);
                }
            } else {
                dog.setAnim(DogAnimation.FLY_JUMP_START);
                this.wasFlying = true;
            }
        }
        if (!isDogFlying) {
            DogAnimation anim = dog.getAnim();
            if (anim == DogAnimation.FLY_AIR_BOURNE || anim == DogAnimation.FLY_JUMP_START || this.wasFlying && anim == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                dog.setAnim(DogAnimation.FLY_LANDING);
            }
            this.wasFlying = false;
        }
    }

    private boolean canBeginFlying(AbstractDog dog) {
        return dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim() && this.shouldBeFlying(dog);
    }

    private boolean shouldStopFlying(AbstractDog dog) {
        return !this.shouldBeFlying(dog);
    }

    private boolean shouldBeFlying(AbstractDog dog) {
        if (this.flyHoldTick > 0) {
            return true;
        }
        if (!dog.isDoingFine() && dog instanceof Dog) {
            Dog ddog = (Dog)dog;
            if (!ddog.incapacitatedMananger.canMove()) {
                return false;
            }
        }
        return this.allowFlying() && !dog.m_20096_() && !dog.m_21825_() && !dog.m_20159_() && !dog.m_20069_() && dog.m_21573_() == this.navigation;
    }

    private boolean shouldSwitchToFlying(AbstractDog dog) {
        return this.allowFlying() && !dog.m_21825_() && !dog.m_20159_() && !dog.m_20069_();
    }

    private boolean shouldSwitchAwayFromFlying(AbstractDog dog) {
        return !this.allowFlying();
    }

    public AttributeModifier createSpeedModifier(AbstractDog dogIn, UUID uuidIn) {
        if (this.level() > 0) {
            double speed = (double)(this.level() - 1) * 0.1;
            return new AttributeModifier(uuidIn, "Flying Furball", speed, AttributeModifier.Operation.ADDITION);
        }
        return null;
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanFly().setFallImmune();
    }

    public void startGliding(AbstractDog dog) {
        this.startedGliding = true;
        dog.setAttributeModifier((Attribute)ForgeMod.ENTITY_GRAVITY.get(), FLYING_FURBALL_GRAVITY_UUID, this::createGravityModifier);
    }

    public void stopGliding(AbstractDog dog) {
        if (!this.startedGliding) {
            return;
        }
        this.startedGliding = false;
        dog.removeAttributeModifier((Attribute)ForgeMod.ENTITY_GRAVITY.get(), FLYING_FURBALL_GRAVITY_UUID);
    }

    public AttributeModifier createGravityModifier(AbstractDog dogIn, UUID uuidIn) {
        return new AttributeModifier(uuidIn, "Flying Furball Gravity", -0.8, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.allowFlying = compound.m_128471_("allowFlying");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128379_("allowFlying", this.allowFlying);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.FLYING_FURBALL_ALLOW.get()) {
            return this.allowFlying;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.FLYING_FURBALL_ALLOW.get()) {
            this.allowFlying = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.FLYING_FURBALL_ALLOW.get());
    }

    public boolean allowFlying() {
        return this.allowFlying;
    }

    public void setAllowFlying(boolean val) {
        this.allowFlying = val;
    }
}

