/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;

public class GuardDogTalent
extends TalentInstance {
    private int cooldown;

    public GuardDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public TalentInstance copy() {
        GuardDogTalent inst = new GuardDogTalent(this.getTalent(), this.level);
        inst.cooldown = this.cooldown;
        return inst;
    }

    @Override
    public void init(AbstractDog dogIn) {
        this.cooldown = dogIn.f_19797_;
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        int timeLeft = this.cooldown - dogIn.f_19797_;
        compound.m_128405_("guardtime", timeLeft);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldown = dogIn.f_19797_ + compound.m_128451_("guardtime");
    }

    @Override
    public InteractionResultHolder<Float> gettingAttackedFrom(AbstractDog dogIn, DamageSource damageSource, float damage) {
        int timeLeft;
        if (dogIn.m_9236_().f_46443_) {
            return InteractionResultHolder.m_19098_((Object)Float.valueOf(damage));
        }
        Entity entity = damageSource.m_7639_();
        if (entity != null && (timeLeft = this.cooldown - dogIn.f_19797_) <= 0) {
            int blockChance = this.level() + (this.level() >= 5 ? 1 : 0);
            if (dogIn.m_217043_().m_188503_(12) < blockChance) {
                this.cooldown = dogIn.f_19797_ + 10;
                dogIn.m_5496_(SoundEvents.f_12018_, dogIn.m_6121_() / 2.0f, (dogIn.m_217043_().m_188501_() - dogIn.m_217043_().m_188501_()) * 0.2f + 1.0f);
                return InteractionResultHolder.m_19100_((Object)Float.valueOf(0.0f));
            }
        }
        return InteractionResultHolder.m_19098_((Object)Float.valueOf(damage));
    }
}

