/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyItems;
import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.phys.Vec3;

public class ShepherdDogTalent
extends TalentInstance {
    private List<Animal> targets = List.of();
    private static final int SEARCH_RANGE = 12;
    private static final int SEARCH_RANGE_EXT = 16;
    private static final int VALID_FOLLOWING_DISTANCE = 400;
    private int tickTillSearch;

    public ShepherdDogTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
    }

    @Override
    public void livingTick(AbstractDog abstractDog) {
        if (abstractDog.m_9236_().f_46443_) {
            return;
        }
        if (!(abstractDog instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)abstractDog;
        LivingEntity owner = dog.m_269323_();
        if (owner == null) {
            return;
        }
        if (dog.readyForNonTrivialAction() && dog.getMode() == DogMode.DOCILE && !dog.m_21827_() && --this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            this.refreshShepherdTargets(dog, 12);
            if (!this.targets.isEmpty() && EntityUtil.isHolding((Entity)owner, DoggyItems.WHISTLE.get(), nbt -> nbt.m_128441_("mode") && nbt.m_128451_("mode") == 4)) {
                if (!this.triggerShepherdAction(dog, owner)) {
                    this.targets = List.of();
                }
            } else {
                this.targets = List.of();
            }
        }
    }

    private boolean triggerShepherdAction(Dog dog, LivingEntity owner) {
        if (owner instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)owner;
            return dog.triggerAction(new ShepherdAction(dog, sP, this));
        }
        return false;
    }

    public static int getMaxFollowers(int level) {
        switch (level) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 16;
            }
        }
        return 0;
    }

    public boolean isValidAnimal(Dog dog, Animal animal) {
        if (!animal.m_6084_()) {
            return false;
        }
        if (animal.m_20145_()) {
            return false;
        }
        if (animal instanceof TamableAnimal) {
            return false;
        }
        if (animal.m_20280_((Entity)dog) > 400.0) {
            return false;
        }
        return animal.m_21574_().m_148306_((Entity)dog);
    }

    public void refreshShepherdTargets(Dog dog, int searchRange) {
        this.targets = dog.m_9236_().m_6443_(Animal.class, dog.m_20191_().m_82377_((double)searchRange, 4.0, (double)searchRange), e -> this.isValidAnimal(dog, (Animal)e));
        if (this.targets.isEmpty()) {
            return;
        }
        Collections.sort(this.targets, new EntityUtil.Sorter((Entity)dog));
        int followCap = ShepherdDogTalent.getMaxFollowers(this.level());
        if (followCap < this.targets.size()) {
            this.targets = this.targets.subList(0, Math.min(followCap, this.targets.size()));
        }
    }

    private static class ShepherdAction
    extends TriggerableAction {
        private static final int LOOK_OWNER_INTERVAL = 20;
        private final ShepherdDogTalent talentInst;
        @Nonnull
        private ServerPlayer owner;
        private int tickTillPathRecalc;
        private int tickTillLook;

        public ShepherdAction(Dog dog, @Nonnull ServerPlayer owner, ShepherdDogTalent talentInst) {
            super(dog, false, true);
            this.talentInst = talentInst;
            this.owner = owner;
        }

        @Override
        public void onStart() {
            this.tickTillPathRecalc = 0;
            this.tickTillLook = 0;
        }

        @Override
        public void tick() {
            boolean update;
            if (this.dog.getMode() != DogMode.DOCILE) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!EntityUtil.isHolding((Entity)this.owner, DoggyItems.WHISTLE.get(), nbt -> nbt.m_128441_("mode") && nbt.m_128451_("mode") == 4)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = update = --this.tickTillPathRecalc <= 0;
            if (update) {
                this.tickTillPathRecalc = 20;
            }
            if (update) {
                this.talentInst.refreshShepherdTargets(this.dog, 16);
            }
            if (this.talentInst.targets.isEmpty()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillLook <= 0) {
                this.tickTillLook = 20;
                this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
            }
            if (update) {
                this.herdTargets();
            }
        }

        private void herdTargets() {
            boolean teleport = this.owner.m_20280_((Entity)this.talentInst.targets.get(0)) > 256.0;
            for (Animal target : this.talentInst.targets) {
                double distanceAway = target.m_20280_((Entity)this.owner);
                target.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)target.m_8132_());
                if (teleport) {
                    if (target.m_21523_() || target.m_20159_()) continue;
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)target, target.m_21573_(), (LivingEntity)this.owner, 4);
                    continue;
                }
                if (distanceAway >= 25.0) {
                    if (target.m_21573_().m_5624_((Entity)this.owner, 1.2) || target.m_21523_() || target.m_20159_() || !(distanceAway >= 400.0)) continue;
                    EntityUtil.tryToTeleportNearEntity((LivingEntity)target, target.m_21573_(), (LivingEntity)this.owner, 4);
                    continue;
                }
                target.m_21573_().m_26573_();
            }
            this.moveInTheMiddleOfHerdingGroup(teleport);
            if (this.dog.m_20280_((Entity)this.owner) > 1600.0) {
                DogUtil.guessAndTryToTeleportToOwner(this.dog, (LivingEntity)this.owner, 2);
            }
            if (this.dog.m_217043_().m_188501_() < 0.15f) {
                this.dog.m_5496_(SoundEvents.f_12617_, this.dog.m_6121_() + 1.0f, (this.dog.m_217043_().m_188501_() - this.dog.m_217043_().m_188501_()) * 0.1f + 0.9f);
            }
        }

        private void moveInTheMiddleOfHerdingGroup(boolean teleport) {
            Vec3 avgPosVec = Vec3.f_82478_;
            for (Animal target : this.talentInst.targets) {
                avgPosVec = avgPosVec.m_82549_(target.m_20182_());
            }
            avgPosVec = avgPosVec.m_82490_(1.0 / (double)this.talentInst.targets.size());
            double d_avgPosX_ownerX = avgPosVec.f_82479_ - this.owner.m_20185_();
            double d_avgPosZ_ownerZ = avgPosVec.f_82481_ - this.owner.m_20189_();
            double size = Math.sqrt(d_avgPosX_ownerX * d_avgPosX_ownerX + d_avgPosZ_ownerZ * d_avgPosZ_ownerZ);
            double tpPosX = avgPosVec.f_82479_ + d_avgPosX_ownerX / size * (double)(2 + this.talentInst.targets.size() / 16);
            double tpPosZ = avgPosVec.f_82481_ + d_avgPosZ_ownerZ / size * (double)(2 + this.talentInst.targets.size() / 16);
            if (teleport) {
                EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dog.m_21573_(), new BlockPos(Mth.m_14107_((double)tpPosX), Mth.m_14107_((double)this.dog.m_20186_()), Mth.m_14107_((double)tpPosZ)), 1);
            }
            this.dog.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.dog.m_8132_());
            if (!this.dog.m_21573_().m_26519_(tpPosX, this.owner.m_20191_().f_82289_, tpPosZ, 1.0) && this.dog.m_20275_(tpPosX, this.owner.m_20191_().f_82289_, tpPosZ) > 144.0 && !this.dog.m_21523_() && !this.dog.m_20159_()) {
                EntityUtil.tryToTeleportNearEntity((LivingEntity)this.dog, this.dog.m_21573_(), new BlockPos(Mth.m_14107_((double)tpPosX), Mth.m_14107_((double)this.dog.m_20186_()), Mth.m_14107_((double)tpPosZ)), 4);
            }
        }

        @Override
        public void onStop() {
            this.talentInst.targets = List.of();
        }

        @Override
        public boolean canOverrideSit() {
            return false;
        }
    }
}

