/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyAttributes;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WolfMountTalent
extends TalentInstance {
    private static final UUID WOLF_MOUNT_JUMP = UUID.fromString("7f338124-f223-4630-8515-70ee0bfbc653");
    private int lastClickTick;

    public WolfMountTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        dogIn.setAttributeModifier((Attribute)DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier((Attribute)DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dog) {
        dog.removeAttributeModifier((Attribute)DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP);
    }

    public AttributeModifier createSpeedModifier(AbstractDog dogIn, UUID uuidIn) {
        if (this.level() > 0) {
            double speed = 0.06 * (double)this.level();
            if (this.level() >= 5) {
                speed += 0.04;
            }
            return new AttributeModifier(uuidIn, "Wolf Mount", speed, AttributeModifier.Operation.ADDITION);
        }
        return null;
    }

    @Override
    public InteractionResult processInteract(AbstractDog dog, Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (this.level() <= 0) {
            return InteractionResult.PASS;
        }
        if (dog.m_20160_() || dog.m_20159_()) {
            return InteractionResult.PASS;
        }
        if (!dog.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (player.m_20159_()) {
            return InteractionResult.PASS;
        }
        int lastClickTick0 = this.lastClickTick;
        this.lastClickTick = player.f_19797_;
        if (this.lastClickTick - lastClickTick0 > 5) {
            return InteractionResult.PASS;
        }
        if (!dog.m_9236_().f_46443_) {
            dog.m_21839_(false);
            player.m_146922_(dog.m_146908_());
            player.m_146926_(dog.m_146909_());
            player.m_20329_((Entity)dog);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void livingTick(AbstractDog dog) {
        if (dog.m_20160_() && dog.getDogHunger() < 1.0f) {
            LivingEntity control = dog.m_6688_();
            if (control != null) {
                control.m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.wolf_mount.exhausted", (Object[])new Object[]{dog.m_7755_()}));
            }
            dog.m_20153_();
        }
    }

    @Override
    public InteractionResultHolder<Float> hungerTick(AbstractDog dogIn, float hungerTick_add) {
        if (dogIn.m_6688_() != null) {
            return InteractionResultHolder.m_19090_((Object)Float.valueOf(hungerTick_add += this.level() < 5 ? 3.0f : 1.0f));
        }
        return InteractionResultHolder.m_19098_((Object)Float.valueOf(hungerTick_add));
    }

    @Override
    public InteractionResultHolder<Float> calculateFallDistance(AbstractDog dogIn, float distance) {
        if (this.level() >= 5) {
            return InteractionResultHolder.m_19090_((Object)Float.valueOf(distance - 1.0f));
        }
        return InteractionResultHolder.m_19098_((Object)Float.valueOf(0.0f));
    }

    @Override
    public InteractionResult shouldSkipAttackFrom(AbstractDog dogIn, Entity entity) {
        return dogIn.m_20365_(entity) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static boolean isValidCarryMeDog(Dog dog) {
        if (!dog.m_6084_()) {
            return false;
        }
        if (dog.m_20160_() || dog.m_20159_()) {
            return false;
        }
        return dog.getDogLevel((Supplier)DoggyTalents.WOLF_MOUNT) > 0;
    }

    public static boolean isValidCarryMeTarget(LivingEntity target) {
        if (!(target instanceof Player)) {
            return false;
        }
        if (!target.m_6084_() || target.m_5833_()) {
            return false;
        }
        return !target.m_20160_() && !target.m_20159_();
    }
}

