/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchPool;
import doggytalents.common.util.DogUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class CachedSearchUtil {
    public static void resetPool(Level level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    pool.setPoolValue(level, i, j, k, (byte)0);
                }
            }
        }
    }

    public static void populatePoolRaw(Dog dog, BlockPos targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        BlockPos b0 = targetPos;
        BlockPos bMin = b0.m_7918_(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        InferTypeContext infer_ctx = InferTypeContext.forTeleport(dog.m_269323_());
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    BlockPathTypes type = WalkNodeEvaluatorDelegate.getTypeDelegate((BlockGetter)dog.m_9236_(), bMin.m_7918_(i, j, k));
                    byte val = CachedSearchUtil.inferType(dog, type, infer_ctx);
                    pool.setPoolValue(dog.m_9236_(), i, j, k, val);
                }
            }
        }
    }

    public static void populatePoolRaw(Level level, List<Dog> dogs, BlockPos targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        BlockPos b0 = targetPos;
        BlockPos bMin = b0.m_7918_(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    BlockPathTypes type = WalkNodeEvaluatorDelegate.getTypeDelegate((BlockGetter)level, bMin.m_7918_(i, j, k));
                    byte val = CachedSearchUtil.inferType(dogs, type);
                    pool.setPoolValue(level, i, j, k, val);
                }
            }
        }
    }

    public static void populateCollideOwner(LivingEntity owner, int radiusXZ, int radiusY, CachedSearchPool pool) {
        double DISTANCE_AWAY = 1.5;
        float a1 = owner.m_6080_();
        float dx1 = -Mth.m_14031_((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = Mth.m_14089_((float)(a1 * ((float)Math.PI / 180)));
        Vec3 ownerLookUnitVector = new Vec3((double)dx1, 0.0, (double)dz1);
        Vec3 ownerPosRelative2d = new Vec3((double)radiusXZ, 0.0, (double)radiusXZ);
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int k = 0; k <= maxXZ; ++k) {
                double x = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(new Vec3((double)i, 0.0, (double)k), ownerPosRelative2d, ownerLookUnitVector);
                if (x < 0.0 || x > 1.5) continue;
                for (int j = 0; j <= maxY; ++j) {
                    pool.setPoolValue(owner.m_9236_(), i, j, k, (byte)5);
                }
            }
        }
        int cXZ = radiusXZ;
        for (int i = -1; i <= 1; ++i) {
            for (int k = -1; k <= 1; ++k) {
                for (int j = 0; j <= maxY; ++j) {
                    pool.setPoolValue(owner.m_9236_(), cXZ + i, j, cXZ + k, (byte)5);
                }
            }
        }
    }

    public static void populateBlockCollision(Dog dog, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int bbWExt = Mth.m_14165_((double)((double)(dog.m_20205_() - 1.0f) * 0.5));
        int bbHExt = Mth.m_14165_((double)((double)(dog.m_20206_() - 1.0f) * 0.5));
        if (bbWExt <= 0 && bbHExt <= 0) {
            return;
        }
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(dog.m_9236_(), i, j, k) != 2) continue;
                    for (int i1 = i - bbWExt; i1 <= i + bbWExt; ++i1) {
                        for (int j1 = j - bbHExt; j1 <= j; ++j1) {
                            for (int k1 = k - bbWExt; k1 <= k + bbWExt; ++k1) {
                                if (pool.getPoolValue(dog.m_9236_(), i1, j1, k1) == 2 || pool.getPoolValue(dog.m_9236_(), i1, j1, k1) == 6) continue;
                                pool.setPoolValue(dog.m_9236_(), i1, j1, k1, (byte)5);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateBlockCollision(Level level, List<Dog> dogs, int radiusXZ, int radiusY, CachedSearchPool pool) {
        Dog dog = DogUtil.findBiggestDog(dogs);
        int bbWExt = Mth.m_14165_((double)((double)(dog.m_20205_() - 1.0f) * 0.5));
        int bbHExt = Mth.m_14165_((double)((double)(dog.m_20206_() - 1.0f) * 0.5));
        if (bbWExt <= 0 && bbHExt <= 0) {
            return;
        }
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(level, i, j, k) != 2) continue;
                    for (int i1 = i - bbWExt; i1 <= i + bbWExt; ++i1) {
                        for (int j1 = j - bbHExt; j1 <= j; ++j1) {
                            for (int k1 = k - bbWExt; k1 <= k + bbWExt; ++k1) {
                                if (pool.getPoolValue(level, i1, j1, k1) == 2 || pool.getPoolValue(level, i1, j1, k1) == 6) continue;
                                pool.setPoolValue(level, i1, j1, k1, (byte)5);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateDangerPos(Level level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(level, i, j, k) != -1) continue;
                    for (int i1 = i - 1; i1 <= i + 1; ++i1) {
                        for (int j1 = j - 1; j1 <= j + 1; ++j1) {
                            for (int k1 = k - 1; k1 <= k + 1; ++k1) {
                                if (pool.getPoolValue(level, i1, j1, k1) != 1) continue;
                                pool.setPoolValue(level, i1, j1, k1, (byte)3);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void populateWalkablePos(Level level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    byte val = pool.getPoolValue(level, i, j, k);
                    byte val_below = pool.getPoolValue(level, i, j - 1, k);
                    if (val != 1 || val_below != 2) continue;
                    pool.setPoolValue(level, i, j, k, (byte)4);
                }
            }
        }
    }

    public static int countWalkablePos(Level level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        int count = 0;
        for (int i = 0; i <= maxXZ; ++i) {
            for (int j = 0; j <= maxY; ++j) {
                for (int k = 0; k <= maxXZ; ++k) {
                    byte val = pool.getPoolValue(level, i, j, k);
                    if (val != 4) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static void populatePool(Dog dog, BlockPos targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        CachedSearchUtil.resetPool(dog.m_9236_(), radiusXZ, radiusY, pool);
        CachedSearchUtil.populatePoolRaw(dog, targetPos, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateBlockCollision(dog, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateDangerPos(dog.m_9236_(), radiusXZ, radiusY, pool);
        CachedSearchUtil.populateWalkablePos(dog.m_9236_(), radiusXZ, radiusY, pool);
    }

    public static void populatePool(Level level, List<Dog> dogs, BlockPos targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        CachedSearchUtil.resetPool(level, radiusXZ, radiusY, pool);
        CachedSearchUtil.populatePoolRaw(level, dogs, targetPos, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateBlockCollision(level, dogs, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateDangerPos(level, radiusXZ, radiusY, pool);
        CachedSearchUtil.populateWalkablePos(level, radiusXZ, radiusY, pool);
    }

    public static List<BlockPos> collectSafePos(Level level, BlockPos targetPos, int radiusXZ, int radiusY, CachedSearchPool pool) {
        ArrayList<BlockPos> safePosList = new ArrayList<BlockPos>();
        BlockPos b0 = targetPos;
        BlockPos bMin = b0.m_7918_(-radiusXZ, -radiusY, -radiusXZ);
        int maxXZ = radiusXZ * 2 - 1;
        int maxY = radiusY * 2 - 1;
        for (int i = 1; i <= maxXZ; ++i) {
            for (int j = 1; j <= maxY; ++j) {
                for (int k = 1; k <= maxXZ; ++k) {
                    if (pool.getPoolValue(level, i, j, k) != 4) continue;
                    BlockPos pos = bMin.m_7918_(i, j, k);
                    safePosList.add(pos);
                }
            }
        }
        return safePosList;
    }

    public static BlockPos getRandomSafePosUsingPool(Dog dog, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPool(dog, targetPos, realRadiusXZ, realRadiusY);
        if (safePosList.isEmpty()) {
            return null;
        }
        int index = dog.m_217043_().m_188503_(safePosList.size());
        return safePosList.get(index);
    }

    public static BlockPos getRandomSafePosUsingPoolExcludeInfrontOfOwner(Dog dog, LivingEntity owner, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        List<BlockPos> safePosList = CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(dog, owner, targetPos, realRadiusXZ, realRadiusY);
        if (safePosList.isEmpty()) {
            return null;
        }
        int index = dog.m_217043_().m_188503_(safePosList.size());
        return safePosList.get(index);
    }

    public static List<BlockPos> getAllSafePosUsingPool(Dog dog, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(dog, targetPos, poolXZ, poolY, pool);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(dog.m_9236_(), targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static List<BlockPos> getAllSafePosUsingPoolExcludeInfrontOfOwner(Dog dog, LivingEntity owner, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(dog, targetPos, poolXZ, poolY, pool);
        CachedSearchUtil.populateCollideOwner(owner, poolXZ, poolY, pool);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(dog.m_9236_(), targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static List<BlockPos> getAllSafePosUsingPool(Level level, List<Dog> dogs, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(level, dogs, targetPos, poolXZ, poolY, pool);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(level, targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static List<BlockPos> getAllSafePosUsingPoolExcludeInfrontOfOwner(Level level, List<Dog> dogs, LivingEntity owner, BlockPos targetPos, int realRadiusXZ, int realRadiusY) {
        int poolXZ = realRadiusXZ + 1;
        int poolY = realRadiusY + 1;
        if (poolXZ > 5 || poolXZ < 0) {
            return null;
        }
        if (poolY > 3 || poolY < 0) {
            return null;
        }
        CachedSearchPool pool = new CachedSearchPool();
        CachedSearchUtil.populatePool(level, dogs, targetPos, poolXZ, poolY, pool);
        CachedSearchUtil.populateCollideOwner(owner, poolXZ, poolY, pool);
        List<BlockPos> safePosList = CachedSearchUtil.collectSafePos(level, targetPos, poolXZ, poolY, pool);
        return safePosList;
    }

    public static String dumpPool(Level level, int radiusXZ, int radiusY, CachedSearchPool pool) {
        int maxXZ = radiusXZ * 2;
        int maxY = radiusY * 2;
        StringBuilder builder = new StringBuilder();
        for (int i = maxY; i >= 0; --i) {
            builder.append("Layer " + i + ": X -> \n");
            for (int j = 0; j <= maxXZ; ++j) {
                builder.append("-" + j + "-  ");
                for (int k = 0; k <= maxXZ; ++k) {
                    builder.append(pool.getPoolValue(level, k, i, j) + ", ");
                }
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public static byte inferType(Dog dog, BlockPathTypes type, InferTypeContext context) {
        if ((type = dog.inferType(type, context)) == BlockPathTypes.WALKABLE) {
            return 4;
        }
        if (type == BlockPathTypes.OPEN) {
            return 1;
        }
        if (type.getDanger() != null) {
            return -1;
        }
        if (type == BlockPathTypes.BLOCKED) {
            return 2;
        }
        return 3;
    }

    public static byte inferType(List<Dog> dogs, BlockPathTypes type) {
        boolean all_dog_OK = true;
        for (Dog dog : dogs) {
            boolean is_ok = false;
            BlockPathTypes infer_type = dog.inferType(type, InferTypeContext.forTeleport());
            if (infer_type == BlockPathTypes.WALKABLE) {
                is_ok = true;
            }
            if (is_ok) continue;
            all_dog_OK = false;
            break;
        }
        if (all_dog_OK) {
            return 4;
        }
        if (type == BlockPathTypes.OPEN) {
            return 1;
        }
        if (type.getDanger() != null) {
            return -1;
        }
        if (type == BlockPathTypes.BLOCKED) {
            return 2;
        }
        return 3;
    }

    private static class WalkNodeEvaluatorDelegate
    extends WalkNodeEvaluator {
        private WalkNodeEvaluatorDelegate() {
        }

        public static BlockPathTypes getTypeDelegate(BlockGetter getter, BlockPos pos) {
            return WalkNodeEvaluator.m_77643_((BlockGetter)getter, (BlockPos)pos);
        }
    }
}

