/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.variant.util;

import doggytalents.DoggyRegistries;
import doggytalents.common.util.Util;
import doggytalents.common.variant.DogVariant;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.IForgeRegistry;

public class DogVariantUtil {
    public static DogVariant getDefault() {
        return DogVariant.PALE;
    }

    public static DogVariant fromSaveString(String string) {
        ResourceLocation id = null;
        try {
            id = Util.parseResource(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (id == null) {
            return DogVariantUtil.getDefault();
        }
        DogVariant variant = (DogVariant)DoggyRegistries.DOG_VARIANT.get().getValue(id);
        if (variant == null) {
            return DogVariantUtil.getDefault();
        }
        return variant;
    }

    public static String toSaveString(DogVariant variant) {
        return variant.id().toString();
    }

    public static List<DogVariant> getAll() {
        IForgeRegistry<DogVariant> variant_reg = DoggyRegistries.DOG_VARIANT.get();
        List<DogVariant> entries = variant_reg.getValues().stream().collect(Collectors.toList());
        return entries;
    }

    public static DogVariant getRandom(RandomSource random) {
        List<DogVariant> entries = DogVariantUtil.getAll();
        if (entries.isEmpty()) {
            return DogVariantUtil.getDefault();
        }
        int r = random.m_188503_(entries.size());
        return entries.get(r);
    }

    public static DogVariant cycle(DogVariant current) {
        List<DogVariant> entries = DogVariantUtil.getAll();
        if (entries.isEmpty()) {
            return DogVariantUtil.getDefault();
        }
        int current_indx = entries.indexOf(current);
        int next_indx = (current_indx + 1) % entries.size();
        DogVariant next_variant = entries.get(next_indx);
        return next_variant;
    }
}

