/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access;

import de.geheimagentnr1.dimension_access_manager.config.ServerConfig;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.ModCapabilitiesRegisterFactory;
import de.geheimagentnr1.dimension_access_manager.elements.capabilities.dimension_access.DimensionAccessType;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.IntTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class DimensionAccessCapability
implements ICapabilitySerializable<IntTag> {
    @NotNull
    public static final String registry_name = "dimension_access";
    @NotNull
    private final LazyOptional<DimensionAccessCapability> holder = LazyOptional.of(() -> this);
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private DimensionAccessType dimensionAccess;

    public DimensionAccessCapability(@NotNull ServerConfig _serverConfig) {
        this.serverConfig = _serverConfig;
        this.dimensionAccess = this.serverConfig.getDefaultDimensionAccessType();
    }

    @NotNull
    public DimensionAccessType getDimensionAccess() {
        return this.dimensionAccess;
    }

    public void setDimensionAccess(@NotNull DimensionAccessType _dimensionAccess) {
        this.dimensionAccess = _dimensionAccess;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return ModCapabilitiesRegisterFactory.DIMENSION_ACCESS.orEmpty(cap, this.holder);
    }

    @NotNull
    public IntTag serializeNBT() {
        return IntTag.m_128679_((int)this.dimensionAccess.ordinal());
    }

    public void deserializeNBT(@NotNull IntTag nbt) {
        DimensionAccessType[] dimensionAccessTypes = DimensionAccessType.values();
        int value = nbt.m_7047_();
        this.dimensionAccess = value >= 0 && value < dimensionAccessTypes.length ? dimensionAccessTypes[value] : DimensionAccessType.GRANTED;
    }

    public DimensionAccessCapability(@NotNull ServerConfig serverConfig, @NotNull DimensionAccessType dimensionAccess) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        if (dimensionAccess == null) {
            throw new NullPointerException("dimensionAccess is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
        this.dimensionAccess = dimensionAccess;
    }
}

