/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.api.ClaimedChunk;
import dev.ftb.mods.ftbchunks.api.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.net.ChunkSendingUtils;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ClaimedChunkImpl
implements ClaimedChunk {
    private ChunkTeamDataImpl teamData;
    private final ChunkDimPos pos;
    private long time;
    private long forceLoaded;
    private long forceLoadExpiryTime;

    public ClaimedChunkImpl(ChunkTeamDataImpl teamData, ChunkDimPos pos) {
        this.teamData = teamData;
        this.pos = pos;
        this.time = System.currentTimeMillis();
        this.forceLoaded = 0L;
        this.forceLoadExpiryTime = 0L;
    }

    @Override
    public ChunkTeamDataImpl getTeamData() {
        return this.teamData;
    }

    public void setTeamData(@NotNull ChunkTeamDataImpl teamData) {
        teamData.clearClaimCaches();
        this.teamData.clearClaimCaches();
        this.teamData = teamData;
    }

    @Override
    public ChunkDimPos getPos() {
        return this.pos;
    }

    @Override
    public long getTimeClaimed() {
        return this.time;
    }

    @Override
    public String getResultId() {
        return "ok";
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public MutableComponent getMessage() {
        return Component.m_237113_((String)"OK");
    }

    public void setClaimedTime(long t) {
        this.time = t;
        this.teamData.getManager().clearForceLoadedCache();
        this.teamData.clearClaimCaches();
        this.sendUpdateToAll();
    }

    @Override
    public long getForceLoadedTime() {
        return this.forceLoaded;
    }

    @Override
    public boolean isForceLoaded() {
        return this.forceLoaded > 0L;
    }

    @Override
    public boolean isActuallyForceLoaded() {
        return this.isForceLoaded() && this.teamData.canDoOfflineForceLoading();
    }

    public void setForceLoadedTime(long time) {
        if (this.forceLoaded == time) {
            return;
        }
        this.forceLoaded = time;
        this.teamData.getManager().clearForceLoadedCache();
        this.teamData.clearClaimCaches();
        this.sendUpdateToAll();
        ServerLevel level = this.teamData.getManager().getMinecraftServer().m_129880_(this.pos.dimension());
        if (level != null) {
            if (this.forceLoaded > 0L) {
                level.m_6325_(this.pos.x(), this.pos.z());
            }
            ServerChunkCache cache = level.m_7726_();
            ChunkPos chunkPos = this.pos.getChunkPos();
            if (cache != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", this.teamData.getTeamId(), chunkPos.f_45578_, chunkPos.f_45579_, this.forceLoaded > 0L);
                cache.m_8419_(false);
            } else {
                FTBChunks.LOGGER.warn("Failed to force-load chunk " + this.pos.x() + ", " + this.pos.z() + " @ " + String.valueOf(this.pos.dimension().m_135782_()) + "!");
            }
        }
    }

    public boolean canEntitySpawn(Entity entity) {
        return true;
    }

    public boolean allowExplosions() {
        return this.teamData.canExplosionsDamageTerrain();
    }

    public boolean allowMobGriefing() {
        return this.teamData.allowMobGriefing();
    }

    public void sendUpdateToAll() {
        SendChunkPacket packet = new SendChunkPacket((ResourceKey<Level>)this.pos.dimension(), this.teamData.getTeamId(), new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x(), this.pos.z(), this));
        ChunkSendingUtils.sendChunkToAll(this.teamData.getManager().getMinecraftServer(), this.teamData, packet);
    }

    @Override
    public void unload(CommandSourceStack source) {
        if (this.isForceLoaded()) {
            this.setForceLoadedTime(0L);
            ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNLOAD.invoker()).after(source, this);
            this.teamData.clearClaimCaches();
            this.teamData.markDirty();
            this.forceLoadExpiryTime = 0L;
        }
    }

    @Override
    public void unclaim(CommandSourceStack source, boolean sync) {
        this.unload(source);
        this.teamData.getManager().unregisterClaim(this.pos);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNCLAIM.invoker()).after(source, this);
        this.teamData.clearClaimCaches();
        this.teamData.markDirty();
        if (sync) {
            SendChunkPacket packet = new SendChunkPacket((ResourceKey<Level>)this.pos.dimension(), Util.f_137441_, new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x(), this.pos.z(), null));
            packet.sendToAll(source.m_81377_());
        }
    }

    @Override
    public long getForceLoadExpiryTime() {
        return this.forceLoadExpiryTime;
    }

    @Override
    public void setForceLoadExpiryTime(long forceLoadExpiryTime) {
        this.forceLoadExpiryTime = forceLoadExpiryTime;
        this.teamData.markDirty();
    }

    @Override
    public boolean hasForceLoadExpired(long now) {
        return this.forceLoadExpiryTime > 0L && this.forceLoadExpiryTime < now;
    }

    public String toString() {
        return "[ " + this.pos.toString() + " - " + String.valueOf(this.teamData) + " ]";
    }

    public CompoundTag serializeNBT() {
        SNBTCompoundTag o = new SNBTCompoundTag();
        o.singleLine();
        o.m_128405_("x", this.getPos().x());
        o.m_128405_("z", this.getPos().z());
        o.m_128356_("time", this.getTimeClaimed());
        if (this.isForceLoaded()) {
            o.m_128356_("force_loaded", this.getForceLoadedTime());
        }
        if (this.getForceLoadExpiryTime() > 0L) {
            o.m_128356_("expiry_time", this.getForceLoadExpiryTime());
        }
        return o;
    }

    public static ClaimedChunkImpl deserializeNBT(ChunkTeamDataImpl data, ResourceKey<Level> dimKey, CompoundTag tag) {
        ClaimedChunkImpl chunk = new ClaimedChunkImpl(data, new ChunkDimPos(dimKey, tag.m_128451_("x"), tag.m_128451_("z")));
        chunk.time = tag.m_128454_("time");
        chunk.forceLoaded = tag.m_128454_("force_loaded");
        chunk.forceLoadExpiryTime = tag.m_128454_("expiry_time");
        return chunk;
    }
}

