/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.pane.FramedPaneModel;

public class FramedBarsModel
extends FramedPaneModel {
    public FramedBarsModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (Utils.isY(face)) {
            FramedBarsModel.createTopBottomCenterQuad(quadMap, quad, false);
            FramedBarsModel.createTopBottomCenterQuad(quadMap, quad, true);
            if (this.north) {
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, false);
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, true);
            }
            if (this.east) {
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, false);
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, true);
            }
            if (this.south) {
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, false);
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, true);
            }
            if (this.west) {
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, false);
                FramedBarsModel.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, true);
            }
        } else {
            if (!this.isSideInset(face)) {
                FramedBarsModel.createSideEdgeQuad(quadMap, quad, false, false);
            }
            if (!this.isSideInset(face.m_122424_())) {
                FramedBarsModel.createSideEdgeQuad(quadMap, quad, false, true);
            }
            if (Utils.isX(face)) {
                FramedBarsModel.createCenterPillarQuad(quadMap.get(null), quad, this.east, this.west, this.south, this.north);
                if (this.north) {
                    FramedBarsModel.createPillarQuad(quadMap.get(null), quad, Direction.NORTH);
                    FramedBarsModel.createBarQuads(quadMap.get(null), quad, Direction.NORTH);
                }
                if (this.south) {
                    FramedBarsModel.createPillarQuad(quadMap.get(null), quad, Direction.SOUTH);
                    FramedBarsModel.createBarQuads(quadMap.get(null), quad, Direction.SOUTH);
                }
            }
            if (Utils.isZ(face)) {
                FramedBarsModel.createCenterPillarQuad(quadMap.get(null), quad, this.south, this.north, this.east, this.west);
                if (this.east) {
                    FramedBarsModel.createPillarQuad(quadMap.get(null), quad, Direction.EAST);
                    FramedBarsModel.createBarQuads(quadMap.get(null), quad, Direction.EAST);
                }
                if (this.west) {
                    FramedBarsModel.createPillarQuad(quadMap.get(null), quad, Direction.WEST);
                    FramedBarsModel.createBarQuads(quadMap.get(null), quad, Direction.WEST);
                }
            }
        }
    }

    @Override
    public boolean useSolidNoCamoModel() {
        return true;
    }

    private static void createCenterPillarQuad(List<BakedQuad> quadList, BakedQuad quad, boolean perpNeg, boolean perpPos, boolean parNeg, boolean parPos) {
        float offset;
        float maxXZ;
        if (perpNeg && perpPos && !parNeg && !parPos) {
            return;
        }
        boolean perpendicular = perpNeg || perpPos;
        boolean oneParallel = parNeg ^ parPos;
        float minXZ = perpendicular && oneParallel && !parPos ? 0.5f : 0.4375f;
        float f = maxXZ = perpendicular && oneParallel && !parNeg ? 0.5f : 0.5625f;
        if (parNeg || parPos) {
            offset = 0.5f;
        } else {
            float f2 = perpNeg ? 0.5625f : (offset = perpPos ? 0.4375f : 0.5f);
            if (Utils.isPositive(quad.m_111306_())) {
                offset = 1.0f - offset;
            }
        }
        QuadModifier.geometry(quad).apply(Modifiers.cutSide(minXZ, 0.0f, maxXZ, 1.0f)).apply(Modifiers.setPosition(offset)).export(quadList);
    }

    private static void createPillarQuad(List<BakedQuad> quadList, BakedQuad quad, Direction dir) {
        if (Utils.isY(dir)) {
            throw new IllegalArgumentException(String.format("Invalid direction: %s!", dir));
        }
        boolean positive = Utils.isPositive(dir);
        float minXZ = positive ? 0.75f : 0.125f;
        float maxXZ = positive ? 0.875f : 0.25f;
        QuadModifier.geometry(quad).apply(Modifiers.cutSide(minXZ, 0.0f, maxXZ, 1.0f)).apply(Modifiers.setPosition(0.5f)).export(quadList);
    }

    private static void createBarQuads(List<BakedQuad> quadList, BakedQuad quad, Direction dir) {
        if (Utils.isY(dir)) {
            throw new IllegalArgumentException(String.format("Invalid direction: %s!", dir));
        }
        boolean positive = Utils.isPositive(dir);
        boolean northeast = dir == Direction.NORTH || dir == Direction.EAST;
        float minXZ = positive ? 0.5625f : 0.25f;
        float maxXZ = positive ? 0.75f : 0.4375f;
        float minY = northeast ? 0.125f : 0.75f;
        float maxY = northeast ? 0.25f : 0.875f;
        QuadModifier.geometry(quad).apply(Modifiers.cutSide(minXZ, minY, maxXZ, maxY)).apply(Modifiers.setPosition(0.5f)).export(quadList);
        minXZ = positive ? 0.875f : 0.0f;
        maxXZ = positive ? 1.0f : 0.125f;
        QuadModifier.geometry(quad).apply(Modifiers.cutSide(minXZ, 0.4375f, maxXZ, 0.5625f)).apply(Modifiers.setPosition(0.5f)).export(quadList);
    }
}

