/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedVerticalSlopedStairsBlock
extends FramedBlock {
    public FramedVerticalSlopedStairsBlock() {
        super(BlockType.FRAMED_VERTICAL_SLOPED_STAIRS);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            Direction facing = ctx.m_8125_();
            state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing);
            Direction face = ctx.m_43719_();
            HorizontalRotation rot = face == facing.m_122424_() ? HorizontalRotation.fromWallCorner(ctx.m_43720_(), face) : HorizontalRotation.fromPerpendicularWallCorner(facing, face, ctx.m_43720_());
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rot));
        })).withWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        double frac;
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction face = hit.m_82434_();
        HorizontalRotation horRot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = horRot.withFacing(facing);
        Direction rotDirTwo = horRot.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        if (!Utils.isY(face) && (face == rotDir || face == rotDirTwo) && (frac = Utils.fractionInDir(hit.m_82450_(), facing.m_122424_())) >= 0.5) {
            face = Direction.UP;
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(facing));
        }
        if (face.m_122434_() == facing.m_122434_()) {
            HorizontalRotation horRot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)horRot.rotate(rot)));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        HorizontalRotation horRot;
        if (mirror == Mirror.NONE) {
            return state;
        }
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (mirror == Mirror.FRONT_BACK && Utils.isX(dir) || mirror == Mirror.LEFT_RIGHT && Utils.isZ(dir)) {
            state = (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)dir.m_122424_());
        }
        horRot = (horRot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION))).isVertical() ? horRot.rotate(Rotation.CLOCKWISE_90) : horRot.rotate(Rotation.COUNTERCLOCKWISE_90);
        state = (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)horRot));
        return state;
    }
}

